/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class HasTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object var1, String var2);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_markoX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_blahX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXblahX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXnullX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXnull_testnullkeyX();

    public abstract Traversal<Edge, Edge> get_g_E_hasXnullX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXnullX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXnull_personX();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VXv1X_hasXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasXid_lt_3X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2_3X(Object var1, Object var2, Object var3);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2_3X_inList(Object var1, Object var2, Object var3);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasIdX2_3X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasIdX2_3X_inList(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X();

    public abstract Traversal<Vertex, Vertex> get_g_V_whereXage_isXgt_30XX();

    public abstract Traversal<Vertex, Vertex> get_g_V_whereXlabel_isXsoftwareXX();

    public abstract Traversal<Edge, Edge> get_g_EX7X_hasLabelXknowsX(Object var1);

    public abstract Traversal<Edge, Edge> get_g_E_hasLabelXknowsX();

    public abstract Traversal<Edge, Edge> get_g_E_hasLabelXnullX();

    public abstract Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasLabelXnullX();

    public abstract Traversal<Edge, Edge> get_g_EX11X_outV_outE_hasXid_10X(Object var1, Object var2);

    public abstract Traversal<Edge, Edge> get_g_E_hasLabelXuses_traversesX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXperson_software_blahX();

    public abstract Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outE_hasXweight_inside_0_06X_inV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXlocationX();

    public abstract Traversal<Vertex, Vertex> get_g_V_in_hasIdXneqX1XX(Object var1);

    public abstract Traversal<Vertex, String> get_g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name();

    public abstract Traversal<Vertex, Integer> get_g_V_both_properties_dedup_hasKeyXageX_value();

    public abstract Traversal<Vertex, Integer> get_g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value();

    public abstract Traversal<Vertex, Double> get_g_V_bothE_properties_dedup_hasKeyXweightX_value();

    public abstract Traversal<Vertex, Double> get_g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value();

    public abstract Traversal<Vertex, String> get_g_V_hasNotXageX_name();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasIdX1X_hasIdX2X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXpersonX_hasLabelXsoftwareX();

    public abstract Traversal<Vertex, Long> get_g_V_hasIdXemptyX_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasIdXwithinXemptyXX_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasIdXwithoutXemptyXX_count();

    public abstract Traversal<Vertex, Long> get_g_V_notXhasIdXwithinXemptyXXX_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasXage_withinX27X_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasXage_withinX27_29X_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasXage_withoutX27X_count();

    public abstract Traversal<Vertex, Long> get_g_V_hasXage_withoutX27_29X_count();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_containingXarkXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_startingWithXmarXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_endingWithXasXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_not_containingXarkXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_not_startingWithXmarXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_not_endingWithXasXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_regexXrMarXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_notRegexXrMarXX();

    public abstract Traversal<Vertex, String> get_g_V_hasXname_regexXTinkerXX();

    public abstract Traversal<Vertex, String> get_g_V_hasXname_regexXTinkerUnicodeXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXperson_name_containingXoX_andXltXmXXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_gtXmX_andXcontainingXoXXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXp_neqXvXX();

    public abstract Traversal<Vertex, String> get_g_V_hasXk_withinXcXX_valuesXkX();

    public abstract Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasKeyXnullX();

    public abstract Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasKeyXnull_nullX();

    public abstract Traversal<Vertex, Integer> get_g_V_properties_hasKeyXnull_ageX_value();

    public abstract Traversal<Edge, ? extends Property<Object>> get_g_E_properties_hasKeyXnullX();

    public abstract Traversal<Edge, ? extends Property<Object>> get_g_E_properties_hasKeyXnull_nullX();

    public abstract Traversal<Edge, Double> get_g_E_properties_hasKeyXnull_weightX_value();

    public abstract Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasValueXnullX();

    public abstract Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasValueXnull_nullX();

    public abstract Traversal<Vertex, String> get_g_V_properties_hasValueXnull_joshX_value();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXnameX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "name");
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXcircumferenceX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "circumference");
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX2X_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_markoX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_blahX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXage_gt_30X();
        this.printTraversalForm(traversal);
        List list = traversal.toList();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Element v : list) {
            Assert.assertTrue(((Integer)v.value("age") > 30 ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_isXgt_30XX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_whereXage_isXgt_30XX();
        this.printTraversalForm(traversal);
        List list = traversal.toList();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Element v : list) {
            Assert.assertTrue(((Integer)v.value("age") > 30 ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXlabel_isXsoftwareXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_whereXlabel_isXsoftwareXX();
        this.printTraversalForm(traversal);
        List list = traversal.toList();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Element v : list) {
            Assert.assertEquals((Object)"software", (Object)v.label());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversalMarko = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversalMarko);
        Assert.assertFalse((boolean)traversalMarko.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversalJosh = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("josh"));
        this.printTraversalForm(traversalJosh);
        Assert.assertTrue((boolean)traversalJosh.hasNext());
        traversalJosh.iterate();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VXv1X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversalMarko = this.get_g_VXv1X_hasXage_gt_30X(this.convertToVertex(this.graph, "marko"));
        this.printTraversalForm(traversalMarko);
        Assert.assertFalse((boolean)traversalMarko.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VXv4X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversalJosh = this.get_g_VXv1X_hasXage_gt_30X(this.convertToVertex(this.graph, "josh"));
        this.printTraversalForm(traversalJosh);
        Assert.assertTrue((boolean)traversalJosh.hasNext());
        traversalJosh.iterate();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2X(this.convertToVertexId("marko"), this.convertToVertexId("vadas"));
        this.assertVadasAsOnlyValueReturned(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void g_VX1X_out_hasXid_lt_3X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasXid_lt_3X(this.convertToVertexId("marko"), this.convertToVertexId("lop"));
        this.assertVadasAsOnlyValueReturned(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1AsStringX_out_hasXid_2AsStringX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2X(this.convertToVertexId("marko").toString(), this.convertToVertexId("vadas").toString());
        this.assertVadasAsOnlyValueReturned(traversal);
    }

    private void assertVadasAsOnlyValueReturned(Traversal<Vertex, Vertex> traversal) {
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)((Vertex)traversal.next()).id());
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2_3X() {
        Object id2 = this.convertToVertexId("vadas");
        Object id3 = this.convertToVertexId("lop");
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2_3X(this.convertToVertexId("marko"), id2, id3);
        this.assert_g_has_2id(id2, id3, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2AsString_3AsStringX() {
        Object id2 = this.convertToVertexId("vadas");
        Object id3 = this.convertToVertexId("lop");
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2_3X(this.convertToVertexId("marko"), id2.toString(), id3.toString());
        this.assert_g_has_2id(id2, id3, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2_3X_inList() {
        Object id2 = this.convertToVertexId("vadas");
        Object id3 = this.convertToVertexId("lop");
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2_3X_inList(this.convertToVertexId("marko"), id2, id3);
        this.assert_g_has_2id(id2, id3, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXid_1_2X() {
        Object id1 = this.convertToVertexId("marko");
        Object id2 = this.convertToVertexId("vadas");
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasIdX2_3X(id1, id2);
        this.assert_g_has_2id(id1, id2, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXid_1_2X_inList() {
        Object id1 = this.convertToVertexId("marko");
        Object id2 = this.convertToVertexId("vadas");
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasIdX2_3X_inList(id1, id2);
        this.assert_g_has_2id(id1, id2, traversal);
    }

    protected void assert_g_has_2id(Object id1, Object id2, Traversal<Vertex, Vertex> traversal) {
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        MatcherAssert.assertThat((Object)((Vertex)traversal.next()).id(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)id1), CoreMatchers.is((Object)id2)}));
        MatcherAssert.assertThat((Object)((Vertex)traversal.next()).id(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)id1), CoreMatchers.is((Object)id2)}));
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXblahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXblahX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXnullX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXnull_testnullkeyX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXnull_testnullkeyX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_hasXnullX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXnullX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXnull_personX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXnull_personX();
        this.printTraversalForm(traversal);
        List vertices = traversal.toList();
        Assert.assertEquals((long)4L, (long)vertices.size());
        MatcherAssert.assertThat((Object)vertices.stream().allMatch(v -> v.label().equals("person")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX7X_hasLabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_EX7X_hasLabelXknowsX(this.convertToEdgeId("marko", "knows", "vadas"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_hasLabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasLabelXknowsX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_hasLabelXnullX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasLabelXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasLabelXnullX() {
        Traversal<Vertex, ? extends Property<Object>> traversal = this.get_g_V_properties_hasLabelXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_E_hasLabelXuses_traversesX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasLabelXuses_traversesX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Edge)traversal.next()).label();
            Assert.assertTrue((label.equals("uses") || label.equals("traverses") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)9L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_hasLabelXperson_software_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXperson_software_blahX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Vertex)traversal.next()).label();
            Assert.assertTrue((label.equals("software") || label.equals("person") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXperson_name_markoX_age() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_hasXperson_name_markoX_age();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)29L, (long)((Integer)traversal.next()).intValue());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_hasXweight_inside_0_06X_inV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outE_hasXweight_inside_0_06X_inV(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            Assert.assertTrue((vertex.value("name").equals("vadas") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX11X_outV_outE_hasXid_10X() {
        Object edgeId11 = this.convertToEdgeId("josh", "created", "lop");
        Object edgeId10 = this.convertToEdgeId("josh", "created", "ripple");
        Traversal<Edge, Edge> traversal = this.get_g_EX11X_outV_outE_hasXid_10X(edgeId11, edgeId10);
        this.printTraversalForm(traversal);
        this.assert_g_EX11X(edgeId10, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX11X_outV_outE_hasXid_10AsStringX() {
        Object edgeId11 = this.convertToEdgeId("josh", "created", "lop");
        Object edgeId10 = this.convertToEdgeId("josh", "created", "ripple");
        Traversal<Edge, Edge> traversal = this.get_g_EX11X_outV_outE_hasXid_10X(edgeId11.toString(), edgeId10.toString());
        this.printTraversalForm(traversal);
        this.assert_g_EX11X(edgeId10, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_hasXlocationX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXlocationX();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(this.convertToVertex(this.graph, "marko"), this.convertToVertex(this.graph, "stephen"), this.convertToVertex(this.graph, "daniel"), this.convertToVertex(this.graph, "matthias")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList("peter", "vadas"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_in_hasIdXneqX1XX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_in_hasIdXneqX1XX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            Assert.assertTrue((vertex.value("name").equals("josh") || vertex.value("name").equals("peter") ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    private void assert_g_EX11X(Object edgeId, Traversal<Edge, Edge> traversal) {
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Edge e = (Edge)traversal.next();
        Assert.assertEquals((Object)edgeId, (Object)e.id());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_dedup_properties_hasKeyXageX_value() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_both_properties_dedup_hasKeyXageX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(29, 27, 32, 35), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(32, 35), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_bothE_properties_dedup_hasKeyXweightX_value() {
        Traversal<Vertex, Double> traversal = this.get_g_V_bothE_properties_dedup_hasKeyXweightX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(0.5, 1.0, 0.4, 0.2), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value() {
        Traversal<Vertex, Double> traversal = this.get_g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(0.2), traversal);
    }

    @Test
    @LoadGraphWith
    public void g_V_hasNotXageX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_hasNotXageX_name();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList("lop", "ripple"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasIdX1X_hasIdX2X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasIdX1X_hasIdX2X(this.convertToVertexId("marko"), this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_hasLabelXsoftwareX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXpersonX_hasLabelXsoftwareX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasIdXemptyX_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasIdXemptyX_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)0L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasIdXwithinXemptyXX_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasIdXwithinXemptyXX_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)0L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasIdXwithoutXemptyXX_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasIdXwithoutXemptyXX_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)6L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_notXhasIdXwithinXemptyXXX_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_notXhasIdXwithinXemptyXXX_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)6L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_withinX27X_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasXage_withinX27X_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)1L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_withinX27_29X_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasXage_withinX27_29X_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)2L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_withoutX27X_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasXage_withoutX27X_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)3L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_withoutX27_29X_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_hasXage_withoutX27_29X_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)2L, (long)((Long)traversal.next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_containingXarkXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_containingXarkXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("marko"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_startingWithXmarXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_startingWithXmarXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("marko"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_endingWithXasXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_endingWithXasXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("vadas"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_not_containingXarkXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_not_containingXarkXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertNotEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        }
        Assert.assertEquals((long)5L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_not_startingWithXmarXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_not_startingWithXmarXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertNotEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        }
        Assert.assertEquals((long)5L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_not_endingWithXasXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_not_endingWithXasXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertNotEquals((Object)"vadas", (Object)((Vertex)traversal.next()).value("name"));
        }
        Assert.assertEquals((long)5L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_regexXrMarXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_regexXrMarXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("marko"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_notRegexXrMarXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_notRegexXrMarXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertNotEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        }
        Assert.assertEquals((long)5L, (long)counter);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
    public void g_V_hasXname_regexXTinkerXX() {
        this.g.addV("software").property((Object)"name", (Object)"Apache TinkerPop\u00a9", new Object[0]).iterate();
        Traversal<Vertex, String> traversal = this.get_g_V_hasXname_regexXTinkerXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((String)traversal.next()).equals("Apache TinkerPop\u00a9"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
    public void g_V_hasXname_regexXTinkerUnicodeXX() {
        this.g.addV("software").property((Object)"name", (Object)"Apache TinkerPop\u00a9", new Object[0]).iterate();
        Traversal<Vertex, String> traversal = this.get_g_V_hasXname_regexXTinkerUnicodeXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((String)traversal.next()).equals("Apache TinkerPop\u00a9"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXperson_name_containingXoX_andXltXmXXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXperson_name_containingXoX_andXltXmXXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("josh"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_gtXmX_andXcontainingXoXXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_gtXmX_andXcontainingXoXXX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)((Vertex)traversal.next()).value("name").equals("marko"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXp_neqXvXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXp_neqXvXX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
    public void g_V_hasXk_withinXcXX_valuesXkX() {
        this.g.addV().property((Object)"k", (Object)"\u8f49\u6ce8", new Object[0]).addV().property((Object)"k", (Object)"\u2726", new Object[0]).addV().property((Object)"k", (Object)"\u2660", new Object[0]).addV().property((Object)"k", (Object)"A", new Object[0]).iterate();
        Traversal<Vertex, String> traversal = this.get_g_V_hasXk_withinXcXX_valuesXkX();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList("\u8f49\u6ce8", "\u2726", "\u2660"), traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasKeyXnullX() {
        Traversal<Vertex, ? extends Property<Object>> traversal = this.get_g_V_properties_hasKeyXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasKeyXnull_nullX() {
        Traversal<Vertex, ? extends Property<Object>> traversal = this.get_g_V_properties_hasKeyXnull_nullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasKeyXnull_ageX_value() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_properties_hasKeyXnull_ageX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(27, 29, 32, 35), traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_properties_hasKeyXnullX() {
        Traversal<Edge, ? extends Property<Object>> traversal = this.get_g_E_properties_hasKeyXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_properties_hasKeyXnull_nullX() {
        Traversal<Edge, ? extends Property<Object>> traversal = this.get_g_E_properties_hasKeyXnull_nullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_properties_hasKeyXnull_weightX_value() {
        Traversal<Edge, Double> traversal = this.get_g_E_properties_hasKeyXnull_weightX_value();
        this.printTraversalForm(traversal);
        HasTest.checkResults(Arrays.asList(0.5, 1.0, 1.0, 0.4, 0.4, 0.2), traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasValueXnullX() {
        Traversal<Vertex, ? extends Property<Object>> traversal = this.get_g_V_properties_hasValueXnullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasValueXnull_nullX() {
        Traversal<Vertex, ? extends Property<Object>> traversal = this.get_g_V_properties_hasValueXnull_nullX();
        this.printTraversalForm(traversal);
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_properties_hasValueXnull_joshX_value() {
        Traversal<Vertex, String> traversal = this.get_g_V_properties_hasValueXnull_joshX_value();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"josh", (Object)traversal.next());
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static class Traversals
    extends HasTest {
        @Override
        public Traversal<Edge, Edge> get_g_EX11X_outV_outE_hasXid_10X(Object e11Id, Object e10Id) {
            return this.g.E(new Object[]{e11Id}).outV().outE().has(T.id, e10Id);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object v1Id, String key) {
            return this.g.V(new Object[]{v1Id}).has(key);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_markoX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_blahX() {
            return this.g.V(new Object[0]).has("name", (Object)"blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXblahX() {
            return this.g.V(new Object[0]).has("blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXnullX() {
            return this.g.V(new Object[0]).has(null);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXnull_testnullkeyX() {
            return this.g.V(new Object[0]).has((String)null, (Object)"test-null-key");
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasXnullX() {
            return this.g.E(new Object[0]).has(null);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXnullX() {
            return this.g.V(new Object[0]).hasLabel(null);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXnull_personX() {
            return this.g.V(new Object[0]).hasLabel(null, new String[]{"person"});
        }

        @Override
        public Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasLabelXnullX() {
            return this.g.V(new Object[0]).properties(new String[0]).hasLabel(null);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("age", P.gt((Object)30));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VXv1X_hasXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("age", P.gt((Object)30));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasXid_lt_3X(Object v1Id, Object v3Id) {
            return this.g.V(new Object[]{v1Id}).out().has(T.id, P.lt((Object)v3Id));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[]{v1Id}).out().hasId(v2Id, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2_3X(Object v1Id, Object v2Id, Object v3Id) {
            return this.g.V(new Object[]{v1Id}).out().hasId(v2Id, new Object[]{v3Id});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2_3X_inList(Object v1Id, Object v2Id, Object v3Id) {
            return this.g.V(new Object[]{v1Id}).out().hasId(Arrays.asList(v2Id, v3Id), new Object[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasIdX2_3X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[0]).hasId(v1Id, new Object[]{v2Id});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasIdX2_3X_inList(Object v1Id, Object v2Id) {
            return this.g.V(new Object[0]).hasId(Arrays.asList(v1Id, v2Id), new Object[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X() {
            return this.g.V(new Object[0]).has("age", P.gt((Object)30));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_whereXage_isXgt_30XX() {
            return this.g.V(new Object[0]).where((Traversal)__.values((String[])new String[]{"age"}).is(P.gt((Object)30)));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_whereXlabel_isXsoftwareXX() {
            return this.g.V(new Object[0]).where((Traversal)__.label().is((Object)"software"));
        }

        @Override
        public Traversal<Edge, Edge> get_g_EX7X_hasLabelXknowsX(Object e7Id) {
            return this.g.E(new Object[]{e7Id}).hasLabel("knows", new String[0]);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasLabelXknowsX() {
            return this.g.E(new Object[0]).hasLabel("knows", new String[0]);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasLabelXnullX() {
            return this.g.E(new Object[0]).hasLabel(null);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasLabelXuses_traversesX() {
            return this.g.E(new Object[0]).hasLabel("uses", new String[]{"traverses"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXperson_software_blahX() {
            return this.g.V(new Object[0]).hasLabel("person", new String[]{"software", "blah"});
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age() {
            return this.g.V(new Object[0]).has("person", "name", (Object)"marko").values(new String[]{"age"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outE_hasXweight_inside_0_06X_inV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE().has("weight", P.inside((Object)0.0, (Object)0.6)).inV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXlocationX() {
            return this.g.V(new Object[0]).has("location");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_in_hasIdXneqX1XX(Object v1Id) {
            return this.g.V(new Object[0]).in().hasId(P.neq((Object)v1Id));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).has("age", P.not((P)P.lte((Object)10).and((Predicate)P.not((P)P.between((Object)11, (Object)20)))).and((Predicate)P.lt((Object)29).or((Predicate)P.eq((Object)35)))).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_both_properties_dedup_hasKeyXageX_value() {
            return this.g.V(new Object[0]).both().properties(new String[0]).dedup(new String[0]).hasKey("age", new String[0]).value();
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value() {
            return this.g.V(new Object[0]).both().properties(new String[0]).dedup(new String[0]).hasKey("age", new String[0]).hasValue(P.gt((Object)30)).value();
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_bothE_properties_dedup_hasKeyXweightX_value() {
            return this.g.V(new Object[0]).bothE().properties(new String[0]).dedup(new String[0]).hasKey("weight", new String[0]).value();
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value() {
            return this.g.V(new Object[0]).bothE().properties(new String[0]).dedup(new String[0]).hasKey("weight", new String[0]).hasValue(P.lt((Object)0.3)).value();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasNotXageX_name() {
            return this.g.V(new Object[0]).hasNot("age").values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasIdX1X_hasIdX2X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[0]).hasId(v1Id, new Object[0]).hasId(v2Id, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXpersonX_hasLabelXsoftwareX() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).hasLabel("software", new String[0]);
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasIdXemptyX_count() {
            return this.g.V(new Object[0]).hasId(Collections.emptyList(), new Object[0]).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasIdXwithinXemptyXX_count() {
            return this.g.V(new Object[0]).hasId(P.within(Collections.emptyList())).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasIdXwithoutXemptyXX_count() {
            return this.g.V(new Object[0]).hasId(P.without(Collections.emptyList())).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_notXhasIdXwithinXemptyXXX_count() {
            return this.g.V(new Object[0]).not((Traversal)__.hasId((P)P.within(Collections.emptyList()))).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasXage_withinX27X_count() {
            return this.g.V(new Object[0]).has("age", P.within((Object[])new Integer[]{27})).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasXage_withinX27_29X_count() {
            return this.g.V(new Object[0]).has("age", P.within((Object[])new Integer[]{27, 29})).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasXage_withoutX27X_count() {
            return this.g.V(new Object[0]).has("age", P.without((Object[])new Integer[]{27})).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_hasXage_withoutX27_29X_count() {
            return this.g.V(new Object[0]).has("age", P.without((Object[])new Integer[]{27, 29})).count();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_containingXarkXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.containing((String)"ark"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_startingWithXmarXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.startingWith((String)"mar"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_endingWithXasXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.endingWith((String)"as"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_not_containingXarkXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.notContaining((String)"ark"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_not_startingWithXmarXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.notStartingWith((String)"mar"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_not_endingWithXasXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.notEndingWith((String)"as"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXperson_name_containingXoX_andXltXmXXX() {
            return this.g.V(new Object[0]).has("person", "name", TextP.containing((String)"o").and((Predicate)P.lt((Object)"m")));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_gtXmX_andXcontainingXoXXX() {
            return this.g.V(new Object[0]).has("name", P.gt((Object)"m").and((Predicate)TextP.containing((String)"o")));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXp_neqXvXX() {
            return this.g.V(new Object[0]).has("p", P.neq((Object)"v"));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasXk_withinXcXX_valuesXkX() {
            return this.g.V(new Object[0]).has("k", P.within((Object[])new String[]{"\u8f49\u6ce8", "\u2726", "\u2660"})).values(new String[]{"k"});
        }

        @Override
        public Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasKeyXnullX() {
            return this.g.V(new Object[0]).properties(new String[0]).hasKey(null);
        }

        @Override
        public Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasKeyXnull_nullX() {
            return this.g.V(new Object[0]).properties(new String[0]).hasKey(null, null);
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_properties_hasKeyXnull_ageX_value() {
            return this.g.V(new Object[0]).properties(new String[0]).hasKey(null, new String[]{"age"}).value();
        }

        @Override
        public Traversal<Edge, ? extends Property<Object>> get_g_E_properties_hasKeyXnullX() {
            return this.g.E(new Object[0]).properties(new String[0]).hasKey(null);
        }

        @Override
        public Traversal<Edge, ? extends Property<Object>> get_g_E_properties_hasKeyXnull_nullX() {
            return this.g.E(new Object[0]).properties(new String[0]).hasKey(null, null);
        }

        @Override
        public Traversal<Edge, Double> get_g_E_properties_hasKeyXnull_weightX_value() {
            return this.g.E(new Object[0]).properties(new String[0]).hasKey(null, new String[]{"weight"}).value();
        }

        @Override
        public Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasValueXnullX() {
            return this.g.V(new Object[0]).properties(new String[0]).hasValue(null);
        }

        @Override
        public Traversal<Vertex, ? extends Property<Object>> get_g_V_properties_hasValueXnull_nullX() {
            return this.g.V(new Object[0]).properties(new String[0]).hasValue(null, null);
        }

        @Override
        public Traversal<Vertex, String> get_g_V_properties_hasValueXnull_joshX_value() {
            return this.g.V(new Object[0]).properties(new String[0]).hasValue(null, new Object[]{"josh"}).value();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_regexXrMarXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.regex((String)"^mar"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_notRegexXrMarXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.notRegex((String)"^mar"));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasXname_regexXTinkerXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.regex((String)"Tinker")).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasXname_regexXTinkerUnicodeXX() {
            return this.g.V(new Object[0]).has("name", (P)TextP.regex((String)"Tinker.*\u00a9")).values(new String[]{"name"});
        }
    }
}

