/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class ComparabilitySemanticsTest
extends AbstractGremlinProcessTest {
    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareNaN() {
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.eq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.neq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte((Object)1.0)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareNull() {
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.eq(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.neq(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt(null)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.lte(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt(null)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.gte(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.eq(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.eq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.neq(null)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.neq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lt(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lte(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lte((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gt(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gte(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gte((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.eq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq(null)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.neq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt(null)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gte((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte(null)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareAcrossTypes() {
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.eq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.eq((Object)"foo")));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.neq((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.neq((Object)"foo")));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.lt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.lt((Object)"foo")));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.lte((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.lte((Object)"foo")));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.gt((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.gt((Object)"foo")));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.gte((Object)1.0)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.gte((Object)"foo")));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testAnd() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)ERROR)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)ERROR)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)ERROR)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testOr() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)ERROR)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)ERROR)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)TRUE)}));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)FALSE)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)ERROR)}));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)ERROR)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testNot() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)TRUE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)FALSE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)ERROR)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is((Object)P.eq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is((Object)P.neq((Object)Double.NaN)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)P.eq((Object)Double.NaN))));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.not((Traversal)__.is((P)P.eq((Object)Double.NaN)))));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).where((Traversal)__.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)ERROR))));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testXor() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        BiFunction<P, P, GraphTraversal> xor = (A, B) -> __.or((Traversal[])new Traversal[]{__.and((Traversal[])new Traversal[]{__.is((P)A), __.not((Traversal)__.is((P)B))}), __.and((Traversal[])new Traversal[]{__.is((P)B), __.not((Traversal)__.is((P)A))})});
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, TRUE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, FALSE)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, ERROR)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, ERROR)));
        ComparabilitySemanticsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, TRUE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, FALSE)));
        ComparabilitySemanticsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, ERROR)));
    }
}

