/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.search.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ShortestPathTestHelper {
    private final AbstractGremlinProcessTest test;
    private final GraphTraversalSource g;
    private final Map<String, Vertex> vertexCache;
    private final Map<Object, Map<Object, Edge>> edgeCache;

    public ShortestPathTestHelper(AbstractGremlinProcessTest test, GraphTraversalSource g) {
        this.test = test;
        this.g = g;
        this.vertexCache = new HashMap<String, Vertex>();
        this.edgeCache = new HashMap<Object, Map<Object, Edge>>();
    }

    public void checkResults(List<Path> expected, List<Path> actual) {
        AbstractGremlinProcessTest.checkResults(expected, __.inject((Object[])actual.toArray(new Path[actual.size()])));
    }

    public Path makePath(String ... names) {
        return this.makePath(false, names);
    }

    public Path makePath(boolean includeEdges, String ... names) {
        Path path = ImmutablePath.make();
        boolean first = true;
        for (String name : names) {
            Vertex vertex = this.vertexCache.computeIfAbsent(name, this.test::convertToVertex);
            if (!first && includeEdges) {
                Edge edge;
                Object id1 = ((Vertex)path.get(path.size() - 1)).id();
                Object id2 = vertex.id();
                if (this.edgeCache.containsKey(id1)) {
                    edge = this.edgeCache.get(id1).computeIfAbsent(id2, id -> this.getEdge(id1, id));
                } else if (this.edgeCache.containsKey(id2)) {
                    edge = this.edgeCache.get(id2).computeIfAbsent(id1, id -> this.getEdge(id, id2));
                } else {
                    this.edgeCache.put(id1, new HashMap());
                    edge = this.getEdge(id1, id2);
                    this.edgeCache.get(id1).put(id2, edge);
                }
                path = path.extend((Object)edge, Collections.emptySet());
            }
            path = path.extend((Object)vertex, Collections.emptySet());
            first = false;
        }
        return path;
    }

    private Edge getEdge(Object id1, Object id2) {
        return (Edge)this.g.V(new Object[]{id1}).bothE().filter((Traversal)__.otherV().hasId(id2, new Object[0])).next();
    }
}

