/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.util.CustomId;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"vertexWithIdAlreadyExists", "elementNotFound", "idArgsMustBeEitherIdOrElement"})
public class GraphTest
extends AbstractGremlinTest {
    @Test
    public void shouldImplementAndExposeFeatures() {
        Graph.Features features = this.graph.features();
        Assert.assertNotNull((Object)features);
        AtomicInteger counter = new AtomicInteger(0);
        List<Method> methods = Arrays.asList(features.getClass().getMethods()).stream().filter(m -> Graph.Features.FeatureSet.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
        methods.forEach(m -> {
            try {
                Assert.assertNotNull((Object)m.invoke((Object)features, new Object[0]));
                counter.incrementAndGet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)"Exception while dynamically checking compliance on Feature implementation");
            }
        });
        Assert.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)methods.size(), (long)counter.get());
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindVertexByIdThatIsNonExistentViaIterator() {
        try {
            this.graph.vertices(new Object[]{this.graphProvider.convertId(10000L, Vertex.class)}).next();
            Assert.fail((String)"Call to g.vertices(10000l) should throw an exception");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(NoSuchElementException.class));
        }
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindEdgeByIdThatIsNonExistentViaIterator() {
        try {
            this.graph.edges(new Object[]{this.graphProvider.convertId(10000L, Edge.class)}).next();
            Assert.fail((String)"Call to g.edges(10000l) should throw an exception");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(NoSuchElementException.class));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="Upsert", supported=false)})
    public void shouldHaveExceptionConsistencyWhenAssigningSameIdOnVertex() {
        Object o = this.graphProvider.convertId("1", Vertex.class);
        this.graph.addVertex(new Object[]{T.id, o, "name", "marko"});
        try {
            this.graph.addVertex(new Object[]{T.id, o, "name", "stephen"});
            Assert.fail((String)"Assigning the same ID to an Element should throw an exception");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.vertexWithIdAlreadyExists((Object)0).getClass()));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="Upsert")})
    public void shouldUpsertWhenAssigningSameIdOnVertex() {
        Object o = this.graphProvider.convertId("1", Vertex.class);
        this.graph.addVertex(new Object[]{T.id, o, "name", "marko"});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{o}).next();
            Assert.assertEquals((Object)o, (Object)v.id());
            Assert.assertEquals((Object)"marko", (Object)v.value("name"));
            GraphTest.assertVertexEdgeCounts(graph, 1, 0);
        });
        this.graph.addVertex(new Object[]{T.id, o, "name", "stephen"});
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{o}).next();
            Assert.assertEquals((Object)o, (Object)v.id());
            Assert.assertEquals((Object)"stephen", (Object)v.value("name"));
            GraphTest.assertVertexEdgeCounts(graph, 1, 0);
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldAddVertexWithUserSuppliedNumericId() {
        this.graph.addVertex(new Object[]{T.id, 1000L});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{1000L}).next();
            Assert.assertEquals((Object)1000L, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldAddVertexWithUserSuppliedStringId() {
        this.graph.addVertex(new Object[]{T.id, "1000"});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{"1000"}).next();
            Assert.assertEquals((Object)"1000", (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldAddVertexWithUserSuppliedUuidId() {
        UUID uuid = UUID.randomUUID();
        this.graph.addVertex(new Object[]{T.id, uuid});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldAddVertexWithUserSuppliedAnyIdUsingUuid() {
        UUID uuid = UUID.randomUUID();
        this.graph.addVertex(new Object[]{T.id, uuid});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldAddVertexWithUserSuppliedAnyIdUsingString() {
        UUID uuid = UUID.randomUUID();
        this.graph.addVertex(new Object[]{T.id, uuid.toString()});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{uuid.toString()}).next();
            Assert.assertEquals((Object)uuid.toString(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldAddVertexWithUserSuppliedAnyIdUsingAnyObject() {
        UUID uuid = UUID.randomUUID();
        CustomId customId = new CustomId("test", uuid);
        this.graph.addVertex(new Object[]{T.id, customId});
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{customId}).next();
            Assert.assertEquals((Object)customId, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingDetachedVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{DetachedFactory.detach((Vertex)v1, (boolean)true)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DetachedVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingReferenceVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{ReferenceFactory.detach((Vertex)v1)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ReferenceVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingStarVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{StarGraph.of((Vertex)v1).getStarVertex()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(StarGraph.StarVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingVertexId() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingStringRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id().toString()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingVertices() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1, v2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingVertexIds() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id(), v2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldIterateVerticesWithUuidIdSupportUsingStringRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, UUID.randomUUID()}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id().toString(), v2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingVertex() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingDetachedVertex() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{DetachedFactory.detach((Vertex)v1, (boolean)true)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DetachedVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingReferenceVertex() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{ReferenceFactory.detach((Vertex)v1)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ReferenceVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingStarVertex() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{StarGraph.of((Vertex)v1).getStarVertex()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(StarGraph.StarVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingVertexId() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingStringRepresentation() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id().toString()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingVertices() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1, v2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingVertexIds() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id(), v2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="CustomIds")})
    public void shouldIterateVerticesWithCustomIdSupportUsingStringRepresentations() {
        Vertex v1 = this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id().toString(), v2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericSupportUsingDetachedVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{DetachedFactory.detach((Vertex)v1, (boolean)true)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DetachedVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericSupportUsingReferenceVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{ReferenceFactory.detach((Vertex)v1)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ReferenceVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericSupportUsingStarVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{StarGraph.of((Vertex)v1).getStarVertex()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(StarGraph.StarVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingVertexId() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingLongRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{Long.parseLong(v1.id().toString())}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingIntegerRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{Integer.parseInt(v1.id().toString())}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingFloatRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{Float.valueOf(Float.parseFloat(v1.id().toString()))}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingDoubleRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{Double.parseDouble(v1.id().toString())}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingStringRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id().toString()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingVertices() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1, v2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingVertexIds() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id(), v2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingLongRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{Long.parseLong(v1.id().toString()), Long.parseLong(v2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingIntegerRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{Integer.parseInt(v1.id().toString()), Integer.parseInt(v2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingFloatRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{Float.valueOf(Float.parseFloat(v1.id().toString())), Float.valueOf(Float.parseFloat(v2.id().toString()))}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingDoubleRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{Double.parseDouble(v1.id().toString()), Double.parseDouble(v2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldIterateVerticesWithNumericIdSupportUsingStringRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 1L}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, 2L}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id().toString(), v2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringSupportUsingDetachedVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{DetachedFactory.detach((Vertex)v1, (boolean)true)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DetachedVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringSupportUsingReferenceVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{ReferenceFactory.detach((Vertex)v1)}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ReferenceVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringSupportUsingStarVertex() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{StarGraph.of((Vertex)v1).getStarVertex()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
            MatcherAssert.assertThat((Object)v, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(StarGraph.StarVertex.class))));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingVertexId() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingStringRepresentation() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Vertex v = (Vertex)graph.vertices(new Object[]{v1.id().toString()}).next();
            Assert.assertEquals((Object)v1.id(), (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingVertices() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "2"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1, v2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingVertexIds() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "2"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id(), v2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldIterateVerticesWithStringIdSupportUsingStringRepresentations() {
        Vertex v1 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "1"}) : this.graph.addVertex(new Object[0]);
        Vertex v2 = this.graph.features().vertex().supportsUserSuppliedIds() ? this.graph.addVertex(new Object[]{T.id, "2"}) : this.graph.addVertex(new Object[0]);
        this.graph.addVertex(new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.vertices(new Object[]{v1.id().toString(), v2.id().toString()}))));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties", supported=false)
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfNoMultiProperty() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.graph, graph -> {
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"test"})));
            Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfMultiProperty() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.graph, graph -> {
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"test"})));
            Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("A")));
            Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("B")));
            Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)v.values(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    public void shouldHaveStandardStringRepresentation() throws Exception {
        Assert.assertTrue((boolean)this.graph.toString().matches(".*\\[.*\\]"));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
    public void shouldRemoveEdges() {
        int vertexCount = 100;
        int edgeCount = 200;
        ArrayList vertices = new ArrayList();
        ArrayList edges = new ArrayList();
        Random random = new Random();
        IntStream.range(0, 100).forEach(i -> vertices.add(this.graph.addVertex(new Object[0])));
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(100, 0));
        IntStream.range(0, 200).forEach(i -> {
            boolean created = false;
            while (!created) {
                Vertex b;
                Vertex a = (Vertex)vertices.get(random.nextInt(vertices.size()));
                if (a == (b = (Vertex)vertices.get(random.nextInt(vertices.size())))) continue;
                edges.add(a.addEdge(this.graphProvider.convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
                created = true;
            }
        });
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(100, 200));
        int counter = 0;
        for (Edge e : edges) {
            e.remove();
            int currentCounter = ++counter;
            this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(100, 200 - currentCounter));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldRemoveVertices() {
        int vertexCount = 500;
        ArrayList vertices = new ArrayList();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        IntStream.range(0, 500).forEach(i -> vertices.add(this.graph.addVertex(new Object[0])));
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(500, 0));
        for (int i2 = 0; i2 < 500; i2 += 2) {
            Vertex a = (Vertex)vertices.get(i2);
            Vertex b = (Vertex)vertices.get(i2 + 1);
            edges.add(a.addEdge(this.graphProvider.convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
        }
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(500, 250));
        int counter = 0;
        for (Vertex v : vertices) {
            ((Vertex)this.graph.vertices(new Object[]{v.id()}).next()).remove();
            if ((++counter + 1) % 2 != 0) continue;
            int currentCounter = counter;
            this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(500 - currentCounter, edges.size() - (currentCounter + 1) / 2));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldRemoveVerticesWithoutConcurrentModificationException() {
        for (int i = 0; i < 100; ++i) {
            this.graph.addVertex(new Object[0]);
        }
        Iterator vertexIterator = this.graph.vertices(new Object[0]);
        Assert.assertTrue((boolean)vertexIterator.hasNext());
        while (vertexIterator.hasNext()) {
            ((Vertex)vertexIterator.next()).remove();
        }
        Assert.assertFalse((boolean)vertexIterator.hasNext());
        this.tryCommit(this.graph, graph -> Assert.assertFalse((boolean)graph.vertices(new Object[0]).hasNext()));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
    public void shouldRemoveEdgesWithoutConcurrentModificationException() {
        for (int i = 0; i < 50; ++i) {
            this.graph.addVertex(new Object[0]).addEdge("link", this.graph.addVertex(new Object[0]), new Object[0]);
        }
        Iterator edgeIterator = this.graph.edges(new Object[0]);
        Assert.assertTrue((boolean)edgeIterator.hasNext());
        while (edgeIterator.hasNext()) {
            ((Edge)edgeIterator.next()).remove();
        }
        Assert.assertFalse((boolean)edgeIterator.hasNext());
        this.tryCommit(this.graph, g -> Assert.assertFalse((boolean)g.edges(new Object[0]).hasNext()));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldEvaluateConnectivityPatterns() {
        Vertex d;
        Vertex c;
        Vertex b;
        Vertex a;
        if (this.graph.features().vertex().supportsUserSuppliedIds()) {
            a = this.graph.addVertex(new Object[]{T.id, this.graphProvider.convertId("1", Vertex.class)});
            b = this.graph.addVertex(new Object[]{T.id, this.graphProvider.convertId("2", Vertex.class)});
            c = this.graph.addVertex(new Object[]{T.id, this.graphProvider.convertId("3", Vertex.class)});
            d = this.graph.addVertex(new Object[]{T.id, this.graphProvider.convertId("4", Vertex.class)});
        } else {
            a = this.graph.addVertex(new Object[0]);
            b = this.graph.addVertex(new Object[0]);
            c = this.graph.addVertex(new Object[0]);
            d = this.graph.addVertex(new Object[0]);
        }
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(4, 0));
        Edge e = a.addEdge(this.graphProvider.convertLabel("knows"), b, new Object[0]);
        Edge f = b.addEdge(this.graphProvider.convertLabel("knows"), c, new Object[0]);
        Edge g = c.addEdge(this.graphProvider.convertLabel("knows"), d, new Object[0]);
        Edge h = d.addEdge(this.graphProvider.convertLabel("knows"), a, new Object[0]);
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(4, 4));
        this.graph.vertices(new Object[0]).forEachRemaining(v -> {
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
        });
        this.graph.edges(new Object[0]).forEachRemaining(x -> Assert.assertEquals((Object)this.graphProvider.convertLabel("knows"), (Object)x.label()));
        if (this.graph.features().vertex().supportsUserSuppliedIds()) {
            Vertex va = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("1", Vertex.class)}).next();
            Vertex vb = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("2", Vertex.class)}).next();
            Vertex vc = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("3", Vertex.class)}).next();
            Vertex vd = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("4", Vertex.class)}).next();
            Assert.assertEquals((Object)a, (Object)va);
            Assert.assertEquals((Object)b, (Object)vb);
            Assert.assertEquals((Object)c, (Object)vc);
            Assert.assertEquals((Object)d, (Object)vd);
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.OUT, new String[0])));
            Edge i = a.addEdge(this.graphProvider.convertLabel("hates"), b, new Object[0]);
            a = (Vertex)this.graph.vertices(new Object[]{a.id()}).next();
            b = (Vertex)this.graph.vertices(new Object[]{b.id()}).next();
            va = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("1", Vertex.class)}).next();
            vb = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("2", Vertex.class)}).next();
            vc = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("3", Vertex.class)}).next();
            vd = (Vertex)this.graph.vertices(new Object[]{this.graphProvider.convertId("4", Vertex.class)}).next();
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)va.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)va.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vb.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vc.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vd.edges(Direction.OUT, new String[0])));
            for (Edge x2 : IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[0]))) {
                Assert.assertTrue((x2.label().equals(this.graphProvider.convertLabel("knows")) || x2.label().equals(this.graphProvider.convertLabel("hates")) ? 1 : 0) != 0);
            }
            Assert.assertEquals((Object)this.graphProvider.convertLabel("hates"), (Object)i.label());
            Assert.assertEquals((Object)this.graphProvider.convertId("2", Vertex.class).toString(), (Object)i.inVertex().id().toString());
            Assert.assertEquals((Object)this.graphProvider.convertId("1", Vertex.class).toString(), (Object)i.outVertex().id().toString());
        }
        HashSet<Object> vertexIds = new HashSet<Object>();
        vertexIds.add(a.id());
        vertexIds.add(a.id());
        vertexIds.add(b.id());
        vertexIds.add(b.id());
        vertexIds.add(c.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        Assert.assertEquals((long)4L, (long)vertexIds.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithSingleEdgeLabelFilter() {
        Vertex a = this.graph.addVertex(new Object[0]);
        Vertex b = this.graph.addVertex(new Object[0]);
        Vertex c = this.graph.addVertex(new Object[0]);
        String labelFriend = this.graphProvider.convertLabel("friend");
        String labelHate = this.graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[0]));
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelFriend}));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelFriend}));
        Assert.assertEquals((long)0L, (long)results.size());
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelFriend}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithMultipleEdgeLabelFilter() {
        Vertex a = this.graph.addVertex(new Object[0]);
        Vertex b = this.graph.addVertex(new Object[0]);
        Vertex c = this.graph.addVertex(new Object[0]);
        String labelFriend = this.graphProvider.convertLabel("friend");
        String labelHate = this.graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = IteratorUtils.list((Iterator)a.edges(Direction.OUT, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = IteratorUtils.list((Iterator)a.edges(Direction.IN, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{labelFriend, labelHate}));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = IteratorUtils.list((Iterator)b.edges(Direction.IN, new String[]{this.graphProvider.convertLabel("blah1"), this.graphProvider.convertLabel("blah2")}));
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTestTreeConnectivity() {
        int branchSize = 11;
        Vertex start = this.graph.addVertex(new Object[0]);
        for (int i = 0; i < branchSize; ++i) {
            Vertex a = this.graph.addVertex(new Object[0]);
            start.addEdge(this.graphProvider.convertLabel("test1"), a, new Object[0]);
            for (int j = 0; j < branchSize; ++j) {
                Vertex b = this.graph.addVertex(new Object[0]);
                a.addEdge(this.graphProvider.convertLabel("test2"), b, new Object[0]);
                for (int k = 0; k < branchSize; ++k) {
                    Vertex c = this.graph.addVertex(new Object[0]);
                    b.addEdge(this.graphProvider.convertLabel("test3"), c, new Object[0]);
                }
            }
        }
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)start.edges(Direction.IN, new String[0])));
        Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)start.edges(Direction.OUT, new String[0])));
        for (Vertex a : IteratorUtils.list((Iterator)start.edges(Direction.OUT, new String[0]))) {
            Assert.assertEquals((Object)this.graphProvider.convertLabel("test1"), (Object)a.label());
            Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)a.inVertex().vertices(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)a.inVertex().vertices(Direction.IN, new String[0])));
            for (Vertex b : IteratorUtils.list((Iterator)a.inVertex().edges(Direction.OUT, new String[0]))) {
                Assert.assertEquals((Object)this.graphProvider.convertLabel("test2"), (Object)b.label());
                Assert.assertEquals((long)branchSize, (long)IteratorUtils.count((Iterator)b.inVertex().vertices(Direction.OUT, new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)b.inVertex().vertices(Direction.IN, new String[0])));
                for (Vertex c : IteratorUtils.list((Iterator)b.inVertex().edges(Direction.OUT, new String[0]))) {
                    Assert.assertEquals((Object)this.graphProvider.convertLabel("test3"), (Object)c.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)c.inVertex().vertices(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)c.inVertex().vertices(Direction.IN, new String[0])));
                }
            }
        }
        int totalVertices = 0;
        for (int i = 0; i < 4; ++i) {
            totalVertices += (int)Math.pow(branchSize, i);
        }
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(totalVertices, totalVertices - 1));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Persistence")
    public void shouldPersistDataOnClose() throws Exception {
        Vertex v = this.graph.addVertex(new Object[0]);
        Vertex u = this.graph.addVertex(new Object[0]);
        if (this.graph.features().vertex().properties().supportsStringValues()) {
            v.property(VertexProperty.Cardinality.single, "name", (Object)"marko", new Object[0]);
            u.property(VertexProperty.Cardinality.single, "name", (Object)"pavel", new Object[0]);
        }
        Edge e = v.addEdge(this.graphProvider.convertLabel("collaborator"), u, new Object[0]);
        if (this.graph.features().edge().properties().supportsStringValues()) {
            e.property("location", (Object)"internet");
        }
        this.tryCommit(this.graph, GraphTest.getAssertVertexEdgeCounts(2, 1));
        this.graph.close();
        Graph reopenedGraph = this.graphProvider.standardTestGraph(this.getClass(), this.name.getMethodName(), null);
        GraphTest.assertVertexEdgeCounts(reopenedGraph, 2, 1);
        if (this.graph.features().vertex().properties().supportsStringValues()) {
            reopenedGraph.vertices(new Object[0]).forEachRemaining(vertex -> Assert.assertTrue((vertex.property("name").value().equals("marko") || vertex.property("name").value().equals("pavel") ? 1 : 0) != 0));
        }
        reopenedGraph.edges(new Object[0]).forEachRemaining(edge -> {
            Assert.assertEquals((Object)this.graphProvider.convertLabel("collaborator"), (Object)edge.label());
            if (this.graph.features().edge().properties().supportsStringValues()) {
                Assert.assertEquals((Object)"internet", (Object)edge.property("location").value());
            }
        });
        this.graphProvider.clear(reopenedGraph, this.graphProvider.standardGraphConfiguration(this.getClass(), this.name.getMethodName(), null));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingEdgeId() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingStringRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id().toString()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingEdges() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1, e2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingEdgeIds() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id(), e2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds")})
    public void shouldIterateEdgesWithUuidIdSupportUsingStringRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, UUID.randomUUID()}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id().toString(), e2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingEdgeId() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingStringRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id().toString()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingEdges() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        Edge e2 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1, e2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingEdgeIds() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        Edge e2 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id(), e2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="CustomIds")})
    public void shouldIterateEdgesWithCustomIdSupportUsingStringRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = v.addEdge("self", v, new Object[0]);
        Edge e2 = v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id().toString(), e2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingEdgeId() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingLongRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{Long.parseLong(e1.id().toString())}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingIntegerRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{Integer.parseInt(e1.id().toString())}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingFloatRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{Float.valueOf(Float.parseFloat(e1.id().toString()))}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingDoubleRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{Double.parseDouble(e1.id().toString())}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingStringRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id().toString()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingVertices() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1, e2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingEdgeIds() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id(), e2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingLongRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{Long.parseLong(e1.id().toString()), Long.parseLong(e2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingIntegerRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{Integer.parseInt(e1.id().toString()), Integer.parseInt(e2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingFloatRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{Float.valueOf(Float.parseFloat(e1.id().toString())), Float.valueOf(Float.parseFloat(e2.id().toString()))}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingDoubleRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{Double.parseDouble(e1.id().toString()), Double.parseDouble(e2.id().toString())}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
    public void shouldIterateEdgesWithNumericIdSupportUsingStringRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 1L}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, 2L}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id().toString(), e2.id().toString()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingEdgeId() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingStringRepresentation() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> {
            Edge e = (Edge)graph.edges(new Object[]{e1.id().toString()}).next();
            Assert.assertEquals((Object)e1.id(), (Object)e.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingEdges() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "2"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1, e2}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingEdgeIds() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "2"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id(), e2.id()}))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds")})
    public void shouldIterateEdgesWithStringIdSupportUsingStringRepresentations() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e1 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "1"}) : v.addEdge("self", v, new Object[0]);
        Edge e2 = this.graph.features().edge().supportsUserSuppliedIds() ? v.addEdge("self", v, new Object[]{T.id, "2"}) : v.addEdge("self", v, new Object[0]);
        v.addEdge("self", v, new Object[0]);
        this.tryCommit(this.graph, graph -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)graph.edges(new Object[]{e1.id().toString(), e2.id().toString()}))));
    }
}

