/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.tools.CollectionFactory;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class OrderabilityTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Object> get_g_V_values_order();

    public abstract Traversal<Vertex, ? extends Property> get_g_V_properties_order();

    public abstract Traversal<Edge, Object> get_g_E_properties_order_value();

    public abstract Traversal<Edge, Object> get_g_E_properties_order_byXdescX_value();

    public abstract Traversal<Object, Object> get_g_inject_order();

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out_order_byXascX();

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out_asXheadX_path_order_byXascX_selectXheadX();

    public abstract Traversal<Vertex, Edge> get_g_V_out_outE_order_byXascX();

    public abstract Traversal<Vertex, Edge> get_g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX();

    public abstract Traversal<Vertex, Object> get_g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value();

    public abstract Traversal<Vertex, Object> get_g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX();

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out_order_byXdescX();

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX();

    public abstract Traversal<Vertex, Edge> get_g_V_out_outE_order_byXdescX();

    public abstract Traversal<Vertex, Edge> get_g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX();

    public abstract Traversal<Vertex, Object> get_g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value();

    public abstract Traversal<Vertex, Object> get_g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void g_V_values_order() {
        Traversal<Vertex, Object> traversal = this.get_g_V_values_order();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(27, 29, 32, 35, "java", "java", "josh", "lop", "marko", "peter", "ripple", "vadas"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds")})
    public void g_V_properties_order() {
        Traversal<Vertex, ? extends Property> traversal = this.get_g_V_properties_order();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToVertexProperty("marko", "name", (Object)"marko"), this.convertToVertexProperty("marko", "age", 29), this.convertToVertexProperty("vadas", "name", (Object)"vadas"), this.convertToVertexProperty("vadas", "age", 27), this.convertToVertexProperty("lop", "name", (Object)"lop"), this.convertToVertexProperty("lop", "lang", (Object)"java"), this.convertToVertexProperty("josh", "name", (Object)"josh"), this.convertToVertexProperty("josh", "age", 32), this.convertToVertexProperty("ripple", "name", (Object)"ripple"), this.convertToVertexProperty("ripple", "lang", (Object)"java"), this.convertToVertexProperty("peter", "name", (Object)"peter"), this.convertToVertexProperty("peter", "age", 35)), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void g_E_properties_order_value() {
        AtomicInteger a = new AtomicInteger();
        this.g.E(new Object[0]).forEachRemaining(e -> e.property("a", (Object)a.getAndIncrement()));
        Traversal<Edge, Object> asc = this.get_g_E_properties_order_value();
        this.printTraversalForm(asc);
        OrderabilityTest.checkOrderedResults(Arrays.asList(0, 1, 2, 3, 4, 5, 0.2, 0.4, 0.4, 0.5, 1.0, 1.0), asc);
        Traversal<Edge, Object> desc = this.get_g_E_properties_order_byXdescX_value();
        this.printTraversalForm(desc);
        OrderabilityTest.checkOrderedResults(Arrays.asList(1.0, 1.0, 0.5, 0.4, 0.4, 0.2, 5, 4, 3, 2, 1, 0), desc);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void g_inject_order() {
        Traversal<Object, Object> traversal = this.get_g_inject_order();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(null, false, true, 1, 2.0, Constants.date, "bar", "foo", Constants.uuid, Constants.set1, Constants.set2, Constants.list1, Constants.list2, Constants.map1, Constants.map2), traversal);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void g_inject_order_with_unknown_type() {
        Object unknown = new Object();
        Object[] unordered = new Object[Constants.unordered.length + 1];
        unordered[0] = unknown;
        System.arraycopy(Constants.unordered, 0, unordered, 1, Constants.unordered.length);
        GraphTraversal traversal = this.g.inject(unordered).order();
        this.printTraversalForm((Traversal)traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(null, false, true, 1, 2.0, Constants.date, "bar", "foo", Constants.uuid, Constants.set1, Constants.set2, Constants.list1, Constants.list2, Constants.map1, Constants.map2, unknown), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_order_byXascX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_order_byXascX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToVertex("lop"), this.convertToVertex("ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_asXheadX_path_order_byXascX_selectXheadX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_asXheadX_path_order_byXascX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToVertex("lop"), this.convertToVertex("ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_outE_order_byXascX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_out_outE_order_byXascX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToEdge("josh", "created", "ripple"), this.convertToEdge("josh", "created", "lop")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToEdge("josh", "created", "ripple"), this.convertToEdge("josh", "created", "lop")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList("lop", "java", "ripple", "java"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX() {
        Traversal<Vertex, Object> traversal = this.get_g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList("java", "lop", "java", "ripple"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_order_byXdescX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_order_byXdescX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToVertex("ripple"), this.convertToVertex("lop")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToVertex("ripple"), this.convertToVertex("lop")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_outE_order_byXdescX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_out_outE_order_byXdescX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToEdge("josh", "created", "lop"), this.convertToEdge("josh", "created", "ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList(this.convertToEdge("josh", "created", "lop"), this.convertToEdge("josh", "created", "ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList("java", "ripple", "java", "lop"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX() {
        Traversal<Vertex, Object> traversal = this.get_g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX();
        this.printTraversalForm(traversal);
        OrderabilityTest.checkOrderedResults(Arrays.asList("ripple", "java", "lop", "java"), traversal);
    }

    public static class Traversals
    extends OrderabilityTest
    implements Constants {
        @Override
        public Traversal<Vertex, Object> get_g_V_values_order() {
            return this.g.V(new Object[0]).values(new String[0]).order();
        }

        @Override
        public Traversal<Vertex, ? extends Property> get_g_V_properties_order() {
            return this.g.V(new Object[0]).properties(new String[0]).order();
        }

        @Override
        public Traversal<Edge, Object> get_g_E_properties_order_value() {
            return this.g.E(new Object[0]).properties(new String[0]).order().value();
        }

        @Override
        public Traversal<Edge, Object> get_g_E_properties_order_byXdescX_value() {
            return this.g.E(new Object[0]).properties(new String[0]).order().by(Order.desc).value();
        }

        @Override
        public Traversal<Object, Object> get_g_inject_order() {
            return this.g.inject(unordered).order();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out_order_byXascX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).order().by(Order.asc);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out_asXheadX_path_order_byXascX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).as("head", new String[0]).path().order().by(Order.asc).select("head");
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_out_outE_order_byXascX() {
            return this.g.V(new Object[0]).out(new String[0]).outE(new String[0]).order().by(Order.asc);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).outE(new String[0]).as("head", new String[0]).path().order().by(Order.asc).select("head");
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).properties(new String[0]).as("head", new String[0]).path().order().by(Order.asc).select("head").value();
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).values(new String[0]).as("head", new String[0]).path().order().by(Order.asc).select("head");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out_order_byXdescX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).order().by(Order.desc);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).as("head", new String[0]).path().order().by(Order.desc).select("head");
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_out_outE_order_byXdescX() {
            return this.g.V(new Object[0]).out(new String[0]).outE(new String[0]).order().by(Order.desc);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).outE(new String[0]).as("head", new String[0]).path().order().by(Order.desc).select("head");
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).properties(new String[0]).as("head", new String[0]).path().order().by(Order.desc).select("head").value();
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).values(new String[0]).as("head", new String[0]).path().order().by(Order.desc).select("head");
        }
    }

    private static interface Constants {
        public static final UUID uuid = UUID.randomUUID();
        public static final Date date = new Date();
        public static final List list1 = Arrays.asList(1, 2, 3);
        public static final List list2 = Arrays.asList(1, 2, 3, 4);
        public static final Set set1 = CollectionFactory.asSet((Collection)list1);
        public static final Set set2 = CollectionFactory.asSet((Collection)list2);
        public static final Map map1 = CollectionFactory.asMap((Object[])new Object[]{1, 11, 2, 22, 3, false, 4, 44});
        public static final Map map2 = CollectionFactory.asMap((Object[])new Object[]{1, 11, 2, 22, 33});
        public static final Object[] unordered = new Object[]{map2, 1, map1, "foo", null, list1, date, set1, list2, true, uuid, "bar", 2.0, false, set2};
    }
}

