/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.Random;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.junit.Test;

public class DetachedGraphTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void testAttachableGetMethod() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, DetachedFactory.detach((Vertex)vertex, (boolean)true).attach(Attachable.Method.get((Host)vertex))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, DetachedFactory.detach((VertexProperty)vertexProperty, (boolean)true).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, DetachedFactory.detach((Property)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, DetachedFactory.detach((Edge)edge, (boolean)true).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, DetachedFactory.detach((Property)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, DetachedFactory.detach((Vertex)vertex, (boolean)true).attach(Attachable.Method.get((Host)this.graph))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, DetachedFactory.detach((VertexProperty)vertexProperty, (boolean)true).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, DetachedFactory.detach((Property)property).attach(Attachable.Method.get((Host)this.graph))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, DetachedFactory.detach((Edge)edge, (boolean)true).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> vertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, DetachedFactory.detach((Property)property).attach(Attachable.Method.get((Host)this.graph))))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void testAttachableCreateMethod() {
        Random random = TestHelper.RANDOM;
        StarGraph starGraph = StarGraph.open();
        Vertex starVertex = starGraph.addVertex(new Object[]{T.label, "person", "name", "stephen", "name", "spmallete"});
        starVertex.property("acl", (Object)true, new Object[]{"timestamp", random.nextLong(), "creator", "marko"});
        for (int i = 0; i < 100; ++i) {
            starVertex.addEdge("knows", starGraph.addVertex(new Object[]{"person", "name", new UUID(random.nextLong(), random.nextLong()), "since", random.nextLong()}), new Object[0]);
            starGraph.addVertex(new Object[]{T.label, "project"}).addEdge("developedBy", starVertex, new Object[]{"public", random.nextBoolean()});
        }
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)starGraph.getStarVertex(), (boolean)true);
        Vertex createdVertex = (Vertex)detachedVertex.attach(Attachable.Method.create((Host)this.graph));
        TestHelper.validateVertexEquality((Vertex)detachedVertex, createdVertex, false);
        TestHelper.validateVertexEquality((Vertex)detachedVertex, starVertex, false);
        starGraph.getStarVertex().edges(Direction.BOTH, new String[0]).forEachRemaining(starEdge -> {
            DetachedEdge detachedEdge = DetachedFactory.detach((Edge)starEdge, (boolean)true);
            Edge createdEdge = (Edge)detachedEdge.attach(Attachable.Method.create((Host)(random.nextBoolean() ? this.graph : createdVertex)));
            TestHelper.validateEdgeEquality((Edge)detachedEdge, starEdge);
            TestHelper.validateEdgeEquality((Edge)detachedEdge, createdEdge);
        });
    }
}

