/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class IndexTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, List<Object>> get_g_V_hasLabelXsoftwareX_index_unfold();

    public abstract Traversal<Vertex, Map<Integer, Vertex>> get_g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX();

    public abstract Traversal<Vertex, List<Object>> get_g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX();

    public abstract Traversal<Vertex, Map<Integer, String>> get_g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_index() {
        Traversal<Vertex, List<Object>> traversal = this.get_g_V_hasLabelXsoftwareX_index_unfold();
        this.printTraversalForm(traversal);
        IndexTest.checkResults(Arrays.asList(Arrays.asList(this.convertToVertex("lop"), 0), Arrays.asList(this.convertToVertex("ripple"), 0)), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX() {
        Traversal<Vertex, Map<Integer, Vertex>> traversal = this.get_g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX();
        this.printTraversalForm(traversal);
        LinkedHashMap<Integer, Vertex> map1 = new LinkedHashMap<Integer, Vertex>();
        LinkedHashMap<Integer, Vertex> map2 = new LinkedHashMap<Integer, Vertex>();
        map1.put(0, this.convertToVertex("lop"));
        map2.put(0, this.convertToVertex("ripple"));
        IndexTest.checkOrderedResults(Arrays.asList(map1, map2), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX() {
        Traversal<Vertex, List<Object>> traversal = this.get_g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX();
        this.printTraversalForm(traversal);
        IndexTest.checkOrderedResults(Arrays.asList(Arrays.asList("lop", 0), Arrays.asList("ripple", 1)), traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX() {
        Traversal<Vertex, Map<Integer, String>> traversal = this.get_g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX();
        this.printTraversalForm(traversal);
        LinkedHashMap<Integer, String> expected = new LinkedHashMap<Integer, String>();
        expected.put(0, "josh");
        expected.put(1, "marko");
        expected.put(2, "peter");
        expected.put(3, "vadas");
        Assert.assertEquals(expected, (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class Traversals
    extends IndexTest {
        @Override
        public Traversal<Vertex, List<Object>> get_g_V_hasLabelXsoftwareX_index_unfold() {
            return this.g.V(new Object[0]).hasLabel("software", new String[0]).index().unfold();
        }

        @Override
        public Traversal<Vertex, Map<Integer, Vertex>> get_g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX() {
            return this.g.V(new Object[0]).hasLabel("software", new String[0]).order().by("name").index().with(WithOptions.indexer, (Object)WithOptions.map);
        }

        @Override
        public Traversal<Vertex, List<Object>> get_g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX() {
            return this.g.V(new Object[0]).hasLabel("software", new String[0]).values(new String[]{"name"}).fold().order(Scope.local).index().unfold().order().by((Traversal)__.tail((Scope)Scope.local, (long)1L));
        }

        @Override
        public Traversal<Vertex, Map<Integer, String>> get_g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).values(new String[]{"name"}).fold().order(Scope.local).index().with(WithOptions.indexer, (Object)WithOptions.map);
        }
    }
}

