/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.jsr223.BindingsGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineSuite;
import org.apache.tinkerpop.gremlin.jsr223.ScriptFileGremlinPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BindingsScriptEngineTest {
    @Test
    public void shouldIncludeGlobalBindings() throws ScriptException {
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        SimpleBindings b = new SimpleBindings();
        b.put("x", (Object)1);
        b.put("y", (Object)2);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b).create());
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)1, (Object)engine.eval("x"));
        Assert.assertEquals((Object)2, (Object)engine.eval("y"));
    }

    @Test
    public void shouldRemoveGlobalBindings() throws Exception {
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        manager.put("x", (Object)100);
        GremlinScriptEngine engine1 = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        MatcherAssert.assertThat((Object)engine1.getBindings(200).size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((long)101L, (long)((Integer)engine1.eval("x+1")).intValue());
        manager.getBindings().remove("x");
        GremlinScriptEngine engine2 = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        MatcherAssert.assertThat((Object)engine2.getBindings(200).size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAddLazyGlobalBindingsViaPlugin() throws Exception {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("x", (Object)100);
        BindingsGremlinPlugin plugin = new BindingsGremlinPlugin(() -> bindings);
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        manager.addPlugin((GremlinPlugin)plugin);
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        MatcherAssert.assertThat((Object)engine.getBindings(200).size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((long)101L, (long)((Integer)engine.eval("x+1")).intValue());
    }

    @Test
    public void shouldExtractGlobalBindingsAfterScriptExecution() throws Exception {
        Assume.assumeThat((String)"Only works with gremlin-groovy", (Object)GremlinScriptEngineSuite.ENGINE_TO_TEST, (Matcher)Is.is((Object)"gremlin-groovy"));
        DefaultGremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();
        SimpleBindings b1 = new SimpleBindings();
        b1.put("x", (Object)1);
        b1.put("y", (Object)2);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b1).create());
        SimpleBindings b2 = new SimpleBindings();
        b2.put("x", (Object)100);
        b2.put("y", (Object)200);
        manager.addPlugin((GremlinPlugin)BindingsGremlinPlugin.build().bindings((Map)b2).create());
        File scriptFile = TestHelper.generateTempFileFromResource(BindingsScriptEngineTest.class, "bindings-init.groovy", ".groovy");
        ArrayList<String> files = new ArrayList<String>();
        files.add(scriptFile.getAbsolutePath());
        manager.addPlugin((GremlinPlugin)ScriptFileGremlinPlugin.build().files(files).create());
        GremlinScriptEngine engine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)100, (Object)engine.eval("x"));
        Assert.assertEquals((Object)200, (Object)engine.eval("y"));
        Assert.assertEquals((Object)300, (Object)engine.eval("z"));
        Assert.assertEquals((Object)600, (Object)engine.eval("addItUp(z, addItUp(x,y))"));
        Assert.assertEquals((Object)300, (Object)engine.getBindings(200).get("z"));
        MatcherAssert.assertThat((Object)engine.getBindings(100).containsKey("z"), (Matcher)Is.is((Object)false));
    }
}

