/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_LP_O_P_S_SE_SL_Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_LP_O_S_SE_SL_Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_O_S_SE_SL_Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_O_Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.O_Traverser;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;

public interface GraphProvider {
    public static final Set<Class> CORE_IMPLEMENTATIONS = new HashSet<Class>(){
        {
            this.add(__.class);
            this.add(DefaultGraphTraversal.class);
            this.add(GraphTraversalSource.class);
            this.add(B_O_S_SE_SL_Traverser.class);
            this.add(B_LP_O_P_S_SE_SL_Traverser.class);
            this.add(B_LP_O_S_SE_SL_Traverser.class);
            this.add(B_O_Traverser.class);
            this.add(O_Traverser.class);
        }
    };

    default public GraphTraversalSource traversal(Graph graph) {
        return graph.traversal();
    }

    default public GraphTraversalSource traversal(Graph graph, TraversalStrategy ... strategies) {
        return this.traversal(graph).withStrategies(strategies);
    }

    default public GraphComputer getGraphComputer(Graph graph) {
        return graph.compute();
    }

    default public Graph standardTestGraph(Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        return GraphFactory.open((Configuration)this.standardGraphConfiguration(test, testMethodName, loadGraphWith));
    }

    default public Graph openTestGraph(Configuration config) {
        return GraphFactory.open((Configuration)config);
    }

    default public Configuration standardGraphConfiguration(Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        return this.newGraphConfiguration("standard", test, testMethodName, Collections.emptyMap(), loadGraphWith);
    }

    default public void clear(Configuration configuration) throws Exception {
        this.clear(null, configuration);
    }

    public void clear(Graph var1, Configuration var2) throws Exception;

    default public Object convertId(Object id, Class<? extends Element> c) {
        return id;
    }

    default public String convertLabel(String label) {
        return label;
    }

    public Configuration newGraphConfiguration(String var1, Class<?> var2, String var3, Map<String, Object> var4, LoadGraphWith.GraphData var5);

    default public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        return this.newGraphConfiguration(graphName, test, testMethodName, new HashMap<String, Object>(), loadGraphWith);
    }

    public void loadGraphData(Graph var1, LoadGraphWith var2, Class var3, String var4);

    public Set<Class> getImplementations();

    default public String getWorkingDirectory() {
        return TestHelper.makeTestDataPath(this.getClass(), "graph-provider-data").getAbsolutePath();
    }

    default public Optional<TestListener> getTestListener() {
        return Optional.empty();
    }

    default public Optional<Graph.Features> getStaticFeatures() {
        return Optional.empty();
    }

    public static interface TestListener {
        default public void onTestStart(Class<?> test, String testName) {
        }

        default public void onTestEnd(Class<?> test, String testName) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Descriptor {
        public Class<? extends GraphComputer> computer();
    }
}

