/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure.PeerPressureVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyPath;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=GraphComputer.Exceptions.class, methods={"providedKeyIsNotAMemoryComputeKey", "computerHasNoVertexProgramNorMapReducers", "computerHasAlreadyBeenSubmittedAVertexProgram", "providedKeyIsNotAnElementComputeKey", "incidentAndAdjacentElementsCanNotBeAccessedInMapReduce", "adjacentVertexLabelsCanNotBeRead", "adjacentVertexPropertiesCanNotBeReadOrUpdated", "adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated", "resultGraphPersistCombinationNotSupported", "vertexPropertiesCanNotBeUpdatedInMapReduce", "computerRequiresMoreWorkersThanSupported", "vertexFilterAccessesIncidentEdges", "edgeFilterAccessesAdjacentVertices", "graphFilterNotSupported"}), @ExceptionCoverage(exceptionClass=Memory.Exceptions.class, methods={"memoryKeyCanNotBeEmpty", "memoryKeyCanNotBeNull", "memoryValueCanNotBeNull", "memoryIsCurrentlyImmutable", "memoryDoesNotExist", "memorySetOnlyDuringVertexProgramSetUpAndTerminate", "memoryAddOnlyDuringVertexProgramExecute", "adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"graphDoesNotSupportProvidedGraphComputer"})})
public class GraphComputerTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveStandardStringRepresentation() {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        Assert.assertEquals((Object)StringFactory.graphComputerString((GraphComputer)computer), (Object)computer.toString());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowWithNoVertexProgramNorMapReducers() throws Exception {
        try {
            this.graphProvider.getGraphComputer(this.graph).submit().get();
            Assert.fail((String)"Should throw an IllegalStateException when there is no vertex program nor map reducers");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowBadGraphComputers() {
        try {
            this.graph.compute(BadGraphComputer.class);
            Assert.fail((String)"Providing a bad graph computer class should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(BadGraphComputer.class), ex);
        }
        if (!new BadGraphComputer().features().supportsGraphFilter()) {
            try {
                new BadGraphComputer().vertices((Traversal<Vertex, Vertex>)__.hasLabel((String)"software", (String[])new String[0]));
                Assert.fail((String)"Should throw an unsupported operation exception");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.graphFilterNotSupported().getMessage(), (Object)e.getMessage());
            }
            try {
                new BadGraphComputer().edges((Traversal<Vertex, Edge>)__.bothE((String[])new String[0]));
                Assert.fail((String)"Should throw an unsupported operation exception");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.graphFilterNotSupported().getMessage(), (Object)e.getMessage());
            }
        } else {
            Assert.fail((String)("Should not support graph filter: " + BadGraphComputer.class));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveImmutableComputeResultMemory() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramB()).submit().get();
        try {
            results.memory().set("set", (Object)"test");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().add("incr", (Object)1);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().add("and", (Object)true);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().add("or", (Object)false);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowNullMemoryKeys() throws Exception {
        try {
            this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramC()).submit().get();
            Assert.fail((String)"Providing null memory key should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowEmptyMemoryKeys() throws Exception {
        try {
            this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramD()).submit().get();
            Assert.fail((String)"Providing empty memory key should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryKeyCanNotBeEmpty(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleUndeclaredMemoryKeysCorrectly() throws Exception {
        this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramE()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowTheSameComputerToExecutedTwice() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramA());
        computer.submit().get();
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveConsistentMemoryVertexPropertiesAndExceptions() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramF()).submit().get();
        Assert.assertEquals((long)1L, (long)results.memory().getIteration());
        Assert.assertEquals((long)2L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)2L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((results.memory().getRuntime() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)12L, (long)((Integer)results.memory().get("a")).intValue());
        Assert.assertEquals((long)28L, (long)((Integer)results.memory().get("b")).intValue());
        try {
            results.memory().get("BAD");
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)Memory.Exceptions.memoryDoesNotExist((String)"BAD").getMessage(), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)0L, (Object)results.graph().traversal().V(new Object[0]).count().next());
        results.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)v.property("nameLengthCounter").isPresent());
            Assert.assertEquals((Object)(((String)v.value("name")).length() * 2), (Object)((Integer)v.value("nameLengthCounter")));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAndOrIncrCorrectlyThroughSubStages() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramG()).submit().get();
        Assert.assertEquals((long)2L, (long)results.memory().getIteration());
        Assert.assertEquals((long)6L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)6L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((boolean)results.memory().keys().contains("c"));
        Assert.assertTrue((boolean)results.memory().keys().contains("d"));
        Assert.assertTrue((boolean)results.memory().keys().contains("e"));
        Assert.assertTrue((boolean)results.memory().keys().contains("f"));
        Assert.assertEquals((Object)18L, (Object)results.memory().get("a"));
        Assert.assertEquals((Object)0L, (Object)results.memory().get("b"));
        Assert.assertFalse((boolean)((Boolean)results.memory().get("c")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("d")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("e")));
        Assert.assertEquals((long)3L, (long)((Integer)results.memory().get("f")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowMapReduceWithNoVertexProgram() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).mapReduce((MapReduce)new MapReduceA()).submit().get();
        Assert.assertEquals((long)123L, (long)((Integer)results.memory().get("ageSum")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportMultipleMapReduceJobs() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramH()).mapReduce((MapReduce)new MapReduceH1()).mapReduce((MapReduce)new MapReduceH2()).submit().get();
        Assert.assertEquals((long)60L, (long)((Integer)results.memory().get("a")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)results.memory().get("b")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSortReduceOutput() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).mapReduce((MapReduce)new MapReduceB()).submit().get();
        List nameLengths = (List)results.memory().get("nameLengths");
        Assert.assertEquals((long)6L, (long)nameLengths.size());
        for (int i = 1; i < nameLengths.size(); ++i) {
            Assert.assertTrue(((Integer)nameLengths.get(i) <= (Integer)nameLengths.get(i - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSortMapOutput() throws Exception {
        ComputerResult results = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).mapReduce((MapReduce)new MapReduceBB()).submit().get();
        List nameLengths = (List)results.memory().get("nameLengths");
        Assert.assertEquals((long)6L, (long)nameLengths.size());
        for (int i = 1; i < nameLengths.size(); ++i) {
            Assert.assertTrue(((Integer)nameLengths.get(i) <= (Integer)nameLengths.get(i - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOnlyAllowReadingVertexPropertiesInMapReduce() throws Exception {
        this.graphProvider.getGraphComputer(this.graph).mapReduce((MapReduce)new MapReduceC()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOnlyAllowIDAccessOfAdjacentVertices() throws Exception {
        this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramI()).submit().get();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldStartAndEndWorkersForVertexProgramAndMapReduce() throws Exception {
        MapReduceI.WORKER_START.clear();
        MapReduceI.WORKER_END.clear();
        Assert.assertEquals((long)3L, (long)((Integer)((ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramJ()).mapReduce((MapReduce)new MapReduceI()).submit().get()).memory().get("a")).intValue());
        if (MapReduceI.WORKER_START.size() == 2) {
            Assert.assertEquals((long)2L, (long)MapReduceI.WORKER_START.size());
            Assert.assertTrue((MapReduceI.WORKER_START.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)3L, (long)MapReduceI.WORKER_START.size());
            Assert.assertTrue((MapReduceI.WORKER_START.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_START.contains(MapReduce.Stage.COMBINE) && MapReduceI.WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        }
        if (MapReduceI.WORKER_END.size() == 2) {
            Assert.assertEquals((long)2L, (long)MapReduceI.WORKER_END.size());
            Assert.assertTrue((MapReduceI.WORKER_END.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_END.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)3L, (long)MapReduceI.WORKER_END.size());
            Assert.assertTrue((MapReduceI.WORKER_END.contains(MapReduce.Stage.MAP) && MapReduceI.WORKER_END.contains(MapReduce.Stage.COMBINE) && MapReduceI.WORKER_END.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith
    public void shouldSupportPersistResultGraphPairsStatedInFeatures() throws Exception {
        for (GraphComputer.ResultGraph resultGraph : GraphComputer.ResultGraph.values()) {
            for (GraphComputer.Persist persist : GraphComputer.Persist.values()) {
                GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
                if (computer.features().supportsResultGraphPersistCombination(resultGraph, persist)) {
                    computer.program((VertexProgram)new VertexProgramK()).result(resultGraph).persist(persist).submit().get();
                    continue;
                }
                try {
                    computer.program((VertexProgram)new VertexProgramK()).result(resultGraph).persist(persist).submit().get();
                    Assert.fail((String)("The GraphComputer " + computer + " states that it does support the following resultGraph/persist pair: " + resultGraph + ":" + persist));
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.resultGraphPersistCombinationNotSupported((GraphComputer.ResultGraph)resultGraph, (GraphComputer.Persist)persist).getMessage(), (Object)e.getMessage());
                }
            }
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistNothing() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.NOTHING)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.NOTHING).submit().get();
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistVertexProperties() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.VERTEX_PROPERTIES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)0L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphNewWithPersistEdges() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.EDGES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.NEW).persist(GraphComputer.Persist.EDGES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistNothing() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.NOTHING)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.NOTHING).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)12L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistVertexProperties() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.VERTEX_PROPERTIES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldProcessResultGraphOriginalWithPersistEdges() throws Exception {
        GraphComputer computer = this.graphProvider.getGraphComputer(this.graph);
        if (computer.features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.ORIGINAL, GraphComputer.Persist.EDGES)) {
            ComputerResult result = (ComputerResult)computer.program((VertexProgram)new VertexProgramK()).result(GraphComputer.ResultGraph.ORIGINAL).persist(GraphComputer.Persist.EDGES).submit().get();
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)result.graph().traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)result.graph().traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().V(new Object[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).count().next());
            Assert.assertEquals((Object)18L, (Object)this.graph.traversal().V(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)6L, (Object)this.graph.traversal().E(new Object[0]).values(new String[0]).count().next());
            Assert.assertEquals((Object)28L, (Object)this.graph.traversal().V(new Object[0]).values(new String[]{"money"}).sum().next());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldSupportWorkerCount() throws Exception {
        int i;
        int maxWorkers = this.graphProvider.getGraphComputer(this.graph).features().getMaxWorkers();
        if (maxWorkers != Integer.MAX_VALUE) {
            for (i = maxWorkers + 1; i < maxWorkers + 10; ++i) {
                try {
                    this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramL()).workers(i).submit().get();
                    Assert.fail((String)"Should throw a GraphComputer.Exceptions.computerRequiresMoreWorkersThanSupported() exception");
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("computer requires more workers"));
                }
            }
        }
        if (maxWorkers > 25) {
            maxWorkers = 25;
        }
        for (i = 1; i <= maxWorkers; ++i) {
            ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramL()).workers(i).submit().get();
            Assert.assertEquals((long)Integer.valueOf(i).longValue(), (long)((Long)result.memory().get("workerCount")));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportMultipleScopes() throws ExecutionException, InterruptedException {
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new MultiScopeVertexProgram()).submit().get();
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"josh").next()).property("count").value(), (Object)0L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"lop").next()).property("count").value(), (Object)1L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"ripple").next()).property("count").value(), (Object)1L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"marko").next()).property("count").value(), (Object)2L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportMultipleScopesWithEdgeFunction() throws ExecutionException, InterruptedException {
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new MultiScopeVertexWithEdgeFunctionProgram()).submit().get();
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"josh").next()).property("count").value(), (Object)0L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"lop").next()).property("count").value(), (Object)4L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"ripple").next()).property("count").value(), (Object)10L);
        Assert.assertEquals((Object)((Vertex)result.graph().traversal().V(new Object[0]).has("name", (Object)"marko").next()).property("count").value(), (Object)20L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportGraphFilter() throws Exception {
        if (!this.graphProvider.getGraphComputer(this.graph).features().supportsGraphFilter()) {
            try {
                this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"software", (String[])new String[0]));
                Assert.fail((String)"Should throw an unsupported operation exception");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.graphFilterNotSupported().getMessage(), (Object)e.getMessage());
            }
            try {
                this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0]).limit(10L));
                Assert.fail((String)"Should throw an unsupported operation exception");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.graphFilterNotSupported().getMessage(), (Object)e.getMessage());
            }
            return;
        }
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"software", (String[])new String[0])).program((VertexProgram)new VertexProgramM("softwareOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).program((VertexProgram)new VertexProgramM("peopleOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[]{"knows"})).program((VertexProgram)new VertexProgramM("knowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"})).program((VertexProgram)new VertexProgramM("peopleKnowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"}).has("weight", P.gt((Object)Float.valueOf(0.5f)))).program((VertexProgram)new VertexProgramM("peopleKnowsWellOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[0]).limit(0L)).program((VertexProgram)new VertexProgramM("verticesOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0]).limit(1L)).program((VertexProgram)new VertexProgramM("oneOutEdgeOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0])).program((VertexProgram)new VertexProgramM("outEdgesOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"software", (String[])new String[0])).program((VertexProgram)new VertexProgramM("softwareOnly")).mapReduce((MapReduce)new MapReduceJ("softwareOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).program((VertexProgram)new VertexProgramM("peopleOnly")).mapReduce((MapReduce)new MapReduceJ("peopleOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[]{"knows"})).program((VertexProgram)new VertexProgramM("knowsOnly")).mapReduce((MapReduce)new MapReduceJ("knowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"})).program((VertexProgram)new VertexProgramM("peopleKnowsOnly")).mapReduce((MapReduce)new MapReduceJ("peopleKnowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"}).has("weight", P.gt((Object)Float.valueOf(0.5f)))).program((VertexProgram)new VertexProgramM("peopleKnowsWellOnly")).mapReduce((MapReduce)new MapReduceJ("peopleKnowsWellOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[0]).limit(0L)).program((VertexProgram)new VertexProgramM("verticesOnly")).mapReduce((MapReduce)new MapReduceJ("verticesOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0]).limit(1L)).program((VertexProgram)new VertexProgramM("oneOutEdgeOnly")).mapReduce((MapReduce)new MapReduceJ("oneOutEdgeOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0])).program((VertexProgram)new VertexProgramM("outEdgesOnly")).mapReduce((MapReduce)new MapReduceJ("outEdgesOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"software", (String[])new String[0])).mapReduce((MapReduce)new MapReduceJ("softwareOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).mapReduce((MapReduce)new MapReduceJ("peopleOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[]{"knows"})).mapReduce((MapReduce)new MapReduceJ("knowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"})).mapReduce((MapReduce)new MapReduceJ("peopleKnowsOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.hasLabel((String)"person", (String[])new String[0])).edges((Traversal)__.bothE((String[])new String[]{"knows"}).has("weight", P.gt((Object)Float.valueOf(0.5f)))).mapReduce((MapReduce)new MapReduceJ("peopleKnowsWellOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.bothE((String[])new String[0]).limit(0L)).mapReduce((MapReduce)new MapReduceJ("verticesOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0]).limit(1L)).mapReduce((MapReduce)new MapReduceJ("oneOutEdgeOnly")).submit().get();
        this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.outE((String[])new String[0])).mapReduce((MapReduce)new MapReduceJ("outEdgesOnly")).submit().get();
        try {
            this.graphProvider.getGraphComputer(this.graph).vertices((Traversal)__.out((String[])new String[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)GraphComputer.Exceptions.vertexFilterAccessesIncidentEdges((Traversal)__.out((String[])new String[0])).getMessage());
        }
        try {
            this.graphProvider.getGraphComputer(this.graph).edges((Traversal)__.out((String[])new String[0]).outE(new String[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)GraphComputer.Exceptions.edgeFilterAccessesAdjacentVertices((Traversal)__.out((String[])new String[0]).outE(new String[0])).getMessage());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportJobChaining() throws Exception {
        ComputerResult result1 = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program(PageRankVertexProgram.build().iterations(5).create(this.graph)).persist(GraphComputer.Persist.EDGES).result(GraphComputer.ResultGraph.NEW).submit().get();
        Graph graph1 = result1.graph();
        Memory memory1 = result1.memory();
        Assert.assertEquals((long)5L, (long)memory1.getIteration());
        Assert.assertEquals((long)6L, (long)((Long)graph1.traversal().V(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph1.traversal().E(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph1.traversal().V(new Object[0]).values(new String[]{"gremlin.pageRankVertexProgram.pageRank"}).count().next()).intValue());
        Assert.assertEquals((long)18L, (long)((Long)graph1.traversal().V(new Object[0]).values(new String[0]).count().next()).intValue());
        ComputerResult result2 = (ComputerResult)graph1.compute(this.graphProvider.getGraphComputer(graph1).getClass()).program(PeerPressureVertexProgram.build().maxIterations(4).create(graph1)).persist(GraphComputer.Persist.EDGES).result(GraphComputer.ResultGraph.NEW).submit().get();
        Graph graph2 = result2.graph();
        Memory memory2 = result2.memory();
        Assert.assertTrue((memory2.getIteration() <= 4 ? 1 : 0) != 0);
        Assert.assertEquals((long)6L, (long)((Long)graph2.traversal().V(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph2.traversal().E(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph2.traversal().V(new Object[0]).values(new String[]{"gremlin.peerPressureVertexProgram.cluster"}).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph2.traversal().V(new Object[0]).values(new String[]{"gremlin.pageRankVertexProgram.pageRank"}).count().next()).intValue());
        Assert.assertEquals((long)24L, (long)((Long)graph2.traversal().V(new Object[0]).values(new String[0]).count().next()).intValue());
        ComputerResult result3 = (ComputerResult)graph2.compute(this.graphProvider.getGraphComputer(graph2).getClass()).program(TraversalVertexProgram.build().traversal((Traversal.Admin)this.g.V(new Object[0]).groupCount("m").by((Traversal)__.values((String[])new String[]{"gremlin.pageRankVertexProgram.pageRank"}).count()).label().asAdmin()).create(graph2)).persist(GraphComputer.Persist.EDGES).result(GraphComputer.ResultGraph.NEW).submit().get();
        Graph graph3 = result3.graph();
        Memory memory3 = result3.memory();
        Assert.assertTrue((boolean)memory3.keys().contains("m"));
        Assert.assertTrue((boolean)memory3.keys().contains("gremlin.traversalVertexProgram.haltedTraversers"));
        Assert.assertEquals((long)1L, (long)((Map)memory3.get("m")).size());
        Assert.assertEquals((long)6L, (long)((Long)((Map)memory3.get("m")).get(1L)).intValue());
        List traversers = IteratorUtils.list((Iterator)((TraverserSet)memory3.get("gremlin.traversalVertexProgram.haltedTraversers")).iterator());
        Assert.assertEquals((long)6L, (long)traversers.stream().map(Traverser::bulk).reduce((a, b) -> a + b).get());
        Assert.assertEquals((long)4L, (long)traversers.stream().filter(s -> ((String)s.get()).equals("person")).map(Traverser::bulk).reduce((a, b) -> a + b).get());
        Assert.assertEquals((long)2L, (long)traversers.stream().filter(s -> ((String)s.get()).equals("software")).map(Traverser::bulk).reduce((a, b) -> a + b).get());
        Assert.assertEquals((long)6L, (long)((Long)graph3.traversal().V(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph3.traversal().E(new Object[0]).count().next()).intValue());
        Assert.assertEquals((long)0L, (long)((Long)graph3.traversal().V(new Object[0]).values(new String[]{"gremlin.traversalVertexProgram.haltedTraversers"}).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph3.traversal().V(new Object[0]).values(new String[]{"gremlin.peerPressureVertexProgram.cluster"}).count().next()).intValue());
        Assert.assertEquals((long)6L, (long)((Long)graph3.traversal().V(new Object[0]).values(new String[]{"gremlin.pageRankVertexProgram.pageRank"}).count().next()).intValue());
        Assert.assertEquals((long)24L, (long)((Long)graph3.traversal().V(new Object[0]).values(new String[0]).count().next()).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportPreExistingComputeKeys() throws Exception {
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramN()).submit().get();
        result.graph().vertices(new Object[0]).forEachRemaining(vertex -> {
            if (vertex.label().equals("person")) {
                if (vertex.value("name").equals("marko")) {
                    Assert.assertEquals((long)32L, (long)((Integer)vertex.value("age")).intValue());
                } else if (vertex.value("name").equals("peter")) {
                    Assert.assertEquals((long)38L, (long)((Integer)vertex.value("age")).intValue());
                } else if (vertex.value("name").equals("vadas")) {
                    Assert.assertEquals((long)30L, (long)((Integer)vertex.value("age")).intValue());
                } else if (vertex.value("name").equals("josh")) {
                    Assert.assertEquals((long)35L, (long)((Integer)vertex.value("age")).intValue());
                } else {
                    throw new IllegalStateException("This vertex should not have been accessed: " + vertex);
                }
            }
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportTransientKeys() throws Exception {
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramO()).mapReduce((MapReduce)new MapReduceK()).submit().get();
        result.graph().vertices(new Object[0]).forEachRemaining(vertex -> {
            Assert.assertFalse((boolean)vertex.property("v1").isPresent());
            Assert.assertFalse((boolean)vertex.property("v2").isPresent());
            Assert.assertTrue((boolean)vertex.property("v3").isPresent());
            Assert.assertEquals((Object)"shouldExist", (Object)vertex.value("v3"));
            Assert.assertTrue((boolean)vertex.property("name").isPresent());
            if (vertex.label().equals("software")) {
                Assert.assertTrue((boolean)vertex.property("lang").isPresent());
            } else {
                Assert.assertTrue((boolean)vertex.property("age").isPresent());
            }
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[0])));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[]{"v1"})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[]{"v2"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[]{"v3"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[]{"name"})));
        });
        Assert.assertEquals((long)6L, (long)((Long)result.graph().traversal().V(new Object[0]).properties(new String[]{"name"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)result.graph().traversal().V(new Object[0]).properties(new String[]{"v1"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)result.graph().traversal().V(new Object[0]).properties(new String[]{"v2"}).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)result.graph().traversal().V(new Object[0]).properties(new String[]{"v3"}).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)result.graph().traversal().V(new Object[0]).values(new String[]{"name"}).dedup(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)result.graph().traversal().V(new Object[0]).values(new String[]{"v3"}).dedup(new String[0]).count().next()));
        Assert.assertEquals((Object)"shouldExist", (Object)result.graph().traversal().V(new Object[0]).values(new String[]{"v3"}).dedup(new String[0]).next());
        Assert.assertFalse((boolean)result.memory().exists("m1"));
        Assert.assertFalse((boolean)result.memory().exists("m2"));
        Assert.assertTrue((boolean)result.memory().exists("m3"));
        Assert.assertEquals((long)24L, (long)((Long)result.memory().get("m3")));
        Assert.assertEquals((long)2L, (long)result.memory().keys().size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportBroadcastKeys() throws Exception {
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)new VertexProgramP()).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("m1"));
        Assert.assertFalse((boolean)result.memory().exists("m2"));
        Assert.assertFalse((boolean)result.memory().exists("m3"));
        Assert.assertTrue((boolean)result.memory().exists("m4"));
        Assert.assertTrue((boolean)((Boolean)result.memory().get("m1")));
        Assert.assertEquals((long)-18L, (long)((Integer)result.memory().get("m4")).intValue());
        Assert.assertEquals((long)2L, (long)result.memory().keys().size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSucceedWithProperTraverserRequirements() throws Exception {
        VertexProgramQ vp = (VertexProgramQ)VertexProgramQ.build().property("pl").create();
        HashMap<String, List<Integer>> expected = new HashMap<String, List<Integer>>();
        expected.put("vadas", Collections.singletonList(2));
        expected.put("lop", Arrays.asList(2, 2, 2, 3));
        expected.put("josh", Collections.singletonList(2));
        expected.put("ripple", Arrays.asList(2, 3));
        try {
            this.g.V(new Object[0]).repeat((Traversal)__.out((String[])new String[0])).emit().program((VertexProgram)vp).dedup(new String[0]).valueMap(new String[]{"name", "pl"}).forEachRemaining(map -> {
                String name = (String)((List)map.get("name")).get(0);
                List pathLengths = (List)map.get("pl");
                Assert.assertTrue((boolean)expected.containsKey(name));
                List expectedPathLengths = (List)expected.remove(name);
                Assert.assertTrue((boolean)expectedPathLengths.containsAll(pathLengths));
                Assert.assertTrue((boolean)pathLengths.containsAll(expectedPathLengths));
            });
            Assert.assertTrue((boolean)expected.isEmpty());
        }
        catch (VerificationException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFailWithImproperTraverserRequirements() throws Exception {
        VertexProgramQ vp = (VertexProgramQ)VertexProgramQ.build().property("pl").useTraverserRequirements(false).create();
        try {
            this.g.V(new Object[0]).repeat((Traversal)__.out((String[])new String[0])).emit().program((VertexProgram)vp).dedup(new String[0]).forEachRemaining(v -> Assert.assertFalse((boolean)v.property("pl").isPresent()));
        }
        catch (VerificationException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.SINK)
    public void testMessagePassingIn() throws Exception {
        this.runMPTest(Direction.IN).forEachRemaining(v -> {
            GraphComputerTest.vertexPropertyChecks(v);
            String in = (String)v.value("name");
            if (in.equals("a")) {
                Assert.assertEquals((Object)"ab", (Object)v.value("propertyout").toString());
            } else if (in.equals("b")) {
                Assert.assertEquals((Object)"", (Object)v.value("propertyout").toString());
            } else {
                throw new IllegalStateException("This vertex should not exist: name=" + String.valueOf(in));
            }
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.SINK)
    public void testMessagePassingOut() throws Exception {
        this.runMPTest(Direction.OUT).forEachRemaining(v -> {
            GraphComputerTest.vertexPropertyChecks(v);
            String in = (String)v.value("name");
            if (in.equals("a")) {
                Assert.assertEquals((Object)"a", (Object)v.value("propertyout").toString());
            } else if (in.equals("b")) {
                Assert.assertEquals((Object)"a", (Object)v.value("propertyout").toString());
            } else {
                throw new IllegalStateException("This vertex should not exist: name=" + String.valueOf(in));
            }
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.SINK)
    public void testMessagePassingBoth() throws Exception {
        this.runMPTest(Direction.BOTH).forEachRemaining(v -> {
            String in;
            GraphComputerTest.vertexPropertyChecks(v);
            switch (in = (String)v.value("name")) {
                case "a": {
                    Assert.assertEquals((Object)"aab", (Object)v.value("propertyout").toString());
                    break;
                }
                case "b": {
                    Assert.assertEquals((Object)"a", (Object)v.value("propertyout").toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("This vertex should not exist: name=" + String.valueOf(in));
                }
            }
        });
    }

    private GraphTraversal<Vertex, Vertex> runMPTest(Direction direction) throws Exception {
        VertexProgramR svp = (VertexProgramR)VertexProgramR.build().direction(direction).create();
        ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)svp).vertices((Traversal)__.hasLabel((String)"message", (String[])new String[0])).submit().get();
        return result.graph().traversal().V(new Object[0]).hasLabel("message", new String[0]);
    }

    private static void vertexPropertyChecks(Vertex v) {
        Assert.assertEquals((long)2L, (long)v.keys().size());
        Assert.assertTrue((boolean)v.keys().contains("name"));
        Assert.assertTrue((boolean)v.keys().contains("propertyout"));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"name"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"propertyout"})));
    }

    private static class VertexProgramR
    implements VertexProgram<String> {
        private static final String SIMPLE_VERTEX_PROGRAM_CFG_PREFIX = "gremlin.simpleVertexProgram";
        private static final String PROPERTY_OUT = "propertyout";
        private static final String PROPERTY_IN = "name";
        private static final String VERTEX_LABEL = "message";
        private static final String DIRECTION_CFG_KEY = "gremlin.simpleVertexProgram.direction";
        private Direction direction;
        private final MessageScope.Local<String> inMessageScope = MessageScope.Local.of(() -> __.inE((String[])new String[0]));
        private final MessageScope.Local<String> outMessageScope = MessageScope.Local.of(() -> __.outE((String[])new String[0]));
        private final MessageScope.Local<String> bothMessageScope = MessageScope.Local.of(() -> __.bothE((String[])new String[0]));
        private MessageScope.Local<String> messageScope;
        private final Set<VertexComputeKey> vertexComputeKeys = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of((String)"propertyout", (boolean)false), VertexComputeKey.of((String)"name", (boolean)false)));

        private VertexProgramR() {
        }

        public VertexProgramR clone() {
            return this;
        }

        public void loadState(Graph graph, Configuration configuration) {
            this.direction = Direction.valueOf((String)configuration.getString(DIRECTION_CFG_KEY));
            switch (this.direction) {
                case IN: {
                    this.messageScope = this.inMessageScope;
                    break;
                }
                case OUT: {
                    this.messageScope = this.outMessageScope;
                    break;
                }
                case BOTH: {
                    this.messageScope = this.bothMessageScope;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should not reach this point!");
                }
            }
        }

        public void storeState(Configuration configuration) {
            super.storeState(configuration);
            configuration.setProperty(DIRECTION_CFG_KEY, (Object)this.direction.name());
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<String> messenger, Memory memory) {
            if (memory.isInitialIteration()) {
                messenger.sendMessage(this.messageScope, (Object)vertex.value(PROPERTY_IN).toString());
            } else {
                char[] composite = ((String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)"", (a, b) -> a + b)).toCharArray();
                Arrays.sort(composite);
                vertex.property(PROPERTY_OUT, (Object)new String(composite));
            }
        }

        public boolean terminate(Memory memory) {
            return !memory.isInitialIteration();
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.singleton(this.messageScope);
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return this.vertexComputeKeys;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return Collections.emptySet();
        }

        public static Builder build() {
            return new Builder();
        }

        static class Builder
        extends AbstractVertexProgramBuilder<Builder> {
            private Builder() {
                super(VertexProgramR.class);
            }

            public VertexProgramR create(Graph graph) {
                if (graph != null) {
                    ConfigurationUtils.append((Configuration)graph.configuration().subset(VertexProgramR.SIMPLE_VERTEX_PROGRAM_CFG_PREFIX), (Configuration)this.configuration);
                }
                return (VertexProgramR)VertexProgram.createVertexProgram((Graph)graph, (Configuration)this.configuration);
            }

            public Builder direction(Direction direction) {
                this.configuration.setProperty(VertexProgramR.DIRECTION_CFG_KEY, (Object)direction.toString());
                return this;
            }
        }
    }

    private static class VertexProgramQ
    implements VertexProgram<Object> {
        private static final String VERTEX_PROGRAM_Q_CFG_PREFIX = "gremlin.vertexProgramQ";
        private static final String PROPERTY_CFG_KEY = "gremlin.vertexProgramQ.property";
        private static final String LENGTHS_KEY = "gremlin.vertexProgramQ.lengths";
        private static final String USE_TRAVERSER_REQUIREMENTS_CFG_KEY = "gremlin.vertexProgramQ.useTraverserRequirements";
        private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Collections.singleton(MemoryComputeKey.of((String)"gremlin.vertexProgramQ.lengths", (BinaryOperator)Operator.addAll, (boolean)true, (boolean)true));
        private final Set<VertexComputeKey> elementComputeKeys = new HashSet<VertexComputeKey>();
        private Configuration configuration;
        private String propertyKey;
        private Set<TraverserRequirement> traverserRequirements;

        private VertexProgramQ() {
        }

        public static Builder build() {
            return new Builder();
        }

        public void storeState(Configuration config) {
            super.storeState(config);
            if (this.configuration != null) {
                ConfigurationUtils.copy((Configuration)this.configuration, (Configuration)config);
            }
        }

        public void loadState(Graph graph, Configuration config) {
            this.configuration = new BaseConfiguration();
            if (config != null) {
                ConfigurationUtils.copy((Configuration)config, (Configuration)this.configuration);
            }
            this.propertyKey = this.configuration.getString(PROPERTY_CFG_KEY);
            this.traverserRequirements = this.configuration.getBoolean(USE_TRAVERSER_REQUIREMENTS_CFG_KEY, true) ? Collections.singleton(TraverserRequirement.PATH) : Collections.emptySet();
            this.elementComputeKeys.add(VertexComputeKey.of((String)this.propertyKey, (boolean)false));
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            block5: {
                block4: {
                    if (!memory.isInitialIteration()) break block4;
                    VertexProperty haltedTraversers = vertex.property("gremlin.traversalVertexProgram.haltedTraversers");
                    if (!haltedTraversers.isPresent()) {
                        return;
                    }
                    Iterator iterator = ((TraverserSet)haltedTraversers.value()).iterator();
                    if (!iterator.hasNext()) break block5;
                    while (iterator.hasNext()) {
                        Traverser t = (Traverser)iterator.next();
                        if (t.path() instanceof EmptyPath) continue;
                        int pathLength = t.path().size();
                        LinkedList<Pair> memoryValue = new LinkedList<Pair>();
                        memoryValue.add(Pair.with((Object)vertex, (Object)pathLength));
                        memory.add(LENGTHS_KEY, memoryValue);
                    }
                    break block5;
                }
                if (memory.exists(LENGTHS_KEY)) {
                    List lengths = (List)memory.get(LENGTHS_KEY);
                    for (Pair pair : lengths) {
                        if (!((Vertex)pair.getValue0()).equals(vertex)) continue;
                        vertex.property(VertexProperty.Cardinality.list, this.propertyKey, pair.getValue1(), new Object[0]);
                    }
                }
            }
        }

        public boolean terminate(Memory memory) {
            return !memory.isInitialIteration();
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return this.elementComputeKeys;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return MEMORY_COMPUTE_KEYS;
        }

        public VertexProgram<Object> clone() {
            return this;
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public Set<TraverserRequirement> getTraverserRequirements() {
            return this.traverserRequirements;
        }

        public VertexProgram.Features getFeatures() {
            return new VertexProgram.Features(){

                public boolean requiresVertexPropertyAddition() {
                    return true;
                }
            };
        }

        static class Builder
        extends AbstractVertexProgramBuilder<Builder> {
            private Builder() {
                super(VertexProgramQ.class);
            }

            public VertexProgramQ create(Graph graph) {
                if (graph != null) {
                    ConfigurationUtils.append((Configuration)graph.configuration().subset(VertexProgramQ.VERTEX_PROGRAM_Q_CFG_PREFIX), (Configuration)this.configuration);
                }
                return (VertexProgramQ)VertexProgram.createVertexProgram((Graph)graph, (Configuration)this.configuration);
            }

            public Builder property(String name) {
                this.configuration.setProperty(VertexProgramQ.PROPERTY_CFG_KEY, (Object)name);
                return this;
            }

            public Builder useTraverserRequirements(boolean value) {
                this.configuration.setProperty(VertexProgramQ.USE_TRAVERSER_REQUIREMENTS_CFG_KEY, (Object)value);
                return this;
            }
        }
    }

    private static class VertexProgramP
    extends StaticVertexProgram {
        private VertexProgramP() {
        }

        public void setup(Memory memory) {
            Assert.assertFalse((boolean)memory.exists("m1"));
            Assert.assertFalse((boolean)memory.exists("m2"));
            Assert.assertFalse((boolean)memory.exists("m3"));
            Assert.assertFalse((boolean)memory.exists("m4"));
            memory.set("m1", (Object)false);
            memory.set("m2", (Object)true);
            memory.set("m3", (Object)0L);
            memory.set("m4", (Object)0);
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            if (memory.isInitialIteration()) {
                Assert.assertFalse((boolean)memory.exists("m1"));
                Assert.assertTrue((boolean)memory.exists("m2"));
                Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
                Assert.assertFalse((boolean)memory.exists("m3"));
                Assert.assertTrue((boolean)memory.exists("m4"));
                Assert.assertEquals((long)0L, (long)((Integer)memory.get("m4")).intValue());
                memory.add("m1", (Object)false);
                memory.add("m2", (Object)true);
                memory.add("m3", (Object)1L);
                memory.add("m4", (Object)-1);
            } else {
                Assert.assertFalse((boolean)memory.exists("m1"));
                Assert.assertTrue((boolean)memory.exists("m2"));
                Assert.assertFalse((boolean)memory.exists("m3"));
                Assert.assertTrue((boolean)memory.exists("m4"));
                try {
                    Assert.assertFalse((boolean)((Boolean)memory.get("m1")));
                    Assert.fail();
                }
                catch (Exception e) {
                    AbstractGremlinTest.validateException(Memory.Exceptions.memoryDoesNotExist((String)"m1"), e);
                }
                Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
                try {
                    Assert.assertEquals((long)6L, (long)((Long)memory.get("m3")));
                    Assert.fail();
                }
                catch (Exception e) {
                    AbstractGremlinTest.validateException(Memory.Exceptions.memoryDoesNotExist((String)"m3"), e);
                }
                Assert.assertEquals((long)-6L, (long)((Integer)memory.get("m4")).intValue());
                memory.add("m1", (Object)true);
                memory.add("m2", (Object)true);
                memory.add("m3", (Object)2L);
                memory.add("m4", (Object)-2);
            }
        }

        public boolean terminate(Memory memory) {
            Assert.assertTrue((boolean)memory.exists("m1"));
            Assert.assertTrue((boolean)memory.exists("m2"));
            Assert.assertTrue((boolean)memory.exists("m3"));
            Assert.assertTrue((boolean)memory.exists("m4"));
            if (memory.isInitialIteration()) {
                Assert.assertFalse((boolean)((Boolean)memory.get("m1")));
                Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
                Assert.assertEquals((long)6L, (long)((Long)memory.get("m3")));
                Assert.assertEquals((long)-6L, (long)((Integer)memory.get("m4")).intValue());
                return false;
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("m1")));
            Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
            Assert.assertEquals((long)18L, (long)((Long)memory.get("m3")));
            Assert.assertEquals((long)-18L, (long)((Integer)memory.get("m4")).intValue());
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of((String)"m1", (BinaryOperator)Operator.or, (boolean)false, (boolean)false), MemoryComputeKey.of((String)"m2", (BinaryOperator)Operator.and, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"m3", (BinaryOperator)Operator.sum, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"m4", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false)));
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }
    }

    public static class MapReduceK
    extends StaticMapReduce {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter emitter) {
            Assert.assertFalse((boolean)vertex.property("v1").isPresent());
            Assert.assertFalse((boolean)vertex.property("v2").isPresent());
            Assert.assertTrue((boolean)vertex.property("v3").isPresent());
            Assert.assertTrue((boolean)vertex.property("name").isPresent());
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[0])));
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)vertex.values(new String[0])));
        }

        public String getMemoryKey() {
            return "mapReduceK";
        }

        public Object generateFinalResult(Iterator keyValues) {
            return "anObject";
        }
    }

    private static class VertexProgramO
    extends StaticVertexProgram {
        private VertexProgramO() {
        }

        public void setup(Memory memory) {
            Assert.assertFalse((boolean)memory.exists("m1"));
            Assert.assertFalse((boolean)memory.exists("m2"));
            Assert.assertFalse((boolean)memory.exists("m3"));
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            if (memory.isInitialIteration()) {
                Assert.assertFalse((boolean)vertex.property("v1").isPresent());
                Assert.assertFalse((boolean)vertex.property("v2").isPresent());
                Assert.assertFalse((boolean)vertex.property("v3").isPresent());
                vertex.property("v1", (Object)"shouldNotExist");
                vertex.property("v2", (Object)"shouldNotExist");
                vertex.property("v3", (Object)"shouldExist");
                Assert.assertTrue((boolean)vertex.property("v1").isPresent());
                Assert.assertTrue((boolean)vertex.property("v2").isPresent());
                Assert.assertTrue((boolean)vertex.property("v3").isPresent());
                Assert.assertEquals((Object)"shouldNotExist", (Object)vertex.value("v1"));
                Assert.assertEquals((Object)"shouldNotExist", (Object)vertex.value("v2"));
                Assert.assertEquals((Object)"shouldExist", (Object)vertex.value("v3"));
                Assert.assertFalse((boolean)memory.exists("m1"));
                Assert.assertFalse((boolean)memory.exists("m2"));
                Assert.assertFalse((boolean)memory.exists("m3"));
                memory.add("m1", (Object)false);
                memory.add("m2", (Object)true);
                memory.add("m3", (Object)2L);
                Assert.assertFalse((boolean)memory.exists("m1"));
                Assert.assertFalse((boolean)memory.exists("m2"));
                Assert.assertFalse((boolean)memory.exists("m3"));
            } else {
                Assert.assertTrue((boolean)vertex.property("v1").isPresent());
                Assert.assertTrue((boolean)vertex.property("v2").isPresent());
                Assert.assertTrue((boolean)vertex.property("v3").isPresent());
                Assert.assertEquals((Object)"shouldNotExist", (Object)vertex.value("v1"));
                Assert.assertEquals((Object)"shouldNotExist", (Object)vertex.value("v2"));
                Assert.assertEquals((Object)"shouldExist", (Object)vertex.value("v3"));
                Assert.assertTrue((boolean)memory.exists("m1"));
                Assert.assertTrue((boolean)memory.exists("m2"));
                Assert.assertTrue((boolean)memory.exists("m3"));
                Assert.assertFalse((boolean)((Boolean)memory.get("m1")));
                Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
                Assert.assertEquals((long)12L, (long)((Long)memory.get("m3")));
                memory.add("m1", (Object)true);
                memory.add("m2", (Object)true);
                memory.add("m3", (Object)2L);
            }
        }

        public boolean terminate(Memory memory) {
            Assert.assertTrue((boolean)memory.exists("m1"));
            Assert.assertTrue((boolean)memory.exists("m2"));
            Assert.assertTrue((boolean)memory.exists("m3"));
            if (memory.isInitialIteration()) {
                Assert.assertFalse((boolean)((Boolean)memory.get("m1")));
                Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
                Assert.assertEquals((long)12L, (long)((Long)memory.get("m3")));
                return false;
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("m1")));
            Assert.assertTrue((boolean)((Boolean)memory.get("m2")));
            Assert.assertEquals((long)24L, (long)((Long)memory.get("m3")));
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of((String)"m1", (BinaryOperator)Operator.or, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"m2", (BinaryOperator)Operator.and, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"m3", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false)));
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of((String)"v1", (boolean)true), VertexComputeKey.of((String)"v2", (boolean)true), VertexComputeKey.of((String)"v3", (boolean)false)));
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }
    }

    private static class VertexProgramN
    extends StaticVertexProgram {
        private VertexProgramN() {
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            if (vertex.label().equals("person")) {
                vertex.property(VertexProperty.Cardinality.single, "age", (Object)((Integer)vertex.value("age") + 1), new Object[0]);
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 1;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)"age", (boolean)false));
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }
    }

    private static class MapReduceJ
    implements MapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private String state;

        public MapReduceJ() {
        }

        public MapReduceJ(String state) {
            this.state = state;
        }

        public void loadState(Graph graph, Configuration configuration) {
            this.state = configuration.getString("state");
        }

        public void storeState(Configuration configuration) {
            configuration.setProperty("state", (Object)this.state);
            super.storeState(configuration);
        }

        public MapReduceJ clone() {
            return new MapReduceJ(this.state);
        }

        public boolean doStage(MapReduce.Stage stage) {
            return true;
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)1);
            switch (this.state) {
                case "softwareOnly": {
                    Assert.assertEquals((Object)"software", (Object)vertex.label());
                    break;
                }
                case "peopleOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    break;
                }
                case "knowsOnly": {
                    Assert.assertTrue((vertex.label().equals("person") || vertex.label().equals("software") ? 1 : 0) != 0);
                    break;
                }
                case "peopleKnowsOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    break;
                }
                case "peopleKnowsWellOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    break;
                }
                case "verticesOnly": {
                    Assert.assertTrue((vertex.label().equals("person") || vertex.label().equals("software") ? 1 : 0) != 0);
                    break;
                }
                case "oneOutEdgeOnly": {
                    Assert.assertTrue((vertex.label().equals("person") || vertex.label().equals("software") ? 1 : 0) != 0);
                    break;
                }
                case "outEdgesOnly": {
                    Assert.assertTrue((vertex.label().equals("person") || vertex.label().equals("software") ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new IllegalStateException("This is an illegal state for this test case: " + this.state);
                }
            }
        }

        public void combine(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            this.reduce(key, values, emitter);
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            int count = 0;
            while (values.hasNext()) {
                count += values.next().intValue();
            }
            emitter.emit((Object)count);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            int counter = (Integer)keyValues.next().getValue();
            Assert.assertFalse((boolean)keyValues.hasNext());
            switch (this.state) {
                case "softwareOnly": {
                    Assert.assertEquals((long)2L, (long)counter);
                    break;
                }
                case "peopleOnly": {
                    Assert.assertEquals((long)4L, (long)counter);
                    break;
                }
                case "knowsOnly": {
                    Assert.assertEquals((long)6L, (long)counter);
                    break;
                }
                case "peopleKnowsOnly": {
                    Assert.assertEquals((long)4L, (long)counter);
                    break;
                }
                case "peopleKnowsWellOnly": {
                    Assert.assertEquals((long)4L, (long)counter);
                    break;
                }
                case "verticesOnly": {
                    Assert.assertEquals((long)6L, (long)counter);
                    break;
                }
                case "oneOutEdgeOnly": {
                    Assert.assertEquals((long)6L, (long)counter);
                    break;
                }
                case "outEdgesOnly": {
                    Assert.assertEquals((long)6L, (long)counter);
                    break;
                }
                default: {
                    throw new IllegalStateException("This is an illegal state for this test case: " + this.state);
                }
            }
            return counter;
        }

        public String getMemoryKey() {
            return "a";
        }
    }

    public static class VertexProgramM
    implements VertexProgram {
        public static final String SOFTWARE_ONLY = "softwareOnly";
        public static final String PEOPLE_ONLY = "peopleOnly";
        public static final String KNOWS_ONLY = "knowsOnly";
        public static final String PEOPLE_KNOWS_ONLY = "peopleKnowsOnly";
        public static final String PEOPLE_KNOWS_WELL_ONLY = "peopleKnowsWellOnly";
        public static final String VERTICES_ONLY = "verticesOnly";
        public static final String ONE_OUT_EDGE_ONLY = "oneOutEdgeOnly";
        public static final String OUT_EDGES_ONLY = "outEdgesOnly";
        private String state;

        public VertexProgramM() {
        }

        public VertexProgramM(String state) {
            this.state = state;
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            switch (this.state) {
                case "softwareOnly": {
                    Assert.assertEquals((Object)"software", (Object)vertex.label());
                    Assert.assertFalse((boolean)vertex.edges(Direction.OUT, new String[0]).hasNext());
                    Assert.assertTrue((boolean)vertex.edges(Direction.IN, new String[0]).hasNext());
                    Assert.assertTrue((boolean)vertex.edges(Direction.IN, new String[]{"created"}).hasNext());
                    Assert.assertFalse((boolean)vertex.edges(Direction.IN, new String[]{"knows"}).hasNext());
                    break;
                }
                case "peopleOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    Assert.assertFalse((boolean)vertex.edges(Direction.IN, new String[]{"created"}).hasNext());
                    Assert.assertTrue((IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])) > 0L ? 1 : 0) != 0);
                    break;
                }
                case "knowsOnly": {
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"created"})));
                    if (vertex.value("name").equals("marko")) {
                        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                        break;
                    }
                    if (vertex.value("name").equals("vadas")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        break;
                    }
                    if (vertex.value("name").equals("josh")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        break;
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                case "peopleKnowsOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"created"})));
                    if (vertex.value("name").equals("marko")) {
                        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                        break;
                    }
                    if (vertex.value("name").equals("vadas")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        break;
                    }
                    if (vertex.value("name").equals("josh")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        break;
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                case "peopleKnowsWellOnly": {
                    Assert.assertEquals((Object)"person", (Object)vertex.label());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"created"})));
                    if (vertex.value("name").equals("marko")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                        Assert.assertEquals((double)1.0, (double)((Double)((Edge)vertex.edges(Direction.OUT, new String[]{"knows"}).next()).value("weight")), (double)0.001);
                        break;
                    }
                    if (vertex.value("name").equals("vadas")) {
                        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        break;
                    }
                    if (vertex.value("name").equals("josh")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[]{"knows"})));
                        Assert.assertEquals((double)1.0, (double)((Double)((Edge)vertex.edges(Direction.IN, new String[]{"knows"}).next()).value("weight")), (double)0.001);
                        break;
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[]{"knows"})));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                case "verticesOnly": {
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                case "oneOutEdgeOnly": {
                    if (vertex.label().equals("software") || vertex.value("name").equals("vadas")) {
                        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                        break;
                    }
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                case "outEdgesOnly": {
                    if (vertex.label().equals("software") || vertex.value("name").equals("vadas")) {
                        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                        break;
                    }
                    Assert.assertTrue((IteratorUtils.count((Iterator)vertex.edges(Direction.OUT, new String[0])) > 0L ? 1 : 0) != 0);
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)IteratorUtils.count((Iterator)vertex.edges(Direction.OUT, new String[0])), (long)IteratorUtils.count((Iterator)vertex.edges(Direction.BOTH, new String[0])));
                    break;
                }
                default: {
                    throw new IllegalStateException("This is an illegal state for this test case: " + this.state);
                }
            }
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }

        public VertexProgramM clone() {
            return new VertexProgramM(this.state);
        }

        public void loadState(Graph graph, Configuration configuration) {
            this.state = configuration.getString("state");
        }

        public void storeState(Configuration configuration) {
            configuration.setProperty("state", (Object)this.state);
            super.storeState(configuration);
        }
    }

    public static class MultiScopeVertexWithEdgeFunctionProgram
    extends StaticVertexProgram<Long> {
        private final MessageScope.Local<Long> countMessageScopeIn = MessageScope.Local.of(() -> __.inE((String[])new String[0]), (m, e) -> m * Math.round((Double)e.values(new String[]{"weight"}).next() * 10.0));
        private final MessageScope.Local<Long> countMessageScopeOut = MessageScope.Local.of(() -> __.outE((String[])new String[0]), (m, e) -> m * Math.round((Double)e.values(new String[]{"weight"}).next() * 10.0));
        private static final String MEMORY_KEY = "count";

        public void setup(Memory memory) {
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)MEMORY_KEY, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            HashSet<MessageScope> scopes = new HashSet<MessageScope>();
            scopes.add((MessageScope)this.countMessageScopeIn);
            scopes.add((MessageScope)this.countMessageScopeOut);
            return scopes;
        }

        public void execute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
            switch (memory.getIteration()) {
                case 0: {
                    if (!vertex.value("name").equals("josh")) break;
                    messenger.sendMessage(this.countMessageScopeIn, (Object)2L);
                    messenger.sendMessage(this.countMessageScopeOut, (Object)1L);
                    break;
                }
                case 1: {
                    long edgeCount = (Long)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)0L, (a, b) -> a + b);
                    vertex.property(MEMORY_KEY, (Object)edgeCount);
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() == 1;
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }
    }

    public static class MultiScopeVertexProgram
    extends StaticVertexProgram<Long> {
        private final MessageScope.Local<Long> countMessageScopeIn = MessageScope.Local.of(() -> __.inE((String[])new String[0]));
        private final MessageScope.Local<Long> countMessageScopeOut = MessageScope.Local.of(() -> __.outE((String[])new String[0]));
        private static final String MEMORY_KEY = "count";

        public void setup(Memory memory) {
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)MEMORY_KEY, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            HashSet<MessageScope> scopes = new HashSet<MessageScope>();
            scopes.add((MessageScope)this.countMessageScopeIn);
            scopes.add((MessageScope)this.countMessageScopeOut);
            return scopes;
        }

        public void execute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
            switch (memory.getIteration()) {
                case 0: {
                    if (!vertex.value("name").equals("josh")) break;
                    messenger.sendMessage(this.countMessageScopeIn, (Object)2L);
                    messenger.sendMessage(this.countMessageScopeOut, (Object)1L);
                    break;
                }
                case 1: {
                    long edgeCount = (Long)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)0L, (a, b) -> a + b);
                    vertex.property(MEMORY_KEY, (Object)edgeCount);
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() == 1;
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }
    }

    public static class VertexProgramL
    implements VertexProgram {
        boolean announced = false;

        public void setup(Memory memory) {
            memory.set("workerCount", (Object)0L);
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (!this.announced) {
                memory.add("workerCount", (Object)1L);
                this.announced = true;
            }
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return Collections.singleton(MemoryComputeKey.of((String)"workerCount", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }

        public VertexProgramL clone() {
            return new VertexProgramL();
        }

        public void storeState(Configuration configuration) {
            super.storeState(configuration);
        }
    }

    public static class VertexProgramK
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.property("money", (Object)((String)vertex.value("name")).length());
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)"money", (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.EDGES;
        }
    }

    private static class MapReduceI
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private static final Set<MapReduce.Stage> WORKER_START = new ConcurrentSkipListSet<MapReduce.Stage>();
        private static final Set<MapReduce.Stage> WORKER_END = new ConcurrentSkipListSet<MapReduce.Stage>();

        private MapReduceI() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return true;
        }

        public void workerStart(MapReduce.Stage stage) {
            WORKER_START.add(stage);
            if (!stage.equals((Object)MapReduce.Stage.MAP)) {
                Assert.assertFalse((boolean)WORKER_END.isEmpty());
            }
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)1);
            Assert.assertEquals((long)1L, (long)WORKER_START.size());
            Assert.assertTrue((boolean)WORKER_START.contains(MapReduce.Stage.MAP));
        }

        public void combine(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)2);
            Assert.assertEquals((long)2L, (long)WORKER_START.size());
            Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.COMBINE) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)WORKER_END.isEmpty());
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            emitter.emit((Object)3);
            if (WORKER_START.size() == 2) {
                Assert.assertEquals((long)2L, (long)WORKER_START.size());
                Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)3L, (long)WORKER_START.size());
                Assert.assertTrue((WORKER_START.contains(MapReduce.Stage.MAP) && WORKER_START.contains(MapReduce.Stage.COMBINE) && WORKER_START.contains(MapReduce.Stage.REDUCE) ? 1 : 0) != 0);
            }
            Assert.assertFalse((boolean)WORKER_END.isEmpty());
        }

        public void workerEnd(MapReduce.Stage stage) {
            Assert.assertFalse((boolean)WORKER_START.isEmpty());
            if (!stage.equals((Object)MapReduce.Stage.MAP)) {
                Assert.assertFalse((boolean)WORKER_END.isEmpty());
            }
            WORKER_END.add(stage);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            Assert.assertEquals((long)3L, (long)((Integer)keyValues.next().getValue()).intValue());
            return 3;
        }

        public String getMemoryKey() {
            return "a";
        }
    }

    public static class VertexProgramJ
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            memory.set("test", (Object)memory.getIteration());
        }

        public void workerIterationStart(Memory memory) {
            Assert.assertEquals((long)(memory.getIteration() * 6), (long)((Integer)memory.get("test")).intValue());
            try {
                memory.add("test", (Object)memory.getIteration());
                Assert.fail((String)"Should throw an immutable memory exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)Memory.Exceptions.memoryIsCurrentlyImmutable().getMessage(), (Object)e.getMessage());
            }
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((long)(memory.getIteration() * 6), (long)((Integer)memory.get("test")).intValue());
            memory.add("test", (Object)1);
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 3;
        }

        public void workerIterationEnd(Memory memory) {
            Assert.assertEquals((long)(memory.getIteration() * 6), (long)((Integer)memory.get("test")).intValue());
            try {
                memory.set("test", (Object)memory.getIteration());
                Assert.fail((String)"Should throw an immutable memory exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)Memory.Exceptions.memoryIsCurrentlyImmutable().getMessage(), (Object)e.getMessage());
            }
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return Collections.singleton(MemoryComputeKey.of((String)"test", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramI
    extends StaticVertexProgram<MapReduce.NullObject> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(Element::id);
            vertex.vertices(Direction.IN, new String[0]).forEachRemaining(Element::id);
            vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(Element::id);
            if (vertex.vertices(Direction.OUT, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.IN, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.IN, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(Element::label);
                    Assert.fail((String)"Adjacent vertex labels should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.OUT, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.OUT, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.IN, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.IN, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.property("name"));
                    Assert.fail((String)"Adjacent vertex properties should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.edges(Direction.BOTH, new String[0]));
                    Assert.fail((String)"Adjacent vertex edges should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
            if (vertex.vertices(Direction.BOTH, new String[0]).hasNext()) {
                try {
                    vertex.vertices(Direction.BOTH, new String[0]).forEachRemaining(v -> v.vertices(Direction.BOTH, new String[0]));
                    Assert.fail((String)"Adjacent vertex vertices should not be accessible in VertexProgram.execute()");
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated().getMessage(), (Object)e.getMessage());
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 1;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class MapReduceC
    extends StaticMapReduce<MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject, MapReduce.NullObject> {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, MapReduce.NullObject> emitter) {
            try {
                vertex.edges(Direction.OUT, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.edges(Direction.IN, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.edges(Direction.BOTH, new String[0]);
                Assert.fail((String)"Edges should not be accessible in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.incidentAndAdjacentElementsCanNotBeAccessedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.property("name", (Object)"bob");
                Assert.fail((String)"Vertex properties should be immutable in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce().getMessage(), (Object)e.getMessage());
            }
            try {
                vertex.property("name").property("test", (Object)1);
                Assert.fail((String)"Vertex properties should be immutable in MapReduce.map()");
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.vertexPropertiesCanNotBeUpdatedInMapReduce().getMessage(), (Object)e.getMessage());
            }
        }

        public String getMemoryKey() {
            return "nothing";
        }

        public MapReduce.NullObject generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, MapReduce.NullObject>> keyValues) {
            return MapReduce.NullObject.instance();
        }
    }

    public static class MapReduceBB
    extends StaticMapReduce<Integer, Integer, Integer, Integer, List<Integer>> {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Integer, Integer> emitter) {
            emitter.emit((Object)((String)vertex.value("name")).length(), (Object)((String)vertex.value("name")).length());
        }

        public Optional<Comparator<Integer>> getMapKeySort() {
            return Optional.of(Comparator.reverseOrder());
        }

        public String getMemoryKey() {
            return "nameLengths";
        }

        public List<Integer> generateFinalResult(Iterator<KeyValue<Integer, Integer>> keyValues) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            keyValues.forEachRemaining(nameLength -> list.add((Integer)nameLength.getKey()));
            return list;
        }
    }

    public static class MapReduceB
    extends StaticMapReduce<Integer, Integer, Integer, Integer, List<Integer>> {
        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.REDUCE) || stage.equals((Object)MapReduce.Stage.MAP);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Integer, Integer> emitter) {
            emitter.emit((Object)((String)vertex.value("name")).length(), (Object)((String)vertex.value("name")).length());
        }

        public void reduce(Integer key, Iterator<Integer> values, MapReduce.ReduceEmitter<Integer, Integer> emitter) {
            values.forEachRemaining(id -> emitter.emit(id, id));
        }

        public Optional<Comparator<Integer>> getReduceKeySort() {
            return Optional.of(Comparator.reverseOrder());
        }

        public String getMemoryKey() {
            return "nameLengths";
        }

        public List<Integer> generateFinalResult(Iterator<KeyValue<Integer, Integer>> keyValues) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            keyValues.forEachRemaining(nameLength -> list.add((Integer)nameLength.getKey()));
            return list;
        }
    }

    private static class MapReduceH2
    extends StaticMapReduce<Integer, Integer, Integer, Integer, Integer> {
        private MapReduceH2() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return true;
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Integer, Integer> emitter) {
            vertex.property("age").ifPresent(age -> emitter.emit(age, age));
        }

        public void combine(Integer key, Iterator<Integer> values, MapReduce.ReduceEmitter<Integer, Integer> emitter) {
            values.forEachRemaining(i -> emitter.emit(i, (Object)1));
        }

        public void reduce(Integer key, Iterator<Integer> values, MapReduce.ReduceEmitter<Integer, Integer> emitter) {
            values.forEachRemaining(i -> emitter.emit(i, (Object)1));
        }

        public Integer generateFinalResult(Iterator<KeyValue<Integer, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "b";
        }
    }

    private static class MapReduceH1
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private MapReduceH1() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP) || stage.equals((Object)MapReduce.Stage.REDUCE);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            vertex.property("counter").ifPresent(arg_0 -> emitter.emit(arg_0));
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().intValue();
            }
            emitter.emit((Object)sum);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "a";
        }
    }

    public static class VertexProgramH
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            vertex.property(VertexProperty.Cardinality.single, "counter", (Object)(memory.isInitialIteration() ? 1 : (Integer)vertex.value("counter") + 1), new Object[0]);
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 8;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)"counter", (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    private static class MapReduceA
    extends StaticMapReduce<MapReduce.NullObject, Integer, MapReduce.NullObject, Integer, Integer> {
        private MapReduceA() {
        }

        public boolean doStage(MapReduce.Stage stage) {
            return stage.equals((Object)MapReduce.Stage.MAP) || stage.equals((Object)MapReduce.Stage.REDUCE);
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Integer> emitter) {
            vertex.property("age").ifPresent(arg_0 -> emitter.emit(arg_0));
        }

        public void reduce(MapReduce.NullObject key, Iterator<Integer> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().intValue();
            }
            emitter.emit((Object)sum);
        }

        public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
            return (Integer)keyValues.next().getValue();
        }

        public String getMemoryKey() {
            return "ageSum";
        }
    }

    public static class VertexProgramG
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            memory.set("a", (Object)0L);
            memory.set("b", (Object)0L);
            memory.set("c", (Object)true);
            memory.set("d", (Object)false);
            memory.set("e", (Object)true);
            memory.set("f", (Object)memory.getIteration());
            try {
                memory.add("a", (Object)0L);
                Assert.fail((String)"Should only allow Memory.set() during VertexProgram.setup()");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memoryAddOnlyDuringVertexProgramExecute((String)"a"), e);
            }
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
            Assert.assertEquals((Object)0L, (Object)memory.get("b"));
            if (memory.isInitialIteration()) {
                Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                Assert.assertFalse((boolean)((Boolean)memory.get("d")));
            } else {
                Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("f")).intValue());
            memory.add("a", (Object)1L);
            memory.add("b", (Object)1L);
            memory.add("c", (Object)false);
            memory.add("d", (Object)true);
            memory.add("e", (Object)false);
            memory.add("f", (Object)(memory.getIteration() + 1));
            Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
            Assert.assertEquals((Object)0L, (Object)memory.get("b"));
            if (memory.isInitialIteration()) {
                Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                Assert.assertFalse((boolean)((Boolean)memory.get("d")));
            } else {
                Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            }
            Assert.assertTrue((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)memory.getIteration(), (long)((Integer)memory.get("f")).intValue());
            try {
                memory.set("a", (Object)0L);
                Assert.fail((String)"Should only allow Memory.add() during VertexProgram.execute()");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memorySetOnlyDuringVertexProgramSetUpAndTerminate((String)"a"), e);
            }
        }

        public boolean terminate(Memory memory) {
            Assert.assertEquals((Object)(6 * (memory.getIteration() + 1)), (Object)memory.get("a"));
            Assert.assertEquals((Object)6L, (Object)memory.get("b"));
            Assert.assertFalse((boolean)((Boolean)memory.get("c")));
            Assert.assertTrue((boolean)((Boolean)memory.get("d")));
            Assert.assertFalse((boolean)((Boolean)memory.get("e")));
            Assert.assertEquals((long)(memory.getIteration() + 1), (long)((Integer)memory.get("f")).intValue());
            memory.set("b", (Object)0L);
            memory.set("e", (Object)true);
            try {
                memory.add("a", (Object)0L);
                Assert.fail((String)"Should only allow Memory.set() during VertexProgram.terminate()");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memoryAddOnlyDuringVertexProgramExecute((String)"a"), e);
            }
            return memory.getIteration() > 1;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of((String)"a", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"b", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"c", (BinaryOperator)Operator.and, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"d", (BinaryOperator)Operator.or, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"e", (BinaryOperator)Operator.and, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"f", (BinaryOperator)Operator.assign, (boolean)true, (boolean)false)));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramF
    extends StaticVertexProgram<Object> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Object> messenger, Memory memory) {
            try {
                vertex.property(VertexProperty.Cardinality.single, "blah", (Object)"blah", new Object[0]);
                Assert.fail((String)"Should throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)"blah").getMessage(), (Object)e.getMessage());
            }
            catch (Exception e) {
                Assert.fail((String)("Should throw an IllegalArgumentException: " + e));
            }
            memory.add("a", (Object)1);
            if (memory.isInitialIteration()) {
                vertex.property(VertexProperty.Cardinality.single, "nameLengthCounter", (Object)((String)vertex.value("name")).length(), new Object[0]);
                memory.add("b", (Object)((String)vertex.value("name")).length());
            } else {
                vertex.property(VertexProperty.Cardinality.single, "nameLengthCounter", (Object)(((String)vertex.value("name")).length() + (Integer)vertex.value("nameLengthCounter")), new Object[0]);
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() == 1;
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)"nameLengthCounter", (boolean)false));
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of((String)"a", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"b", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false)));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramA
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramE
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            try {
                memory.get("a");
                Assert.fail((String)"The memory key does not exist and should fail");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memoryDoesNotExist((String)"a"), e);
            }
            try {
                memory.set("a", (Object)true);
                Assert.fail((String)"Setting a memory key that wasn't declared should fail");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)"a"), e);
            }
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            try {
                memory.get("a");
                Assert.fail((String)"The memory key does not exist and should fail");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memoryDoesNotExist((String)"a"), e);
            }
            try {
                memory.add("a", (Object)true);
                Assert.fail((String)"Setting a memory key that wasn't declared should fail");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)"a"), e);
            }
        }

        public boolean terminate(Memory memory) {
            try {
                memory.get("a");
                Assert.fail((String)"The memory key does not exist and should fail");
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(Memory.Exceptions.memoryDoesNotExist((String)"a"), e);
            }
            try {
                memory.set("a", (Object)true);
            }
            catch (Exception e) {
                AbstractGremlinTest.validateException(GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)"a"), e);
            }
            return true;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramD
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return Collections.singleton(MemoryComputeKey.of((String)"", (BinaryOperator)Operator.or, (boolean)true, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramC
    extends StaticVertexProgram {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
        }

        public boolean terminate(Memory memory) {
            return true;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return Collections.singleton(MemoryComputeKey.of(null, (BinaryOperator)Operator.or, (boolean)true, (boolean)false));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class VertexProgramB
    extends StaticVertexProgram {
        public void setup(Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
        }

        public boolean terminate(Memory memory) {
            Assert.assertEquals((long)0L, (long)memory.getIteration());
            Assert.assertTrue((boolean)memory.isInitialIteration());
            return true;
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of((String)"set", (BinaryOperator)Operator.assign, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"incr", (BinaryOperator)Operator.sum, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"and", (BinaryOperator)Operator.and, (boolean)true, (boolean)false), MemoryComputeKey.of((String)"or", (BinaryOperator)Operator.or, (boolean)true, (boolean)false)));
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.ORIGINAL;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.NOTHING;
        }
    }

    public static class BadGraphComputer
    implements GraphComputer {
        public GraphComputer result(GraphComputer.ResultGraph resultGraph) {
            return null;
        }

        public GraphComputer persist(GraphComputer.Persist persist) {
            return null;
        }

        public GraphComputer program(VertexProgram vertexProgram) {
            return null;
        }

        public GraphComputer mapReduce(MapReduce mapReduce) {
            return null;
        }

        public GraphComputer workers(int workers) {
            return null;
        }

        public GraphComputer vertices(Traversal<Vertex, Vertex> vertexFilter) {
            throw GraphComputer.Exceptions.graphFilterNotSupported();
        }

        public GraphComputer edges(Traversal<Vertex, Edge> edgeFilter) {
            throw GraphComputer.Exceptions.graphFilterNotSupported();
        }

        public GraphComputer configure(String key, Object value) {
            return null;
        }

        public Future<ComputerResult> submit() {
            return null;
        }

        public GraphComputer.Features features() {
            return new GraphComputer.Features(){

                public boolean supportsGraphFilter() {
                    return false;
                }
            };
        }
    }
}

