/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.remote.RemoteGraph;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_LP_O_P_S_SE_SL_TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_O_TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class SubgraphStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterVertexCriterion() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create()});
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).next();
            Assert.fail((String)"Edge 12 should not be in the graph because peter is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            Assert.fail((String)"Edge 7 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterEdgeCriterion() throws Exception {
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)1.0).hasLabel("knows", new String[0]), __.has((String)"weight", (Object)0.4).hasLabel("created", new String[0]).outV().has("name", (Object)"marko"), __.has((String)"weight", (Object)1.0).hasLabel("created", new String[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().edgeCriterion((Traversal)edgeCriterion).create();
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{strategy});
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        GraphTraversal t = sg.V(new Object[0]);
        t.hasNext();
        this.printTraversalForm((Traversal)t);
        Assert.assertEquals((long)6L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterComplexVertexCriterion() throws Exception {
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[]{"knows"}).has("name", (Object)"marko")).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[0]).has("name", (Object)"marko")).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[]{"knows"}).where((Traversal)__.out((String[])new String[]{"created"}).has("name", (Object)"lop"))).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[0]).where((Traversal)__.has((String)"name", (Object)"marko").out(new String[]{"created"}).has("name", (Object)"lop"))).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("marko", "vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.or((Traversal[])new Traversal[]{__.both((String[])new String[0]).has("name", (Object)"marko"), __.has((String)"name", (Object)"marko")})).create()}).V(new Object[0]).where((Traversal)__.bothE((String[])new String[0]).count().is((Object)P.neq((Object)0))).values(new String[]{"name"}));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterMixedCriteriaButNotCheckAdjacentVertices() {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)0.4).hasLabel("created", new String[0]), __.has((String)"weight", (Object)1.0).hasLabel("created", new String[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().checkAdjacentVertices(false).edges((Traversal)edgeCriterion).vertices((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{strategy});
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).bothV().count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterMixedCriteria() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)0.4).hasLabel("created", new String[0]), __.has((String)"weight", (Object)1.0).hasLabel("created", new String[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().edges((Traversal)edgeCriterion).vertices((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{strategy});
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next();
            Assert.fail((String)"Edge 9 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterVertexCriterionAndKeepLabels() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"ripple", "josh", "marko"}));
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create()});
        Assert.assertEquals((long)9L, (long)((Long)this.g.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).count().next()).intValue());
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).count().next()).intValue());
        List list = sg.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).values(new String[]{"name"}).toList();
        MatcherAssert.assertThat((Object)list, (Matcher)IsCollectionContaining.hasItems((Object[])new Object[]{"marko", "josh"}));
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedVertex() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create()});
        sg.V(new Object[]{this.convertToVertexId("marko")}).next();
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedEdge() throws Exception {
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)1.0).hasLabel("knows", new String[0]), __.has((String)"weight", (Object)0.4).hasLabel("created", new String[0]).outV().has("name", (Object)"marko"), __.has((String)"weight", (Object)1.0).hasLabel("created", new String[0])});
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().edges((Traversal)edgeCriterion).create()});
        sg.E(new Object[]{sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()}).next();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldFilterVertexProperties() throws Exception {
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertexProperties", __.has((String)"startTime", (P)P.gt((Object)2005)));
            }
        }))});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("purcellville", "baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).properties(new String[]{"location"}).value());
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("purcellville", "baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).values(new String[]{"location"}));
        if (sg.getStrategies().getStrategy(InlineFilterStrategy.class).isPresent()) {
            Assert.assertFalse((boolean)TraversalHelper.hasStepOfAssignableClassRecursively(TraversalFilterStep.class, (Traversal.Admin)sg.V(new Object[0]).properties(new String[]{"location"}).value().iterate().asAdmin()));
        }
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertexProperties((Traversal)__.has((String)"startTime", (P)P.gt((Object)2005))).create()});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("purcellville", "baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).as("a", new String[0]).properties(new String[]{"location"}).as("b", new String[0]).select("a").outE(new String[0]).properties(new String[0]).select("b").value().dedup(new String[0]));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("purcellville", "baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).as("a", new String[0]).values(new String[]{"location"}).as("b", new String[0]).select("a").outE(new String[0]).properties(new String[0]).select("b").dedup(new String[0]));
        if (sg.getStrategies().getStrategy(InlineFilterStrategy.class).isPresent()) {
            Assert.assertFalse((boolean)TraversalHelper.hasStepOfAssignableClassRecursively(TraversalFilterStep.class, (Traversal.Admin)sg.V(new Object[0]).as("a", new String[0]).values(new String[]{"location"}).as("b", new String[0]).select("a").outE(new String[0]).properties(new String[0]).select("b").dedup(new String[0]).iterate().asAdmin()));
        }
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.has((String)"name", (P)P.neq((Object)"stephen"))).vertexProperties((Traversal)__.has((String)"startTime", (P)P.gt((Object)2005))).create()});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).properties(new String[]{"location"}).value());
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("baltimore", "oakland", "seattle", "aachen"), sg.V(new Object[0]).values(new String[]{"location"}));
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.has((String)"name", (P)P.not((P)P.within((Object[])new String[]{"stephen", "daniel"})))).vertexProperties((Traversal)__.has((String)"startTime", (P)P.gt((Object)2005))).create()});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("baltimore", "oakland", "seattle"), sg.V(new Object[0]).properties(new String[]{"location"}).value());
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("baltimore", "oakland", "seattle"), sg.V(new Object[0]).values(new String[]{"location"}));
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.has((String)"name", (P)P.eq((Object)"matthias"))).vertexProperties((Traversal)__.has((String)"startTime", (P)P.gte((Object)2014))).create()});
        SubgraphStrategyProcessTest.checkResults(this.makeMapList(1, "seattle", 1L), sg.V(new Object[0]).groupCount().by("location"));
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.has((String)"location")).vertexProperties((Traversal)__.hasNot((String)"endTime")).create()});
        SubgraphStrategyProcessTest.checkOrderedResults(Arrays.asList("aachen", "purcellville", "santa fe", "seattle"), sg.V(new Object[0]).order().by("location", (Comparator)Order.asc).values(new String[]{"location"}));
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertices", __.has((String)"location"));
                this.put("vertexProperties", __.hasNot((String)"endTime"));
            }
        }))});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("aachen", "purcellville", "santa fe", "seattle"), sg.V(new Object[0]).valueMap(new String[]{"location"}).select(Column.values).unfold().unfold());
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("aachen", "purcellville", "santa fe", "seattle"), sg.V(new Object[0]).propertyMap(new String[]{"location"}).select(Column.values).unfold().unfold().value());
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().edges((Traversal)__.hasLabel((String)"uses", (String[])new String[0]).has("skill", (Object)5)).create()});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList(5, 5, 5), sg.V(new Object[0]).outE(new String[0]).valueMap(new String[0]).select(Column.values).unfold());
        SubgraphStrategyProcessTest.checkResults(Arrays.asList(5, 5, 5), sg.V(new Object[0]).outE(new String[0]).propertyMap(new String[0]).select(Column.values).unfold().value());
        sg = this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertexProperties((Traversal)__.hasNot((String)"skill")).create()});
        SubgraphStrategyProcessTest.checkResults(Arrays.asList(3, 3, 3, 4, 4, 5, 5, 5), sg.V(new Object[0]).outE(new String[]{"uses"}).values(new String[]{"skill"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList(3, 3, 3, 4, 4, 5, 5, 5), sg.V(new Object[0]).as("a", new String[0]).properties(new String[0]).select("a").dedup(new String[0]).outE(new String[0]).values(new String[]{"skill"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList(3, 3, 3, 4, 4, 5, 5, 5), sg.V(new Object[0]).as("a", new String[0]).properties(new String[0]).select("a").dedup(new String[0]).outE(new String[0]).properties(new String[]{"skill"}).as("b", new String[0]).identity().select("b").by((Traversal)__.value()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGenerateCorrectTraversers() throws Exception {
        Assume.assumeThat((Object)this.graph, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(RemoteGraph.class)));
        SubgraphStrategy strategy = SubgraphStrategy.build().vertices((Traversal)__.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}))).create();
        GraphTraversalSource sg = this.g.withStrategies(new TraversalStrategy[]{strategy});
        GraphTraversal.Admin traversal = sg.V(new Object[0]).outE(new String[0]).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_O_TraverserGenerator));
        traversal = sg.V(new Object[0]).outE(new String[0]).inV().iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_O_TraverserGenerator));
        traversal = sg.V(new Object[0]).out(new String[0]).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_O_TraverserGenerator));
        traversal = sg.V(new Object[0]).bothE(new String[0]).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_O_TraverserGenerator));
        traversal = sg.V(new Object[0]).bothE(new String[0]).otherV().iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_LP_O_P_S_SE_SL_TraverserGenerator));
        traversal = sg.V(new Object[0]).both(new String[0]).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_LP_O_P_S_SE_SL_TraverserGenerator));
        traversal = sg.V(new Object[0]).flatMap((Traversal)__.bothE((String[])new String[0])).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_O_TraverserGenerator));
        traversal = sg.V(new Object[0]).flatMap((Traversal)__.bothE((String[])new String[0]).otherV()).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_LP_O_P_S_SE_SL_TraverserGenerator));
        traversal = sg.V(new Object[0]).flatMap((Traversal)__.both((String[])new String[0])).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_LP_O_P_S_SE_SL_TraverserGenerator));
        strategy = SubgraphStrategy.build().vertices((Traversal)__.filter((Traversal)__.simplePath())).create();
        sg = this.g.withStrategies(new TraversalStrategy[]{strategy});
        traversal = sg.V(new Object[0]).out(new String[0]).iterate().asAdmin();
        Assert.assertTrue((boolean)(traversal.getTraverserGenerator() instanceof B_LP_O_P_S_SE_SL_TraverserGenerator));
    }
}

