/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceVertexPropertyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyReferenced() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceVertexProperty dvp = ReferenceFactory.detach((VertexProperty)vp);
        Assert.assertEquals((Object)"test", (Object)dvp.label());
        Assert.assertEquals((Object)"test", (Object)dvp.key());
        Assert.assertEquals((Object)"this", (Object)dvp.value());
        Assert.assertSame((Object)dvp, (Object)ReferenceFactory.detach((VertexProperty)dvp));
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotSupportRemove() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceFactory.detach((VertexProperty)vp).remove();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldBeEqualsPropertiesAsIdIsTheSame() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceVertexProperty vp1 = ReferenceFactory.detach((VertexProperty)vp);
        ReferenceVertexProperty vp2 = ReferenceFactory.detach((VertexProperty)vp);
        Assert.assertTrue((boolean)vp1.equals((Object)vp2));
        Assert.assertTrue((boolean)vp1.equals((Object)vp));
        Assert.assertTrue((boolean)vp.equals(vp2));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotBeEqualsPropertiesAsIdIsDifferent() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp1 = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceVertexProperty mp1 = ReferenceFactory.detach((VertexProperty)vp1);
        VertexProperty vp2 = v.property(VertexProperty.Cardinality.single, "testing", (Object)"this", new Object[0]);
        ReferenceVertexProperty mp2 = ReferenceFactory.detach((VertexProperty)vp2);
        Assert.assertFalse((boolean)mp1.equals((Object)mp2));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAttachToGraph() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty toReference = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceVertexProperty rvp = ReferenceFactory.detach((VertexProperty)toReference);
        VertexProperty referenced = (VertexProperty)rvp.attach(Attachable.Method.get((Host)this.graph));
        Assert.assertEquals((Object)toReference, (Object)referenced);
        Assert.assertFalse((boolean)(referenced instanceof ReferenceVertexProperty));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAttachToVertex() {
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty toReference = v.property(VertexProperty.Cardinality.single, "test", (Object)"this", new Object[0]);
        ReferenceVertexProperty rvp = ReferenceFactory.detach((VertexProperty)toReference);
        VertexProperty referenced = (VertexProperty)rvp.attach(Attachable.Method.get((Host)v));
        Assert.assertEquals((Object)toReference, (Object)referenced);
        Assert.assertEquals(toReference.getClass(), referenced.getClass());
        Assert.assertFalse((boolean)(referenced instanceof ReferenceVertexProperty));
    }
}

