/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.algorithm.generator.DistributionGenerator;
import org.apache.tinkerpop.gremlin.algorithm.generator.PowerLawDistribution;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
@Deprecated
public class GraphReadPerformanceTest {

    @AxisRange(min=0.0, max=1.0)
    @BenchmarkMethodChart(filePrefix="gremlin-read")
    @BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20, filePrefix="hx-gremlin-read")
    public static class ReadFromGraph
    extends AbstractGremlinTest {
        @Rule
        public TestRule benchmarkRun = new BenchmarkRule();
        private Set<Object> ids = new HashSet<Object>();
        private int edgeCount = 0;

        @Override
        protected void afterLoadGraphWith(Graph g) throws Exception {
            this.ids.clear();
            int numVertices = 10000;
            Random r = new Random(854939487556L);
            for (int i = 0; i < 10000; ++i) {
                Vertex v = g.addVertex(new Object[]{"oid", i, "name", RandomStringUtils.randomAlphabetic((int)r.nextInt(1024))});
                this.ids.add(v.id());
            }
            PowerLawDistribution inDist = new PowerLawDistribution(2.3);
            PowerLawDistribution outDist = new PowerLawDistribution(2.8);
            DistributionGenerator generator = ((DistributionGenerator.Builder)((DistributionGenerator.Builder)((DistributionGenerator.Builder)DistributionGenerator.build(g).label("knows")).seedGenerator(r::nextLong)).outDistribution(outDist).inDistribution(inDist).edgeProcessor(e -> e.property("weight", (Object)r.nextDouble()))).expectedNumEdges(30000).create();
            this.edgeCount = generator.generate();
        }

        @Test
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void readAllVerticesAndProperties() throws Exception {
            AtomicInteger counter = new AtomicInteger(0);
            for (int ix = 0; ix < 10; ++ix) {
                this.graph.vertices(new Object[0]).forEachRemaining(vertex -> {
                    Assert.assertNotNull((Object)vertex.value("name"));
                    counter.incrementAndGet();
                });
                Assert.assertEquals((long)10000L, (long)counter.get());
                counter.set(0);
            }
        }

        @Test
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void readAllEdgesAndProperties() throws Exception {
            AtomicInteger counter = new AtomicInteger(0);
            for (int ix = 0; ix < 10; ++ix) {
                this.graph.edges(new Object[0]).forEachRemaining(edge -> {
                    Assert.assertNotNull((Object)edge.value("weight"));
                    counter.incrementAndGet();
                });
                Assert.assertEquals((long)this.edgeCount, (long)counter.get());
                counter.set(0);
            }
        }
    }
}

