/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class PageRankTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_pageRank();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_outXcreatedX_pageRank_byXbothEX_byXprojectRankX_timesX0X_valueMapXname_projectRankX();

    public abstract Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_decrX_name();

    public abstract Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_decrX_name_limitX2X();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_pageRank_byXoutEXknowsXX_byXfriendRankX_valueMapXname_friendRankX();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_pageRank_byXpageRankX_order_byXpageRankX_valueMapXname_pageRankX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_byXpageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_byXinEXcreatedXX_timesX1X_byXpriorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX();

    public abstract Traversal<Vertex, Map<Object, List<Vertex>>> get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_byXpageRankX_byXinEX_timesX1X_inXcreatedX_groupXmX_byXpageRankX_capXmX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_pageRank();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            ++counter;
            Assert.assertTrue((boolean)vertex.property("gremlin.pageRankVertexProgram.pageRank").isPresent());
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXcreatedX_pageRank_byXbothEX_byXprojectRankX_valueMapXname_projectRankX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_outXcreatedX_pageRank_byXbothEX_byXprojectRankX_timesX0X_valueMapXname_projectRankX();
        this.printTraversalForm(traversal);
        List result = traversal.toList();
        Assert.assertEquals((long)4L, (long)result.size());
        HashMap map = new HashMap();
        result.forEach(m -> map.put((String)((List)m.get("name")).get(0), (Double)((List)m.get("projectRank")).get(0)));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("lop"));
        Assert.assertTrue((boolean)map.containsKey("ripple"));
        Assert.assertTrue(((Double)map.get("lop") > (Double)map.get("ripple") ? 1 : 0) != 0);
        Assert.assertEquals((double)3.0, (double)((Double)map.get("lop")), (double)0.001);
        Assert.assertEquals((double)1.0, (double)((Double)map.get("ripple")), (double)0.001);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_order_byXpageRank_decrX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_pageRank_order_byXpageRank_decrX_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertEquals((Object)"lop", names.get(0));
        Assert.assertEquals((Object)"ripple", names.get(1));
        Assert.assertTrue((((String)names.get(2)).equals("josh") || ((String)names.get(2)).equals("vadas") ? 1 : 0) != 0);
        Assert.assertTrue((((String)names.get(3)).equals("josh") || ((String)names.get(3)).equals("vadas") ? 1 : 0) != 0);
        Assert.assertTrue((((String)names.get(4)).equals("marko") || ((String)names.get(4)).equals("peter") ? 1 : 0) != 0);
        Assert.assertTrue((((String)names.get(5)).equals("marko") || ((String)names.get(5)).equals("peter") ? 1 : 0) != 0);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_byXoutEXknowsXX_byXfriendRankX_valueMapXname_friendRankX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_pageRank_byXoutEXknowsXX_byXfriendRankX_valueMapXname_friendRankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertEquals((long)1L, (long)((List)map.get("name")).size());
            Assert.assertEquals((long)1L, (long)((List)map.get("friendRank")).size());
            String name = (String)((List)map.get("name")).get(0);
            Double friendRank = (Double)((List)map.get("friendRank")).get(0);
            if (name.equals("lop") || name.equals("ripple") || name.equals("peter") || name.equals("marko")) {
                Assert.assertEquals((double)0.15, (double)friendRank, (double)0.01);
            } else {
                Assert.assertEquals((double)0.21375, (double)friendRank, (double)0.01);
            }
            ++counter;
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_order_byXpageRank_decrX_name_limitX2X() {
        Traversal<Vertex, String> traversal = this.get_g_V_pageRank_order_byXpageRank_decrX_name_limitX2X();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertEquals((Object)"lop", names.get(0));
        Assert.assertEquals((Object)"ripple", names.get(1));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_pageRank_byXpageRankX_order_byXpageRankX_valueMapXname_pageRankX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_hasLabelXpersonX_pageRank_byXpageRankX_order_byXpageRankX_valueMapXname_pageRankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        double lastPageRank = Double.MIN_VALUE;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertEquals((long)1L, (long)((List)map.get("name")).size());
            Assert.assertEquals((long)1L, (long)((List)map.get("pageRank")).size());
            String name = (String)((List)map.get("name")).get(0);
            double pageRank = (Double)((List)map.get("pageRank")).get(0);
            Assert.assertTrue((pageRank >= lastPageRank ? 1 : 0) != 0);
            lastPageRank = pageRank;
            Assert.assertFalse((name.equals("lop") || name.equals("ripple") ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_byXpageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_pageRank_byXpageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Vertex vertex = (Vertex)map.get("a");
            double pageRank = (Double)map.get("b");
            Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)vertex.id());
            Assert.assertTrue((pageRank > 0.15 ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_byXinEXcreatedXX_timesX1X_byXpriorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_byXinEXcreatedXX_timesX1X_byXpriorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            String name = (String)((List)map.get("name")).get(0);
            double pageRank = (Double)((List)map.get("priors")).get(0);
            Assert.assertEquals((double)(name.equals("josh") ? 1.0 : 0.0), (double)pageRank, (double)1.0E-4);
            if (name.equals("peter") || name.equals("vadas")) {
                Assert.fail((String)"Peter or Vadas should not have been accessed");
            }
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_byXpageRankX_byXinEX_timesX1X_inXcreatedX_groupXmX_byXpageRankX_capXmX() {
        Traversal<Vertex, Map<Object, List<Vertex>>> traversal = this.get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_byXpageRankX_byXinEX_timesX1X_inXcreatedX_groupXmX_byXpageRankX_capXmX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("software"));
        map.forEach((k, v) -> {
            boolean found = false;
            if (!k.equals("software") && v.size() == 4) {
                Assert.assertEquals((double)2.0, (double)((Number)k).doubleValue(), (double)0.01);
                Assert.assertEquals((long)4L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "josh"))).count());
                found = true;
            } else if (v.size() == 6) {
                Assert.assertEquals((double)1.0, (double)((Number)k).doubleValue(), (double)0.01);
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "peter"))).count());
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "marko"))).count());
                found = true;
            } else if (v.size() == 4) {
                Assert.assertEquals((Object)"software", (Object)k);
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "lop"))).count());
                Assert.assertEquals((long)1L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "ripple"))).count());
                found = true;
            }
            if (!found) {
                Assert.fail((String)("There are too many key/values: " + k + "--" + v));
            }
        });
    }

    public static class Traversals
    extends PageRankTest {
        @Override
        public Traversal<Vertex, Vertex> get_g_V_pageRank() {
            return this.g.V(new Object[0]).pageRank();
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_outXcreatedX_pageRank_byXbothEX_byXprojectRankX_timesX0X_valueMapXname_projectRankX() {
            return this.g.V(new Object[0]).out(new String[]{"created"}).pageRank().by((Traversal)__.bothE((String[])new String[0])).by("projectRank").times(0).valueMap(new String[]{"name", "projectRank"});
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_pageRank_byXoutEXknowsXX_byXfriendRankX_valueMapXname_friendRankX() {
            return this.g.V(new Object[0]).pageRank().by((Traversal)__.outE((String[])new String[]{"knows"})).by("friendRank").valueMap(new String[]{"name", "friendRank"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_decrX_name() {
            return this.g.V(new Object[0]).pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", (Comparator)Order.decr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_decrX_name_limitX2X() {
            return this.g.V(new Object[0]).pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", (Comparator)Order.decr).values(new String[]{"name"}).limit(2L);
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_pageRank_byXpageRankX_order_byXpageRankX_valueMapXname_pageRankX() {
            return this.g.V(new Object[0]).hasLabel((Object)"person", new Object[0]).pageRank().by("pageRank").order().by("pageRank").valueMap(new String[]{"name", "pageRank"});
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_byXpageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX() {
            return this.g.V(new Object[0]).pageRank().by("pageRank").as("a", new String[0]).out(new String[]{"knows"}).values(new String[]{"pageRank"}).as("b", new String[0]).select("a", "b", new String[0]);
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_byXinEXcreatedXX_timesX1X_byXpriorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX() {
            return this.g.V(new Object[0]).hasLabel((Object)"software", new Object[0]).has("name", (Object)"ripple").pageRank(1.0).by((Traversal)__.inE((String[])new String[]{"created"})).times(1).by("priors").in(new String[]{"created"}).union(new Traversal[]{__.both((String[])new String[0]), __.identity()}).valueMap(new String[]{"name", "priors"});
        }

        @Override
        public Traversal<Vertex, Map<Object, List<Vertex>>> get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_byXpageRankX_byXinEX_timesX1X_inXcreatedX_groupXmX_byXpageRankX_capXmX() {
            return this.g.V(new Object[0]).out(new String[]{"created"}).group("m").by(T.label).pageRank(1.0).by("pageRank").by((Traversal)__.inE((String[])new String[0])).times(1).in(new String[]{"created"}).group("m").by("pageRank").cap("m", new String[0]);
        }
    }
}

