/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class SubgraphStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterVertexCriterion() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        SubgraphStrategy strategy = SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).next();
            Assert.fail((String)"Edge 12 should not be in the graph because peter is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            Assert.fail((String)"Edge 7 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterEdgeCriterion() throws Exception {
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)1.0).hasLabel((Object)"knows", new Object[0]), __.has((String)"weight", (Object)0.4).hasLabel((Object)"created", new Object[0]).outV().has("name", (Object)"marko"), __.has((String)"weight", (Object)1.0).hasLabel((Object)"created", new Object[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().edgeCriterion((Traversal)edgeCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        GraphTraversal t = sg.V(new Object[0]);
        t.hasNext();
        this.printTraversalForm((Traversal)t);
        Assert.assertEquals((long)6L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterComplexVertexCriterion() throws Exception {
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[]{"knows"}).has("name", (Object)"marko")).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[0]).has("name", (Object)"marko")).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[]{"knows"}).where((Traversal)__.out((String[])new String[]{"created"}).has("name", (Object)"lop"))).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.in((String[])new String[0]).where((Traversal)__.has((String)"name", (Object)"marko").out(new String[]{"created"}).has("name", (Object)"lop"))).create()}).V(new Object[0]).values(new String[]{"name"}));
        SubgraphStrategyProcessTest.checkResults(Arrays.asList("marko", "vadas", "josh", "lop"), this.g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.build().vertices((Traversal)__.or((Traversal[])new Traversal[]{__.both((String[])new String[0]).has("name", (Object)"marko"), __.has((String)"name", (Object)"marko")})).create()}).V(new Object[0]).where((Traversal)__.bothE((String[])new String[0]).count().is((Object)P.neq((Object)0))).values(new String[]{"name"}));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterMixedCriteria() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)0.4).hasLabel((Object)"created", new Object[0]), __.has((String)"weight", (Object)1.0).hasLabel((Object)"created", new Object[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().edgeCriterion((Traversal)edgeCriterion).vertexCriterion((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next();
            Assert.fail((String)"Edge 9 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterVertexCriterionAndKeepLabels() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"ripple", "josh", "marko"}));
        SubgraphStrategy strategy = SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)9L, (long)((Long)this.g.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).count().next()).intValue());
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).count().next()).intValue());
        List list = sg.V(new Object[0]).as("a", new String[0]).out(new String[0]).in(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).values(new String[]{"name"}).toList();
        MatcherAssert.assertThat((Object)list, (Matcher)IsCollectionContaining.hasItems((Object[])new Object[]{"marko", "josh"}));
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedVertex() throws Exception {
        GraphTraversal vertexCriterion = __.has((String)"name", (P)P.within((Object[])new String[]{"josh", "lop", "ripple"}));
        SubgraphStrategy strategy = SubgraphStrategy.build().vertexCriterion((Traversal)vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        sg.V(new Object[]{this.convertToVertexId("marko")}).next();
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedEdge() throws Exception {
        GraphTraversal edgeCriterion = __.or((Traversal[])new Traversal[]{__.has((String)"weight", (Object)1.0).hasLabel((Object)"knows", new Object[0]), __.has((String)"weight", (Object)0.4).hasLabel((Object)"created", new Object[0]).outV().has("name", (Object)"marko"), __.has((String)"weight", (Object)1.0).hasLabel((Object)"created", new Object[0])});
        SubgraphStrategy strategy = SubgraphStrategy.build().edgeCriterion((Traversal)edgeCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        sg.E(new Object[]{sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()}).next();
    }

    private GraphTraversalSource create(SubgraphStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }
}

