/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class ProgramTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_programXpageRankX();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_programXpageRankX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_programXpageRankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            ++counter;
            Assert.assertTrue((boolean)vertex.property("gremlin.pageRankVertexProgram.pageRank").isPresent());
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_decrX_valueMapXname_rankX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        double lastRank = Double.MIN_VALUE;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertEquals((long)1L, (long)((List)map.get("name")).size());
            Assert.assertEquals((long)1L, (long)((List)map.get("rank")).size());
            String name = (String)((List)map.get("name")).get(0);
            double rank = (Double)((List)map.get("rank")).get(0);
            Assert.assertTrue((rank >= lastRank ? 1 : 0) != 0);
            lastRank = rank;
            Assert.assertFalse((name.equals("lop") || name.equals("ripple") ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    public static class Traversals
    extends ProgramTest {
        @Override
        public Traversal<Vertex, Vertex> get_g_V_programXpageRankX() {
            return this.g.V(new Object[0]).program(PageRankVertexProgram.build().create(this.graph));
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX() {
            return this.g.V(new Object[0]).hasLabel(new String[]{"person"}).program(PageRankVertexProgram.build().property("rank").create(this.graph)).order().by("rank", (Comparator)Order.incr).valueMap(new String[]{"name", "rank"});
        }
    }
}

