/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class PropertiesTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Object> get_g_V_hasXageX_propertiesXname_ageX_value();

    public abstract Traversal<Vertex, Object> get_g_V_hasXageX_propertiesXage_nameX_value();

    public abstract Traversal<Vertex, Object> get_g_V_hasXageX_properties_hasXid_nameIdX_value(Object var1);

    public abstract Traversal<Vertex, VertexProperty<String>> get_g_V_hasXageX_propertiesXnameX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXageX_propertiesXname_ageX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_hasXageX_propertiesXname_ageX_value();
        this.printTraversalForm(traversal);
        PropertiesTest.checkResults(Arrays.asList("marko", 29, "vadas", 27, "josh", 32, "peter", 35), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXageX_propertiesXage_nameX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_hasXageX_propertiesXage_nameX_value();
        this.printTraversalForm(traversal);
        PropertiesTest.checkResults(Arrays.asList("marko", 29, "vadas", 27, "josh", 32, "peter", 35), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXageX_properties_hasXid_nameIdX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_hasXageX_properties_hasXid_nameIdX_value(this.convertToVertexPropertyId("marko", "name").next());
        this.printTraversalForm(traversal);
        PropertiesTest.checkResults(Collections.singletonList("marko"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXageX_properties_hasXid_nameIdAsStringX_value() {
        Traversal<Vertex, Object> traversal = this.get_g_V_hasXageX_properties_hasXid_nameIdX_value(this.convertToVertexPropertyId("marko", "name").next().toString());
        this.printTraversalForm(traversal);
        PropertiesTest.checkResults(Collections.singletonList("marko"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXageX_propertiesXnameX() {
        Traversal<Vertex, VertexProperty<String>> traversal = this.get_g_V_hasXageX_propertiesXnameX();
        this.printTraversalForm(traversal);
        HashSet<String> keys = new HashSet<String>();
        HashSet<Object> values = new HashSet<Object>();
        HashSet<Object> ids = new HashSet<Object>();
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            VertexProperty vertexProperty = (VertexProperty)traversal.next();
            keys.add(vertexProperty.key());
            values.add(vertexProperty.value());
            ids.add(vertexProperty.id());
            Object id = vertexProperty.id();
            id = id instanceof Number ? Long.valueOf(((Number)id).longValue()) : id;
            Object otherId = this.convertToVertex(this.graph, (String)vertexProperty.value()).property("name").id();
            otherId = otherId instanceof Number ? Long.valueOf(((Number)otherId).longValue()) : otherId;
            Assert.assertEquals((Object)otherId, (Object)id);
            Assert.assertEquals((Object)"name", (Object)vertexProperty.key());
            Assert.assertEquals(this.convertToVertex(this.graph, (String)vertexProperty.value()).values(new String[]{"name"}).next(), (Object)vertexProperty.value());
            Assert.assertEquals((Object)this.convertToVertex(this.graph, (String)vertexProperty.value()).value("name"), (Object)vertexProperty.value());
        }
        Assert.assertEquals((long)4L, (long)counter);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("name"));
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("marko"));
        Assert.assertTrue((boolean)values.contains("vadas"));
        Assert.assertTrue((boolean)values.contains("josh"));
        Assert.assertTrue((boolean)values.contains("peter"));
        Assert.assertEquals((long)4L, (long)ids.size());
    }

    public static class Traversals
    extends PropertiesTest {
        @Override
        public Traversal<Vertex, Object> get_g_V_hasXageX_propertiesXname_ageX_value() {
            return this.g.V(new Object[0]).has("age").properties(new String[]{"name", "age"}).value();
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_hasXageX_propertiesXage_nameX_value() {
            return this.g.V(new Object[0]).has("age").properties(new String[]{"age", "name"}).value();
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_hasXageX_properties_hasXid_nameIdX_value(Object nameId) {
            return this.g.V(new Object[0]).has("age").properties(new String[0]).has(T.id, nameId).value();
        }

        @Override
        public Traversal<Vertex, VertexProperty<String>> get_g_V_hasXageX_propertiesXnameX() {
            return this.g.V(new Object[0]).has("age").properties(new String[]{"name"});
        }
    }
}

