/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.util;

import java.io.IOException;
import java.util.UUID;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class CustomId {
    private String cluster;
    private UUID elementId;

    private CustomId() {
    }

    public CustomId(String cluster, UUID elementId) {
        this.cluster = cluster;
        this.elementId = elementId;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UUID getElementId() {
        return this.elementId;
    }

    public String toString() {
        return this.cluster + ":" + this.elementId;
    }

    public static class CustomIdJacksonSerializer
    extends StdSerializer<CustomId> {
        public CustomIdJacksonSerializer() {
            super(CustomId.class);
        }

        public void serialize(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(customId.toString());
        }

        public void serializeWithType(CustomId customId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("@class", CustomId.class.getName());
            jsonGenerator.writeStringField("cluster", customId.getCluster());
            jsonGenerator.writeObjectField("elementId", (Object)customId.getElementId());
            jsonGenerator.writeEndObject();
        }
    }
}

