/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphProvider
implements GraphProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGraphProvider.class);

    public abstract Map<String, Object> getBaseConfiguration(String var1, Class<?> var2, String var3, LoadGraphWith.GraphData var4);

    @Override
    public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, Map<String, Object> configurationOverrides, LoadGraphWith.GraphData loadGraphWith) {
        BaseConfiguration conf = new BaseConfiguration();
        this.getBaseConfiguration(graphName, test, testMethodName, loadGraphWith).entrySet().stream().forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$129((Configuration)conf, arg_0));
        configurationOverrides.entrySet().stream().filter(c -> !((String)c.getKey()).equals("gremlin.graph")).forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$131((Configuration)conf, arg_0));
        return conf;
    }

    @Override
    public void loadGraphData(Graph graph, LoadGraphWith loadGraphWith, Class testClass, String testName) {
        try {
            if (loadGraphWith != null) {
                this.readIntoGraph(graph, loadGraphWith.value().location());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Graph could not be loaded with data for test: " + ioe.getMessage());
        }
    }

    protected static void deleteDirectory(File directory) {
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    AbstractGraphProvider.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
        if (directory.exists()) {
            logger.error("unable to delete directory " + directory.getAbsolutePath());
        }
    }

    protected void readIntoGraph(Graph g, String path) throws IOException {
        GryoReader reader = GryoReader.build().mapper((Mapper)((GryoIo)g.io(GryoIo.build())).mapper().create()).create();
        try (InputStream stream = AbstractGremlinTest.class.getResourceAsStream(path);){
            reader.readGraph(stream, g);
        }
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$131(Configuration conf, Map.Entry e) {
        conf.setProperty((String)e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$129(Configuration conf, Map.Entry e) {
        conf.setProperty((String)e.getKey(), e.getValue());
    }
}

