/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;

public class StarGraphTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldHashAndEqualsCorrectly() {
        Vertex gremlin = (Vertex)this.g.V(new Object[]{this.convertToVertexId("gremlin")}).next();
        StarGraph gremlinStarGraph = StarGraph.of((Vertex)gremlin);
        StarGraph.StarVertex gremlinStar = gremlinStarGraph.getStarVertex();
        Vertex marko = (Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next();
        StarGraph markoStarGraph = StarGraph.of((Vertex)marko);
        StarGraph.StarAdjacentVertex gremlinStarAdjacentGraph = (StarGraph.StarAdjacentVertex)((Edge)IteratorUtils.filter((Iterator)markoStarGraph.getStarVertex().edges(Direction.OUT, new String[]{"uses"}), x -> x.inVertex().id().equals(this.convertToVertexId("gremlin"))).next()).inVertex();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            set.add(gremlin);
            set.add(gremlinStar);
            set.add(gremlinStarAdjacentGraph);
        }
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldValidateThatOriginalAndStarVerticesHaveTheSameTopology() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldSerializeCorrectlyUsingGryo() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, ((StarGraph)this.serializeDeserialize(StarGraph.of((Vertex)vertex)).getValue0()).getStarVertex()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldAttachWithGetMethod() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex().attach(Attachable.Method.get((Host)vertex))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, ((Attachable)vertexProperty).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, ((Attachable)edge).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex().attach(Attachable.Method.get((Host)this.graph))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, ((Attachable)vertexProperty).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)this.graph))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, ((Attachable)edge).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)this.graph))))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void shouldAttachWithCreateMethod() {
        Random random = new Random(234335L);
        StarGraph starGraph = StarGraph.open();
        Vertex starVertex = starGraph.addVertex(new Object[]{T.label, "person", "name", "stephen", "name", "spmallete"});
        starVertex.property("acl", (Object)true, new Object[]{"timestamp", random.nextLong(), "creator", "marko"});
        for (int i = 0; i < 100; ++i) {
            starVertex.addEdge("knows", starGraph.addVertex(new Object[]{"person", "name", new UUID(random.nextLong(), random.nextLong()), "since", random.nextLong()}), new Object[0]);
            starGraph.addVertex(new Object[]{T.label, "project"}).addEdge("developedBy", starVertex, new Object[]{"public", random.nextBoolean()});
        }
        Vertex createdVertex = (Vertex)starGraph.getStarVertex().attach(Attachable.Method.create((Host)this.graph));
        starGraph.getStarVertex().edges(Direction.BOTH, new String[0]).forEachRemaining(edge -> {
            Edge cfr_ignored_0 = (Edge)((Attachable)edge).attach(Attachable.Method.create((Host)(random.nextBoolean() ? this.graph : createdVertex)));
        });
        TestHelper.validateEquality(starVertex, createdVertex);
    }

    private Pair<StarGraph, Integer> serializeDeserialize(StarGraph starGraph) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((GryoIo)this.graph.io(IoCore.gryo())).writer().create().writeObject((OutputStream)outputStream, (Object)starGraph);
            return Pair.with((Object)((GryoIo)this.graph.io(IoCore.gryo())).reader().create().readObject((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), StarGraph.class), (Object)outputStream.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

