/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Arrays;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class SubgraphTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Graph> get_g_V_withSideEffectXsgX_outEXknowsX_subgraphXsgX_name_capXsgX(Object var1, Graph var2);

    public abstract Traversal<Vertex, String> get_g_V_withSideEffectXsgX_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup(Graph var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_withSideEffectXsgX_outEXknowsX_subgraphXsgX_name_capXsgX() throws Exception {
        Configuration config = this.graphProvider.newGraphConfiguration("subgraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
        this.graphProvider.clear(config);
        Graph subgraph = this.graphProvider.openTestGraph(config);
        Traversal<Vertex, Graph> traversal = this.get_g_V_withSideEffectXsgX_outEXknowsX_subgraphXsgX_name_capXsgX(this.convertToVertexId("marko"), subgraph);
        this.printTraversalForm(traversal);
        subgraph = (Graph)traversal.next();
        SubgraphTest.assertVertexEdgeCounts(3, 2).accept(subgraph);
        subgraph.edges(new Object[0]).forEachRemaining(e -> {
            Assert.assertEquals((Object)"knows", (Object)e.label());
            Assert.assertEquals((Object)"marko", e.outVertex().values(new String[]{"name"}).next());
            Assert.assertEquals((Object)new Integer(29), e.outVertex().values(new String[]{"age"}).next());
            Assert.assertEquals((Object)"person", (Object)e.outVertex().label());
            String name = (String)e.inVertex().values(new String[]{"name"}).next();
            if (name.equals("vadas")) {
                Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-4);
            } else if (name.equals("josh")) {
                Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
            } else {
                Assert.fail((String)"There's a vertex present that should not be in the subgraph");
            }
        });
        this.graphProvider.clear(subgraph, config);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void g_V_withSideEffectXsgX_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup() throws Exception {
        Configuration config = this.graphProvider.newGraphConfiguration("subgraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
        this.graphProvider.clear(config);
        Graph subgraph = this.graphProvider.openTestGraph(config);
        Traversal<Vertex, String> traversal = this.get_g_V_withSideEffectXsgX_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup(subgraph);
        this.printTraversalForm(traversal);
        SubgraphTest.checkResults(Arrays.asList("marko", "josh", "peter"), traversal);
        Graph subGraph = (Graph)traversal.asAdmin().getSideEffects().get("sg").get();
        SubgraphTest.assertVertexEdgeCounts(5, 4).accept(subGraph);
        this.graphProvider.clear(subgraph, config);
    }

    public static class Traversals
    extends SubgraphTest {
        @Override
        public Traversal<Vertex, Graph> get_g_V_withSideEffectXsgX_outEXknowsX_subgraphXsgX_name_capXsgX(Object v1Id, Graph subgraph) {
            return this.g.withSideEffect("sg", () -> subgraph).V(new Object[]{v1Id}).outE(new String[]{"knows"}).subgraph("sg").values(new String[]{"name"}).cap("sg", new String[0]);
        }

        @Override
        public Traversal<Vertex, String> get_g_V_withSideEffectXsgX_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup(Graph subgraph) {
            return this.g.withSideEffect("sg", () -> subgraph).V(new Object[0]).repeat((Traversal)__.bothE((String[])new String[]{"created"}).subgraph("sg").outV()).times(5).values(new String[]{"name"}).dedup();
        }
    }
}

