/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.Bindings;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.CrossJoinEnumerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.Enumerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.InnerJoinEnumerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.IteratorEnumerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.match.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_O_S_SE_SL_Traverser;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class MatchTest
extends AbstractGremlinProcessTest {
    private static final Function<Vertex, String> vertexToStr = v -> v.id().toString();
    private static final Function<Object, String> simpleToStringFunction = Object::toString;

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_out_bX();

    public abstract Traversal<Vertex, Object> get_g_V_matchXa_out_bX_selectXb_idX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_knows_b__b_created_cX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_knows_b__a_created_cX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXab_nameX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_lop_b__b_0created_29_c__c_repeatXoutX_timesX2XX_selectXnameX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXnameX();

    public abstract Traversal<Vertex, String> get_g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_matchXa_created_b__b_0created_aX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_matchXa_knows_b__c_knows_bX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_knows_b__b_created_lop__b_matchXa1_created_b1__b1_0created_c1X_selectXc1X_cX_selectXnameX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_c_nameX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_out_bX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXa_out_bX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "vadas")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "josh")).put("b", (Object)this.convertToVertex(this.graph, "ripple")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "josh")).put("b", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "peter")).put("b", (Object)this.convertToVertex(this.graph, "lop")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_out_bX_selectXb_idX() throws Exception {
        Traversal<Vertex, Object> traversal = this.get_g_V_matchXa_out_bX_selectXb_idX();
        this.printTraversalForm(traversal);
        int counter = 0;
        Object vadasId = this.convertToVertexId("vadas");
        Object joshId = this.convertToVertexId("josh");
        Object lopId = this.convertToVertexId("lop");
        Object rippleId = this.convertToVertexId("ripple");
        HashMap idCounts = new HashMap();
        while (traversal.hasNext()) {
            ++counter;
            MapHelper.incr(idCounts, (Object)traversal.next(), (Long)1L);
        }
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals(idCounts.get(vadasId), (Object)1L);
        Assert.assertEquals(idCounts.get(lopId), (Object)3L);
        Assert.assertEquals(idCounts.get(joshId), (Object)1L);
        Assert.assertEquals(idCounts.get(rippleId), (Object)1L);
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_knows_b__b_created_cX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXa_knows_b__b_created_cX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "ripple")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_knows_b__a_created_cX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXa_knows_b__a_created_cX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "vadas")).put("c", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "lop")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("d", (Object)this.convertToVertex(this.graph, "vadas")).put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("d", (Object)this.convertToVertex(this.graph, "vadas")).put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "ripple")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXab_nameX() throws Exception {
        Traversal<Vertex, Map<String, String>> traversal = this.get_g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXab_nameX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        this.assertResults(Function.identity(), traversal, new Bindings().put("a", (Object)"marko").put("b", (Object)"lop"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXnameX() throws Exception {
        List<Traversal> traversals = Arrays.asList(this.get_g_V_matchXa_created_lop_b__b_0created_29_c__c_repeatXoutX_timesX2XX_selectXnameX(), this.get_g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXnameX());
        traversals.forEach(traversal -> {
            this.printTraversalForm((Traversal)traversal);
            this.assertResults(Function.identity(), (Traversal)traversal, (Bindings)new Bindings().put("a", (Object)"marko").put("b", (Object)"lop").put("c", (Object)"marko"), (Bindings)new Bindings().put("a", (Object)"josh").put("b", (Object)"lop").put("c", (Object)"marko"), (Bindings)new Bindings().put("a", (Object)"peter").put("b", (Object)"lop").put("c", (Object)"marko"));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name() throws Exception {
        Traversal<Vertex, String> traversal = this.get_g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"lop", (Object)traversal.next());
        Assert.assertEquals((Object)"lop", (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test(expected=IllegalArgumentException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_b__b_0created_aX() {
        this.get_g_V_matchXa_created_b__b_0created_aX();
    }

    @Test(expected=IllegalArgumentException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_knows_b__c_knows_bX() {
        this.get_g_V_matchXa_knows_b__c_knows_bX();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_knows_b__b_created_lop__b_matchXa1_created_b1__b1_0created_c1X_selectXc1X_cX_selectXnameX() throws Exception {
        Traversal<Vertex, Map<String, String>> traversal = this.get_g_V_matchXa_knows_b__b_created_lop__b_matchXa1_created_b1__b1_0created_c1X_selectXc1X_cX_selectXnameX();
        this.printTraversalForm(traversal);
        this.assertResults(Function.identity(), traversal, new Bindings().put("a", (Object)"marko").put("b", (Object)"josh").put("c", (Object)"josh"), new Bindings().put("a", (Object)"marko").put("b", (Object)"josh").put("c", (Object)"josh"), new Bindings().put("a", (Object)"marko").put("b", (Object)"josh").put("c", (Object)"marko"), new Bindings().put("a", (Object)"marko").put("b", (Object)"josh").put("c", (Object)"peter"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CREAM PUFF WAR")), new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CRYPTICAL ENVELOPMENT")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX() throws Exception {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX();
        this.printTraversalForm(traversal);
        this.assertResults(vertexToStr, traversal, new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "I WANT TO TELL YOU")).put("c", (Object)this.convertToVertex(this.graph, "STIR IT UP")).put("d", (Object)this.convertToVertex(this.graph, "George_Harrison")).put("e", (Object)this.convertToVertex(this.graph, "Bob_Marley")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_c_nameX() throws Exception {
        Traversal<Vertex, Map<String, String>> traversal = this.get_g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_c_nameX();
        this.assertResults(Function.identity(), traversal, new Bindings().put("a", (Object)"marko").put("c", (Object)"josh"), new Bindings().put("a", (Object)"marko").put("c", (Object)"peter"), new Bindings().put("a", (Object)"josh").put("c", (Object)"marko"), new Bindings().put("a", (Object)"josh").put("c", (Object)"peter"), new Bindings().put("a", (Object)"peter").put("c", (Object)"marko"), new Bindings().put("a", (Object)"peter").put("c", (Object)"josh"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX() throws Exception {
        List<Traversal> traversals = Arrays.asList(this.get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX(), this.get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX());
        traversals.forEach(traversal -> {
            this.printTraversalForm((Traversal)traversal);
            this.assertResults((Function)vertexToStr, (Traversal)traversal, (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CREAM PUFF WAR")).put("c", (Object)this.convertToVertex(this.graph, "CREAM PUFF WAR")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")), (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CREAM PUFF WAR")).put("c", (Object)this.convertToVertex(this.graph, "CRYPTICAL ENVELOPMENT")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")), (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CRYPTICAL ENVELOPMENT")).put("c", (Object)this.convertToVertex(this.graph, "CREAM PUFF WAR")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")), (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Garcia")).put("b", (Object)this.convertToVertex(this.graph, "CRYPTICAL ENVELOPMENT")).put("c", (Object)this.convertToVertex(this.graph, "CRYPTICAL ENVELOPMENT")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")), (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Grateful_Dead")).put("b", (Object)this.convertToVertex(this.graph, "CANT COME DOWN")).put("c", (Object)this.convertToVertex(this.graph, "DOWN SO LONG")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")), (Bindings)new Bindings().put("a", (Object)this.convertToVertex(this.graph, "Grateful_Dead")).put("b", (Object)this.convertToVertex(this.graph, "THE ONLY TIME IS NOW")).put("c", (Object)this.convertToVertex(this.graph, "DOWN SO LONG")).put("d", (Object)this.convertToVertex(this.graph, "Garcia")));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void testOptimization() throws Exception {
        MatchStep query = new MatchStep((Traversal.Admin)this.g.V(new Object[0]).asAdmin(), "d", new Traversal[]{__.as((String)"d", (String[])new String[0]).in(new String[]{"knows"}).as("a", new String[0]), __.as((String)"d", (String[])new String[0]).has("name", (Object)"vadas"), __.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"created"}).as("c", new String[0])});
        GraphTraversal iter = this.g.V(new Object[0]);
        query.optimize();
        Assert.assertEquals((double)0.0, (double)query.findCost("c"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)query.findCost("b"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)query.findCost("a"), (double)0.0);
        Assert.assertEquals((double)4.0, (double)query.findCost("d"), (double)0.0);
        this.assertResults(query.solveFor((Iterator)iter), new Bindings().put("d", (Object)this.convertToVertex(this.graph, "vadas")).put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "lop")), new Bindings().put("d", (Object)this.convertToVertex(this.graph, "vadas")).put("a", (Object)this.convertToVertex(this.graph, "marko")).put("b", (Object)this.convertToVertex(this.graph, "josh")).put("c", (Object)this.convertToVertex(this.graph, "ripple")));
        query.optimize();
        Assert.assertEquals((double)0.0, (double)query.findCost("c"), (double)0.0);
    }

    @Test
    public void testIteratorEnumerator() throws Exception {
        HashMap map = new HashMap();
        BiConsumer<String, String> visitor = map::put;
        IteratorEnumerator ie = new IteratorEnumerator("a", new LinkedList<String>(){
            {
                this.add("foo");
                this.add("bar");
            }
        }.iterator());
        Assert.assertEquals((long)0L, (long)ie.size());
        Assert.assertTrue((boolean)ie.visitSolution(0, visitor));
        Assert.assertEquals((long)1L, (long)ie.size());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"foo", map.get("a"));
        map.clear();
        Assert.assertTrue((boolean)ie.visitSolution(1, visitor));
        Assert.assertEquals((long)2L, (long)ie.size());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"bar", map.get("a"));
        map.clear();
        Assert.assertFalse((boolean)ie.visitSolution(2, visitor));
        Assert.assertEquals((long)2L, (long)ie.size());
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)ie.visitSolution(1, visitor));
        Assert.assertEquals((long)2L, (long)ie.size());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"bar", map.get("a"));
        ie = new IteratorEnumerator("a", new LinkedList<String>(){}.iterator());
        map.clear();
        Assert.assertEquals((long)0L, (long)ie.size());
        Assert.assertFalse((boolean)ie.visitSolution(0, visitor));
        Assert.assertEquals((long)0L, (long)ie.size());
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testCrossJoin() throws Exception {
        String[] a1 = new String[]{"a", "b", "c"};
        String[] a2 = new String[]{"1", "2", "3", "4"};
        String[] a3 = new String[]{"@", "#"};
        IteratorEnumerator e1 = new IteratorEnumerator("letter", Arrays.asList(a1).iterator());
        IteratorEnumerator e2 = new IteratorEnumerator("number", Arrays.asList(a2).iterator());
        IteratorEnumerator e3 = new IteratorEnumerator("punc", Arrays.asList(a3).iterator());
        CrossJoinEnumerator e1e2 = new CrossJoinEnumerator((Enumerator)e1, (Enumerator)e2);
        CrossJoinEnumerator e2e1 = new CrossJoinEnumerator((Enumerator)e2, (Enumerator)e1);
        BiConsumer<String, String> visitor = (name, value) -> System.out.println("\t" + name + ":\t" + value);
        CrossJoinEnumerator e1e2e3 = new CrossJoinEnumerator((Enumerator)e1e2, (Enumerator)e3);
        CrossJoinEnumerator result = e1e2;
        Assert.assertEquals((long)12L, (long)this.exhaust((Enumerator)result));
        Assert.assertEquals((long)12L, (long)result.size());
        result = e2e1;
        Assert.assertEquals((long)12L, (long)this.exhaust((Enumerator)result));
        Assert.assertEquals((long)12L, (long)result.size());
        result = e1e2e3;
        Assert.assertEquals((long)24L, (long)this.exhaust((Enumerator)result));
        Assert.assertEquals((long)24L, (long)result.size());
    }

    @Test
    public void testInnerJoin() throws Exception {
        String[] a1 = new String[]{"a", "b", "c"};
        String[] a2 = new String[]{"1", "2", "3", "4"};
        String[] a3 = new String[]{"2", "4", "6", "8", "10"};
        IteratorEnumerator e1 = new IteratorEnumerator("letter", Arrays.asList(a1).iterator());
        IteratorEnumerator e2 = new IteratorEnumerator("number", Arrays.asList(a2).iterator());
        IteratorEnumerator e3 = new IteratorEnumerator("number", Arrays.asList(a3).iterator());
        CrossJoinEnumerator e4 = new CrossJoinEnumerator((Enumerator)e1, (Enumerator)e3);
        CrossJoinEnumerator e5 = new CrossJoinEnumerator((Enumerator)e2, (Enumerator)e4);
        this.exhaust((Enumerator)e5);
        Assert.assertEquals((long)60L, (long)e5.size());
        InnerJoinEnumerator join = new InnerJoinEnumerator((Enumerator)e5, (Set)new HashSet<String>(){
            {
                this.add("number");
            }
        });
        this.exhaust((Enumerator)join);
        Assert.assertEquals((long)6L, (long)join.size());
        this.assertResults((Enumerator)join, (Bindings<T>[])new Bindings[]{new Bindings().put("letter", (Object)"a").put("number", (Object)"2"), new Bindings().put("letter", (Object)"a").put("number", (Object)"4"), new Bindings().put("letter", (Object)"b").put("number", (Object)"2"), new Bindings().put("letter", (Object)"b").put("number", (Object)"4"), new Bindings().put("letter", (Object)"c").put("number", (Object)"2"), new Bindings().put("letter", (Object)"c").put("number", (Object)"4")});
    }

    private <S, E> void assertResults(Function<E, String> toStringFunction, Traversal<S, Map<String, E>> actual, Bindings<E> ... expected) {
        Bindings.BindingsComparator comp = new Bindings.BindingsComparator(toStringFunction);
        List<Bindings<E>> actualList = this.toBindings(actual);
        LinkedList expectedList = new LinkedList();
        Collections.addAll(expectedList, expected);
        if (expectedList.size() > actualList.size()) {
            Assert.fail((String)("" + (expectedList.size() - actualList.size()) + " expected results not found, including " + expectedList.get(actualList.size())));
        } else if (actualList.size() > expectedList.size()) {
            Assert.fail((String)("" + (actualList.size() - expectedList.size()) + " unexpected results, including " + actualList.get(expectedList.size())));
        }
        Collections.sort(actualList, comp);
        Collections.sort(expectedList, comp);
        for (int j = 0; j < actualList.size(); ++j) {
            Bindings e;
            Bindings<E> a = actualList.get(j);
            if (0 == comp.compare(a, e = (Bindings)expectedList.get(j))) continue;
            Assert.fail((String)("unexpected result(s), including " + a));
        }
        Assert.assertFalse((boolean)actual.hasNext());
    }

    private <T> void assertResults(Enumerator<T> actual, Bindings<T> ... expected) {
        Bindings.BindingsComparator comp = new Bindings.BindingsComparator(simpleToStringFunction);
        List<Bindings<T>> actualList = this.toBindings(actual);
        LinkedList expectedList = new LinkedList();
        Collections.addAll(expectedList, expected);
        Collections.sort(actualList, comp);
        Collections.sort(expectedList, comp);
        for (int j = 0; j < actualList.size(); ++j) {
            Bindings e;
            Bindings<T> a;
            if (j == expectedList.size()) {
                Assert.fail((String)("" + (actualList.size() - expectedList.size()) + " unexpected results, including " + actualList.get(expectedList.size())));
            }
            if (0 == comp.compare(a = actualList.get(j), e = (Bindings)expectedList.get(j))) continue;
            Assert.fail((String)("unexpected result(s), including " + a));
        }
        if (expectedList.size() > actualList.size()) {
            Assert.fail((String)("" + (expectedList.size() - actualList.size()) + " expected results not found, including " + expectedList.get(actualList.size())));
        }
    }

    private <S, E> List<Bindings<E>> toBindings(Traversal<S, Map<String, E>> traversal) {
        LinkedList result = new LinkedList();
        traversal.forEachRemaining(o -> result.add(new Bindings(o)));
        return result;
    }

    private <T> List<Bindings<T>> toBindings(Enumerator<T> enumerator) {
        LinkedList bindingsList = new LinkedList();
        int i = 0;
        bindingsList.add(new Bindings());
        while (enumerator.visitSolution(i++, (name, value) -> ((Bindings)bindingsList.get(bindingsList.size() - 1)).put(name, value))) {
            bindingsList.add(new Bindings());
        }
        bindingsList.remove(bindingsList.size() - 1);
        return bindingsList;
    }

    private void assertBranchFactor(double branchFactor, Traversal t, Iterator inputs) {
        B_O_S_SE_SL_Traverser start = new B_O_S_SE_SL_Traverser(null, null, 1L);
        MatchStep.TraversalWrapper w = new MatchStep.TraversalWrapper(t, "a", "b");
        MatchStep.TraversalUpdater updater = new MatchStep.TraversalUpdater(w, inputs, (Traverser)start, "x");
        while (updater.hasNext()) {
            updater.next();
        }
        Assert.assertEquals((double)branchFactor, (double)w.findBranchFactor(), (double)0.0);
    }

    private <T> int exhaust(Enumerator<T> enumerator) {
        BiConsumer<String, Object> visitor = (s, t) -> {};
        int i = 0;
        while (enumerator.visitSolution(i, visitor)) {
            ++i;
        }
        return i;
    }

    private void findMissing(String s, int i, int n, byte[] names, Set<String> actual) {
        s = 0 == i ? "{" : s + ", ";
        s = s + (char)names[i];
        String tmp = s = s + "=";
        for (int j = 0; j < 3; ++j) {
            s = s + j;
            if (n - 1 == i) {
                if (!actual.contains(s = s + "}")) {
                    Assert.fail((String)("not in set: " + s));
                }
            } else {
                this.findMissing(s, i + 1, n, names, actual);
            }
            s = tmp;
        }
    }

    public static class Traversals
    extends MatchTest {
        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_out_bX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[0]).as("b", new String[0])});
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_matchXa_out_bX_selectXb_idX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[0]).as("b", new String[0])}).select("b").by(T.id);
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_knows_b__b_created_cX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"created"}).as("c", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_knows_b__a_created_cX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("c", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX() {
            return this.g.V(new Object[0]).match("d", new Traversal[]{__.as((String)"d", (String[])new String[0]).in(new String[]{"knows"}).as("a", new String[0]), __.as((String)"d", (String[])new String[0]).has("name", (Object)"vadas"), __.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"created"}).as("c", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXab_nameX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).repeat((Traversal)__.out((String[])new String[0])).times(2).as("b", new String[0])}).select(new String[]{"a", "b"}).by("name");
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_lop_b__b_0created_29_c__c_repeatXoutX_timesX2XX_selectXnameX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).has("name", (Object)"lop").as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[]{"created"}).has("age", (Object)29).as("c", new String[0]), __.as((String)"c", (String[])new String[0]).repeat((Traversal)__.out((String[])new String[0])).times(2)}).select(new String[0]).by("name");
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXnameX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).has("name", (Object)"lop").as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[]{"created"}).has("age", (Object)29).as("c", new String[0])}).where((Traversal)__.as((String)"c", (String[])new String[0]).repeat((Traversal)__.out((String[])new String[0])).times(2)).select(new String[0]).by("name");
        }

        @Override
        public Traversal<Vertex, String> get_g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).in(new String[]{"created"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[]{"knows"}).as("c", new String[0])}).select("c").out(new String[]{"created"}).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_matchXa_created_b__b_0created_aX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[]{"created"}).as("a", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_matchXa_knows_b__c_knows_bX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"c", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_knows_b__b_created_lop__b_matchXa1_created_b1__b1_0created_c1X_selectXc1X_cX_selectXnameX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"knows"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"created"}).has("name", (Object)"lop"), __.as((String)"b", (String[])new String[0]).match("a1", new Traversal[]{__.as((String)"a1", (String[])new String[0]).out(new String[]{"created"}).as("b1", new String[0]), __.as((String)"b1", (String[])new String[0]).in(new String[]{"created"}).as("c1", new String[0])}).select("c1").as("c", new String[0])}).select(new String[0]).by("name");
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).has("name", (Object)"Garcia"), __.as((String)"a", (String[])new String[0]).in(new String[]{"writtenBy"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).in(new String[]{"sungBy"}).as("b", new String[0])});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).in(new String[]{"sungBy"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).in(new String[]{"sungBy"}).as("c", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"writtenBy"}).as("d", new String[0]), __.as((String)"c", (String[])new String[0]).out(new String[]{"writtenBy"}).as("e", new String[0]), __.as((String)"d", (String[])new String[0]).has("name", (Object)"George_Harrison"), __.as((String)"e", (String[])new String[0]).has("name", (Object)"Bob_Marley")});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).in(new String[]{"sungBy"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).in(new String[]{"writtenBy"}).as("c", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"writtenBy"}).as("d", new String[0]), __.as((String)"c", (String[])new String[0]).out(new String[]{"sungBy"}).as("d", new String[0]), __.as((String)"d", (String[])new String[0]).has("name", (Object)"Garcia")});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).in(new String[]{"sungBy"}).as("b", new String[0]), __.as((String)"a", (String[])new String[0]).in(new String[]{"writtenBy"}).as("c", new String[0]), __.as((String)"b", (String[])new String[0]).out(new String[]{"writtenBy"}).as("d", new String[0])}).where((Traversal)__.as((String)"c", (String[])new String[0]).out(new String[]{"sungBy"}).as("d", new String[0])).where((Traversal)__.as((String)"d", (String[])new String[0]).has("name", (Object)"Garcia"));
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_c_nameX() {
            return this.g.V(new Object[0]).match("a", new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[]{"created"}).as("c", new String[0])}).where("a", P.neq((Object)"c")).select(new String[]{"a", "c"}).by("name");
        }
    }
}

