/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Traversal.Exceptions.class, methods={"traversalIsLocked"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"idArgsMustBeEitherIdOrElement"})})
public class CoreTraversalTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadVerticesViaIds() {
        List vertices = this.g.V(new Object[0]).toList();
        List ids = vertices.stream().map(v -> v.id()).collect(Collectors.toList());
        List verticesReloaded = this.g.V(ids.toArray()).toList();
        Assert.assertEquals((long)vertices.size(), (long)verticesReloaded.size());
        Assert.assertEquals(new HashSet(vertices), new HashSet(verticesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadEdgesViaIds() {
        List edges = this.g.E(new Object[0]).toList();
        List ids = edges.stream().map(e -> e.id()).collect(Collectors.toList());
        List edgesReloaded = this.g.E(ids.toArray()).toList();
        Assert.assertEquals((long)edges.size(), (long)edgesReloaded.size());
        Assert.assertEquals(new HashSet(edges), new HashSet(edgesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadVerticesViaVertices() {
        List vertices = this.g.V(new Object[0]).toList();
        List verticesReloaded = this.g.V(vertices.toArray()).toList();
        Assert.assertEquals((long)vertices.size(), (long)verticesReloaded.size());
        Assert.assertEquals(new HashSet(vertices), new HashSet(verticesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadEdgesViaEdges() {
        List edges = this.g.E(new Object[0]).toList();
        List edgesReloaded = this.g.E(edges.toArray()).toList();
        Assert.assertEquals((long)edges.size(), (long)edgesReloaded.size());
        Assert.assertEquals(new HashSet(edges), new HashSet(edgesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowExceptionWhenIdsMixed() {
        List vertices = this.g.V(new Object[0]).toList();
        try {
            this.g.V(new Object[]{vertices.get(0), ((Vertex)vertices.get(1)).id()}).toList();
        }
        catch (Exception ex) {
            CoreTraversalTest.validateException(Graph.Exceptions.idArgsMustBeEitherIdOrElement(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveNextAndToCollectionWorkProperly() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)(traversal.next() instanceof Vertex));
        Assert.assertEquals((long)4L, (long)traversal.next(4).size());
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        GraphTraversal intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        List list = intTraversal.toList();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)list.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(4)).intValue());
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        Set set = intTraversal.toSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(7));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertTrue((boolean)set.contains(6));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        BulkSet bulkSet = intTraversal.toBulkSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)bulkSet.uniqueSize());
        Assert.assertEquals((long)5L, (long)bulkSet.longSize());
        Assert.assertEquals((long)5L, (long)bulkSet.size());
        Assert.assertTrue((boolean)bulkSet.contains((Object)7));
        Assert.assertTrue((boolean)bulkSet.contains((Object)2));
        Assert.assertTrue((boolean)bulkSet.contains((Object)3));
        Assert.assertTrue((boolean)bulkSet.contains((Object)6));
        Assert.assertEquals((long)2L, (long)bulkSet.get((Object)7));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHavePropertyForEachRemainingBehaviorEvenWithStrategyRewrite() {
        GraphTraversal traversal = this.g.V(new Object[0]).out(new String[0]).groupCount();
        traversal.forEachRemaining(Map.class, map -> Assert.assertTrue((boolean)(map instanceof Map)));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAlterTraversalAfterTraversalBecomesLocked() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)traversal.hasNext());
        try {
            traversal.count().next();
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked()));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)Traversal.Exceptions.traversalIsLocked().getMessage(), (Object)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked() + " not " + e + ":" + e.getMessage()));
        }
        traversal.iterate();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAddStartsProperly() {
        GraphTraversal traversal = __.out((String[])new String[0]).out(new String[0]);
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)traversal));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldTraversalResetProperly() {
        GraphTraversal traversal = __.as((String)"a", (String[])new String[0]).out(new String[0]).out(new String[0]).has("name", P.within((Object[])new String[]{"ripple", "lop"})).as("b", new String[0]);
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.next();
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.asAdmin().reset();
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        Assert.assertFalse((boolean)traversal.hasNext());
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfAutoTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.AUTO);
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfManualTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
        this.g.tx().rollback();
    }
}

