/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.ranking;

import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.junit.Assert;
import org.junit.Test;

public class PageRankVertexProgramTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldExecutePageRank() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(((GraphComputer)this.g.getGraphComputer().get()).getClass()).program(PageRankVertexProgram.build().create(this.graph)).submit().get();
        result.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)v.keys().contains("name"));
            Assert.assertTrue((boolean)v.keys().contains("gremlin.pageRankVertexProgram.pageRank"));
            String name = (String)v.value("name");
            Double pageRank = (Double)v.value("gremlin.pageRankVertexProgram.pageRank");
            if (name.equals("marko")) {
                Assert.assertTrue((pageRank > 0.14 && pageRank < 0.16 ? 1 : 0) != 0);
            } else if (name.equals("vadas")) {
                Assert.assertTrue((pageRank > 0.19 && pageRank < 0.2 ? 1 : 0) != 0);
            } else if (name.equals("lop")) {
                Assert.assertTrue((pageRank > 0.4 && pageRank < 0.41 ? 1 : 0) != 0);
            } else if (name.equals("josh")) {
                Assert.assertTrue((pageRank > 0.19 && pageRank < 0.2 ? 1 : 0) != 0);
            } else if (name.equals("ripple")) {
                Assert.assertTrue((pageRank > 0.23 && pageRank < 0.24 ? 1 : 0) != 0);
            } else if (name.equals("peter")) {
                Assert.assertTrue((pageRank > 0.14 && pageRank < 0.16 ? 1 : 0) != 0);
            } else {
                throw new IllegalStateException("The following vertex should not exist in the graph: " + name);
            }
        });
        Assert.assertEquals((long)result.memory().getIteration(), (long)30L);
        Assert.assertEquals((long)result.memory().asMap().size(), (long)0L);
    }
}

