/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.T;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class VertexTest {

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"elementAlreadyRemoved"})
    public static class ExceptionConsistencyWhenVertexRemovedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public Consumer<Vertex> functionToTest;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"property(k)", FunctionUtils.wrapConsumer(v -> v.property("name"))}, {"remove()", FunctionUtils.wrapConsumer(Element::remove)}, {"addEdge()", FunctionUtils.wrapConsumer(v -> v.addEdge("self", v, new Object[0]))}, {"property(k,v)", FunctionUtils.wrapConsumer(v -> v.property("k", (Object)"v"))}, {"property(single,k,v)", FunctionUtils.wrapConsumer(v -> v.property(VertexProperty.Cardinality.single, "k", (Object)"v", new Object[0]))}, {"value(k)", FunctionUtils.wrapConsumer(v -> v.value("name"))});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldThrowExceptionIfVertexWasRemovedWhenCallingProperty() {
            Vertex v1 = this.graph.addVertex(new Object[]{"name", "stephen"});
            Object id = v1.id();
            v1.remove();
            this.tryCommit(this.graph, g -> {
                try {
                    this.functionToTest.accept(v1);
                    Assert.fail((String)"Should have thrown exception as the Vertex was already removed");
                }
                catch (Exception ex) {
                    ExceptionConsistencyWhenVertexRemovedTest.validateException(Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)id), ex);
                }
            });
        }
    }

    @ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Edge.Exceptions.class, methods={"userSuppliedIdsNotSupported"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"edgeWithIdAlreadyExists"}), @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"labelCanNotBeNull", "labelCanNotBeEmpty", "labelCanNotBeAHiddenKey"})})
    public static class BasicVertexTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingNullVertexLabel() {
            try {
                this.graph.addVertex(new Object[]{T.label, null});
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is null");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeNull(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingNullVertexLabelOnOverload() {
            try {
                this.graph.addVertex((String)null);
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is null");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeNull(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingEmptyVertexLabel() {
            try {
                this.graph.addVertex(new Object[]{T.label, ""});
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is empty");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeEmpty(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingEmptyVertexLabelOnOverload() {
            try {
                this.graph.addVertex("");
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is empty");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeEmpty(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingSystemVertexLabel() {
            String label = Graph.Hidden.hide((String)"systemLabel");
            try {
                this.graph.addVertex(new Object[]{T.label, label});
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is a system key");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeAHiddenKey((String)label), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveExceptionConsistencyWhenUsingSystemVertexLabelOnOverload() {
            String label = Graph.Hidden.hide((String)"systemLabel");
            try {
                this.graph.addVertex(label);
                Assert.fail((String)"Call to Graph.addVertex() should throw an exception when label is a system key");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Element.Exceptions.labelCanNotBeAHiddenKey((String)label), ex);
            }
        }

        @Test(expected=NoSuchElementException.class)
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldThrowNoSuchElementExceptionIfVertexWithIdNotPresentViaTraversal() {
            this.graph.vertices(new Object[]{"this-id-should-not-be-in-the-modern-graph"}).next();
        }

        @Test(expected=NoSuchElementException.class)
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldThrowNoSuchElementExceptionIfVertexWithIdNotPresentViaIterators() {
            this.graph.vertices(new Object[]{"this-id-should-not-be-in-the-modern-graph"}).next();
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds")})
        public void shouldHaveExceptionConsistencyWhenAssigningSameIdOnEdge() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Object o = GraphManager.getGraphProvider().convertId("1");
            v.addEdge("label", v, new Object[]{T.id, o});
            try {
                v.addEdge("label", v, new Object[]{T.id, o});
                Assert.fail((String)"Assigning the same ID to an Element should throw an exception");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Graph.Exceptions.edgeWithIdAlreadyExists((Object)o), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false)})
        public void shouldHaveExceptionConsistencyWhenIdNotSupportedForAddEdge() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("label", v, new Object[]{T.id, ""});
                Assert.fail((String)"Call to addEdge should have thrown an exception when ID was specified as it is not supported");
            }
            catch (Exception ex) {
                BasicVertexTest.validateException(Edge.Exceptions.userSuppliedIdsNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
        public void shouldHaveStandardStringRepresentation() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "age", 34});
            Assert.assertEquals((Object)StringFactory.vertexString((Vertex)v), (Object)v.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldUseDefaultLabelIfNotSpecified() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko"});
            Assert.assertEquals((Object)"vertex", (Object)v.label());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldAddVertexWithLabel() {
            Vertex v = this.graph.addVertex("person");
            this.tryCommit(this.graph, graph -> Assert.assertEquals((Object)"person", (Object)v.label()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldSupportBasicVertexManipulation() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "age", 34});
            Assert.assertEquals((long)34L, (long)((Integer)v.value("age")).intValue());
            Assert.assertEquals((Object)"marko", (Object)v.value("name"));
            Assert.assertEquals((long)34L, (long)((Integer)v.property("age").value()).intValue());
            Assert.assertEquals((Object)"marko", (Object)v.property("name").value());
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            Assert.assertEquals((long)2L, (long)v.keys().size());
            Assert.assertTrue((boolean)v.keys().contains("name"));
            Assert.assertTrue((boolean)v.keys().contains("age"));
            Assert.assertFalse((boolean)v.keys().contains("location"));
            BasicVertexTest.assertVertexEdgeCounts(1, 0).accept(this.graph);
            v.properties(new String[]{"name"}).forEachRemaining(Property::remove);
            v.property("name", (Object)"marko rodriguez");
            Assert.assertEquals((long)34L, (long)((Integer)v.value("age")).intValue());
            Assert.assertEquals((Object)"marko rodriguez", (Object)v.value("name"));
            Assert.assertEquals((long)34L, (long)((Integer)v.property("age").value()).intValue());
            Assert.assertEquals((Object)"marko rodriguez", (Object)v.property("name").value());
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            Assert.assertEquals((long)2L, (long)v.keys().size());
            Assert.assertTrue((boolean)v.keys().contains("name"));
            Assert.assertTrue((boolean)v.keys().contains("age"));
            Assert.assertFalse((boolean)v.keys().contains("location"));
            BasicVertexTest.assertVertexEdgeCounts(1, 0).accept(this.graph);
            v.property("location", (Object)"santa fe");
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            Assert.assertEquals((long)3L, (long)v.keys().size());
            Assert.assertEquals((Object)"santa fe", (Object)v.property("location").value());
            Assert.assertEquals((Object)v.property("location"), (Object)v.property("location"));
            Assert.assertNotEquals((Object)v.property("location"), (Object)v.property("name"));
            Assert.assertTrue((boolean)v.keys().contains("name"));
            Assert.assertTrue((boolean)v.keys().contains("age"));
            Assert.assertTrue((boolean)v.keys().contains("location"));
            v.property("location").remove();
            BasicVertexTest.assertVertexEdgeCounts(1, 0).accept(this.graph);
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            v.properties(new String[0]).forEachRemaining(Property::remove);
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            BasicVertexTest.assertVertexEdgeCounts(1, 0).accept(this.graph);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
        public void shouldEvaluateVerticesEquivalentWithSuppliedIdsViaTraversal() {
            Vertex v = this.graph.addVertex(new Object[]{T.id, GraphManager.getGraphProvider().convertId("1")});
            Vertex u = (Vertex)this.graph.vertices(new Object[]{GraphManager.getGraphProvider().convertId("1")}).next();
            Assert.assertEquals((Object)v, (Object)u);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
        public void shouldEvaluateVerticesEquivalentWithSuppliedIdsViaIterators() {
            Vertex v = this.graph.addVertex(new Object[]{T.id, GraphManager.getGraphProvider().convertId("1")});
            Vertex u = (Vertex)this.graph.vertices(new Object[]{GraphManager.getGraphProvider().convertId("1")}).next();
            Assert.assertEquals((Object)v, (Object)u);
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldEvaluateEquivalentVerticesWithNoSuppliedIds() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Assert.assertNotNull((Object)v);
            Vertex u = (Vertex)this.graph.vertices(new Object[]{v.id()}).next();
            Assert.assertNotNull((Object)u);
            Assert.assertEquals((Object)v, (Object)u);
            Assert.assertEquals(this.graph.vertices(new Object[]{u.id()}).next(), this.graph.vertices(new Object[]{u.id()}).next());
            Assert.assertEquals(this.graph.vertices(new Object[]{v.id()}).next(), this.graph.vertices(new Object[]{u.id()}).next());
            Assert.assertEquals(this.graph.vertices(new Object[]{v.id()}).next(), this.graph.vertices(new Object[]{v.id()}).next());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
        public void shouldEvaluateEquivalentVertexHashCodeWithSuppliedIds() {
            Vertex v = this.graph.addVertex(new Object[]{T.id, GraphManager.getGraphProvider().convertId("1")});
            Vertex u = (Vertex)this.graph.vertices(new Object[]{GraphManager.getGraphProvider().convertId("1")}).next();
            Assert.assertEquals((Object)v, (Object)u);
            HashSet<Object> set = new HashSet<Object>();
            set.add(v);
            set.add(v);
            set.add(u);
            set.add(u);
            set.add(this.graph.vertices(new Object[]{GraphManager.getGraphProvider().convertId("1")}).next());
            set.add(this.graph.vertices(new Object[]{GraphManager.getGraphProvider().convertId("1")}).next());
            Assert.assertEquals((long)1L, (long)set.size());
            Assert.assertEquals((long)v.hashCode(), (long)u.hashCode());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues")})
        public void shouldAutotypeStringProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("string", (Object)"marko");
            String name = (String)v.value("string");
            Assert.assertEquals((Object)name, (Object)"marko");
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldAutotypIntegerProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("integer", (Object)33);
            Integer age = (Integer)v.value("integer");
            Assert.assertEquals((Object)33, (Object)age);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues")})
        public void shouldAutotypeBooleanProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("boolean", (Object)true);
            Boolean best = (Boolean)v.value("boolean");
            Assert.assertEquals((Object)best, (Object)true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues")})
        public void shouldAutotypeDoubleProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("double", (Object)0.1);
            Double best = (Double)v.value("double");
            Assert.assertEquals((Object)best, (Object)0.1);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="LongValues")})
        public void shouldAutotypeLongProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("long", (Object)1L);
            Long best = (Long)v.value("long");
            Assert.assertEquals((Object)best, (Object)1L);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="FloatValues")})
        public void shouldAutotypeFloatProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            v.property("float", (Object)Float.valueOf(0.1f));
            Float best = (Float)v.value("float");
            Assert.assertEquals((Object)best, (Object)Float.valueOf(0.1f));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")
        public void shouldGetPropertyKeysOnVertex() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "location", "desert", "status", "dope"});
            Set keys = v.keys();
            Assert.assertEquals((long)3L, (long)keys.size());
            Assert.assertTrue((boolean)keys.contains("name"));
            Assert.assertTrue((boolean)keys.contains("location"));
            Assert.assertTrue((boolean)keys.contains("status"));
            List m = IteratorUtils.list((Iterator)v.properties(new String[0]));
            Assert.assertEquals((long)3L, (long)m.size());
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("name")));
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("location")));
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("status")));
            Assert.assertEquals((Object)"marko", m.stream().filter(p -> p.key().equals("name")).map(Property::value).findAny().orElse(null));
            Assert.assertEquals((Object)"desert", m.stream().filter(p -> p.key().equals("location")).map(Property::value).findAny().orElse(null));
            Assert.assertEquals((Object)"dope", m.stream().filter(p -> p.key().equals("status")).map(Property::value).findAny().orElse(null));
            v.property("status").remove();
            keys = v.keys();
            Assert.assertEquals((long)2L, (long)keys.size());
            Assert.assertTrue((boolean)keys.contains("name"));
            Assert.assertTrue((boolean)keys.contains("location"));
            v.properties(new String[0]).forEachRemaining(Property::remove);
            keys = v.keys();
            Assert.assertEquals((long)0L, (long)keys.size());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldNotGetConcurrentModificationException() {
            for (int i = 0; i < 25; ++i) {
                this.graph.addVertex(new Object[]{"myId", i});
            }
            this.graph.vertices(new Object[0]).forEachRemaining(v -> this.graph.vertices(new Object[0]).forEachRemaining(u -> v.addEdge("knows", u, new Object[]{"myEdgeId", 12})));
            this.tryCommit(this.graph, BasicVertexTest.assertVertexEdgeCounts(25, 625));
            ArrayList vertices = new ArrayList();
            IteratorUtils.fill((Iterator)this.graph.vertices(new Object[0]), vertices);
            for (Vertex v2 : vertices) {
                v2.remove();
                this.tryCommit(this.graph);
            }
            this.tryCommit(this.graph, BasicVertexTest.assertVertexEdgeCounts(0, 0));
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldReturnEmptyIteratorIfNoProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
        }
    }
}

