/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class SerializationTest {

    public static class GraphSONTest
    extends AbstractGremlinTest {
        private final TypeReference<HashMap<String, Object>> mapTypeReference = new TypeReference<HashMap<String, Object>>(){};

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertex() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            Vertex v = (Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next();
            String json = mapper.writeValueAsString((Object)v);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)"vertex", m.get("type"));
            Assert.assertEquals((Object)v.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)v.value("name").toString(), ((Map)((List)((Map)m.get("properties")).get("name")).get(0)).get("value"));
            Assert.assertEquals((Object)((Integer)v.value("age")), ((Map)((List)((Map)m.get("properties")).get("age")).get(0)).get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeEdge() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            String json = mapper.writeValueAsString((Object)e);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)"edge", m.get("type"));
            Assert.assertEquals((Object)e.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)((Double)e.value("weight")), ((Map)m.get("properties")).get("weight"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeProperty() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            String json = mapper.writeValueAsString((Object)p);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)p.value(), m.get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexProperty() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            VertexProperty vp = ((Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            String json = mapper.writeValueAsString((Object)vp);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)vp.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)vp.value(), m.get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
        public void shouldSerializeVertexPropertyWithProperties() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            VertexProperty vp = (VertexProperty)((Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next()).properties(new String[]{"location"}).next();
            String json = mapper.writeValueAsString((Object)vp);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)vp.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)vp.value(), m.get("value"));
            Assert.assertEquals(vp.values(new String[]{"startTime"}).next(), ((Map)m.get("properties")).get("startTime"));
            Assert.assertEquals(vp.values(new String[]{"endTime"}).next(), ((Map)m.get("properties")).get("endTime"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePath() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            Path p = (Path)this.g.V(new Object[]{this.convertToVertexId("marko")}).as("a").outE(new String[0]).as("b").inV().as("c").path().filter(t -> ((Vertex)((Path)t.get()).objects().get(2)).value("name").equals("lop")).next();
            String json = mapper.writeValueAsString((Object)p);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((long)2L, (long)m.size());
            List labels = (List)m.get("labels");
            Assert.assertEquals((long)3L, (long)labels.size());
            Assert.assertEquals((Object)"a", ((List)labels.get(0)).get(0));
            Assert.assertEquals((long)1L, (long)((List)labels.get(0)).size());
            Assert.assertEquals((Object)"b", ((List)labels.get(1)).get(0));
            Assert.assertEquals((long)1L, (long)((List)labels.get(1)).size());
            Assert.assertEquals((Object)"c", ((List)labels.get(2)).get(0));
            Assert.assertEquals((long)1L, (long)((List)labels.get(2)).size());
            List objects = (List)m.get("objects");
            Assert.assertEquals((long)3L, (long)objects.size());
            Assert.assertEquals((Object)"marko", ((Map)((List)((Map)((Map)objects.get(0)).get("properties")).get("name")).get(0)).get("value"));
            Assert.assertEquals((Object)"created", ((Map)objects.get(1)).get("label"));
            Assert.assertEquals((Object)"lop", ((Map)((List)((Map)((Map)objects.get(2)).get("properties")).get("name")).get(0)).get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeTraversalMetrics() throws Exception {
            ObjectMapper mapper = this.graph.io().graphSONMapper().create().createMapper();
            TraversalMetrics tm = (TraversalMetrics)this.g.V(new Object[0]).both(new String[0]).profile().cap(new String[]{TraversalMetrics.METRICS_KEY}).next();
            String json = mapper.writeValueAsString((Object)tm);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertTrue((boolean)m.containsKey("dur"));
            Assert.assertTrue((boolean)m.containsKey("metrics"));
            List metrics = (List)m.get("metrics");
            Assert.assertEquals((long)3L, (long)metrics.size());
            Map metrics0 = (Map)metrics.get(0);
            Assert.assertTrue((boolean)metrics0.containsKey("id"));
            Assert.assertTrue((boolean)metrics0.containsKey("name"));
            Assert.assertTrue((boolean)metrics0.containsKey("counts"));
            Assert.assertTrue((boolean)metrics0.containsKey("dur"));
        }
    }

    public static class KryoTest
    extends AbstractGremlinTest {
        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            Vertex v = (Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)v);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Vertex detached = (Vertex)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)v.label(), (Object)detached.label());
            Assert.assertEquals((Object)v.id(), (Object)detached.id());
            Assert.assertEquals((Object)v.value("name").toString(), (Object)detached.value("name"));
            Assert.assertEquals((Object)((Integer)v.value("age")), (Object)detached.value("age"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeEdgeAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)e);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Edge detached = (Edge)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)e.label(), (Object)detached.label());
            Assert.assertEquals((Object)e.id(), (Object)detached.id());
            Assert.assertEquals((Object)((Double)e.value("weight")), (Object)detached.value("weight"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePropertyAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            Property property = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)property);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Property detached = (Property)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)property.key(), (Object)detached.key());
            Assert.assertEquals((Object)property.value(), (Object)detached.value());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexPropertyAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            VertexProperty vertexProperty = ((Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)vertexProperty);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            VertexProperty detached = (VertexProperty)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)vertexProperty.label(), (Object)detached.label());
            Assert.assertEquals((Object)vertexProperty.id(), (Object)detached.id());
            Assert.assertEquals((Object)vertexProperty.value(), (Object)detached.value());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
        public void shouldSerializeVertexPropertyWithPropertiesAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            VertexProperty vertexProperty = (VertexProperty)((Vertex)this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next()).properties(new String[]{"location"}).next();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)vertexProperty);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            VertexProperty detached = (VertexProperty)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)vertexProperty.label(), (Object)detached.label());
            Assert.assertEquals((Object)vertexProperty.id(), (Object)detached.id());
            Assert.assertEquals((Object)vertexProperty.value(), (Object)detached.value());
            Assert.assertEquals(vertexProperty.values(new String[]{"startTime"}).next(), detached.values(new String[]{"startTime"}).next());
            Assert.assertEquals((Object)((Property)vertexProperty.properties(new String[]{"startTime"}).next()).key(), (Object)((Property)detached.properties(new String[]{"startTime"}).next()).key());
            Assert.assertEquals(vertexProperty.values(new String[]{"endTime"}).next(), detached.values(new String[]{"endTime"}).next());
            Assert.assertEquals((Object)((Property)vertexProperty.properties(new String[]{"endTime"}).next()).key(), (Object)((Property)detached.properties(new String[]{"endTime"}).next()).key());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePathAsDetached() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            Path p = (Path)this.g.V(new Object[]{this.convertToVertexId("marko")}).as("a").outE(new String[0]).as("b").inV().as("c").path().filter(t -> ((Vertex)((Path)t.get()).objects().get(2)).value("name").equals("lop")).next();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)p);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Path detached = (Path)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((long)p.labels().size(), (long)detached.labels().size());
            Assert.assertEquals((long)((Set)p.labels().get(0)).size(), (long)((Set)detached.labels().get(0)).size());
            Assert.assertEquals((long)((Set)p.labels().get(1)).size(), (long)((Set)detached.labels().get(1)).size());
            Assert.assertEquals((long)((Set)p.labels().get(2)).size(), (long)((Set)detached.labels().get(2)).size());
            Assert.assertTrue((boolean)p.labels().stream().flatMap(Collection::stream).allMatch(arg_0 -> ((Path)detached).hasLabel(arg_0)));
            Vertex vOut = (Vertex)p.get("a");
            Vertex detachedVOut = (Vertex)detached.get("a");
            Assert.assertEquals((Object)vOut.label(), (Object)detachedVOut.label());
            Assert.assertEquals((Object)vOut.id(), (Object)detachedVOut.id());
            Assert.assertFalse((boolean)detachedVOut.properties(new String[0]).hasNext());
            Edge e = (Edge)p.get("b");
            Edge detachedE = (Edge)detached.get("b");
            Assert.assertEquals((Object)e.label(), (Object)detachedE.label());
            Assert.assertEquals((Object)e.id(), (Object)detachedE.id());
            Assert.assertFalse((boolean)detachedE.properties(new String[0]).hasNext());
            Vertex vIn = (Vertex)p.get("c");
            Vertex detachedVIn = (Vertex)detached.get("c");
            Assert.assertEquals((Object)vIn.label(), (Object)detachedVIn.label());
            Assert.assertEquals((Object)vIn.id(), (Object)detachedVIn.id());
            Assert.assertFalse((boolean)detachedVIn.properties(new String[0]).hasNext());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeTraversalMetrics() throws Exception {
            GryoWriter gryoWriter = this.graph.io().gryoWriter().create();
            GryoReader gryoReader = this.graph.io().gryoReader().create();
            TraversalMetrics before = (TraversalMetrics)this.g.V(new Object[0]).both(new String[0]).profile().cap(new String[]{TraversalMetrics.METRICS_KEY}).next();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            gryoWriter.writeObject((OutputStream)outputStream, (Object)before);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            TraversalMetrics after = (TraversalMetrics)gryoReader.readObject((InputStream)inputStream);
            Assert.assertNotNull((Object)after);
            Assert.assertEquals((long)before.getMetrics().size(), (long)after.getMetrics().size());
            Assert.assertEquals((long)before.getDuration(TimeUnit.MILLISECONDS), (long)after.getDuration(TimeUnit.MILLISECONDS));
            Assert.assertEquals((Object)before.getMetrics(0).getCounts(), (Object)after.getMetrics(0).getCounts());
        }
    }
}

