/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.UseEngines;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.junit.Assert;
import org.junit.Test;

@UseEngines(value={@UseEngine(value=TraversalEngine.Type.STANDARD), @UseEngine(value=TraversalEngine.Type.COMPUTER)})
public class ReadOnlyStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    public void shouldTraverseV() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]), false);
    }

    @Test
    public void shouldTraverseV_out() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).out(new String[0]), false);
    }

    @Test
    public void shouldTraverseV_in() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).in(new String[0]), false);
    }

    @Test
    public void shouldTraverseV_in_in() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).in(new String[0]), false);
    }

    @Test
    public void shouldTraverseE() {
        this.assertTraversal((Traversal)this.create().E(new Object[0]), false);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_out_addInE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").out(new String[0]).addInE("test", "a", new Object[0]), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_out_addOutE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").out(new String[0]).addOutE("test", "a", new Object[0]), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addInE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").in(new String[0]).addInE("test", "a", new Object[0]), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addOutE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").in(new String[0]).addOutE("test", "a", new Object[0]), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addEXINX() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").in(new String[0]).addE(Direction.IN, "test", "a", new Object[0]), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addEXOUTX() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a").in(new String[0]).addE(Direction.OUT, "test", "a", new Object[0]), true);
    }

    private GraphTraversalSource create() {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{ReadOnlyStrategy.instance()});
    }

    private void assertTraversal(Traversal t, boolean hasMutatingStep) {
        try {
            t.asAdmin().applyStrategies();
            if (hasMutatingStep) {
                Assert.fail((String)"The strategy should have found a mutating step.");
            }
        }
        catch (IllegalStateException ise) {
            if (!hasMutatingStep) {
                Assert.fail((String)"The traversal should not have failed as there is no mutating step.");
            }
            Assert.assertEquals((Object)"The provided traversal has a mutating step and thus is not read only", (Object)ise.getMessage());
        }
    }
}

