/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.UseEngines;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

@UseEngines(value={@UseEngine(value=TraversalEngine.Type.STANDARD), @UseEngine(value=TraversalEngine.Type.COMPUTER)})
public class SubgraphStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterVertexCriterion() throws Exception {
        Predicate<Vertex> vertexCriterion = vertex -> vertex.value("name").equals("josh") || vertex.value("name").equals("lop") || vertex.value("name").equals("ripple");
        Predicate<Edge> edgeCriterion = edge -> true;
        SubgraphStrategy strategy = SubgraphStrategy.build().edgePredicate(edgeCriterion).vertexPredicate(vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.outE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).next();
            Assert.fail((String)"Edge 12 should not be in the graph because peter is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            Assert.fail((String)"Edge 7 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterEdgeCriterion() throws Exception {
        Predicate<Vertex> vertexCriterion = vertex -> true;
        Predicate<Edge> edgeCriterion = edge -> {
            if ((Double)edge.value("weight") == 1.0 && edge.label().equals("knows")) {
                return true;
            }
            if ((Double)edge.value("weight") == 0.4 && edge.label().equals("created") && edge.outVertex().value("name").equals("marko")) {
                return true;
            }
            return (Double)edge.value("weight") == 1.0 && edge.label().equals("created");
        };
        SubgraphStrategy strategy = SubgraphStrategy.build().edgePredicate(edgeCriterion).vertexPredicate(vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).outE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        GraphTraversal t = sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]);
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).limit(1L).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).bothV().count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "josh")}).outV().outE(new String[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFilterMixedCriteria() throws Exception {
        Predicate<Vertex> vertexCriterion = vertex -> vertex.value("name").equals("josh") || vertex.value("name").equals("lop") || vertex.value("name").equals("ripple");
        Predicate<Edge> edgeCriterion = edge -> {
            if ((Double)edge.value("weight") == 0.4 && edge.label().equals("created")) {
                return true;
            }
            return (Double)edge.value("weight") == 1.0 && edge.label().equals("created");
        };
        SubgraphStrategy strategy = SubgraphStrategy.build().edgePredicate(edgeCriterion).vertexPredicate(vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)sg.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.E(new Object[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[0]).count().next()));
        Assert.assertEquals((long)3L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[0]).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).outE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).out(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"created"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).inE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).in(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).bothE(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).both(new String[]{"knows"}).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[0]).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)this.g.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)1L, (long)((Long)sg.V(new Object[]{this.convertToVertexId("josh")}).local((Traversal)__.bothE((String[])new String[]{"knows", "created"}).limit(1L)).inV().count().next()));
        Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).bothV().count().next()));
        try {
            sg.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next();
            Assert.fail((String)"Edge 9 should not be in the graph because marko is not a vertex");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedVertex() throws Exception {
        Predicate<Vertex> vertexCriterion = vertex -> vertex.value("name").equals("josh") || vertex.value("name").equals("lop") || vertex.value("name").equals("ripple");
        Predicate<Edge> edgeCriterion = edge -> true;
        SubgraphStrategy strategy = SubgraphStrategy.build().edgePredicate(edgeCriterion).vertexPredicate(vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        sg.V(new Object[]{this.convertToVertexId("marko")}).next();
    }

    @Test(expected=NoSuchElementException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldGetExcludedEdge() throws Exception {
        Predicate<Vertex> vertexCriterion = vertex -> true;
        Predicate<Edge> edgeCriterion = edge -> {
            if ((Double)edge.value("weight") == 1.0 && edge.label().equals("knows")) {
                return true;
            }
            if ((Double)edge.value("weight") == 0.4 && edge.label().equals("created") && edge.outVertex().value("name").equals("marko")) {
                return true;
            }
            return (Double)edge.value("weight") == 1.0 && edge.label().equals("created");
        };
        SubgraphStrategy strategy = SubgraphStrategy.build().edgePredicate(edgeCriterion).vertexPredicate(vertexCriterion).create();
        GraphTraversalSource sg = this.create(strategy);
        sg.E(new Object[]{sg.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()}).next();
    }

    private GraphTraversalSource create(SubgraphStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }
}

