/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.junit.Assert;
import org.junit.Test;

@UseEngine(value=TraversalEngine.Type.STANDARD)
public class PathTest
extends AbstractGremlinProcessTest {
    @Test
    public void shouldHaveStandardSemanticsImplementedCorrectly() {
        Arrays.asList(MutablePath.make(), ImmutablePath.make()).forEach(path -> {
            Assert.assertTrue((boolean)path.isSimple());
            Assert.assertEquals((long)0L, (long)path.size());
            path = path.extend((Object)1, new String[]{"a"});
            path = path.extend((Object)2, new String[]{"b"});
            path = path.extend((Object)3, new String[]{"c"});
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((Object)1, (Object)path.get("a"));
            Assert.assertEquals((Object)2, (Object)path.get("b"));
            Assert.assertEquals((Object)3, (Object)path.get("c"));
            path.addLabel("d");
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((Object)1, (Object)path.get("a"));
            Assert.assertEquals((Object)2, (Object)path.get("b"));
            Assert.assertEquals((Object)3, (Object)path.get("c"));
            Assert.assertEquals((Object)3, (Object)path.get("d"));
            Assert.assertTrue((boolean)path.hasLabel("a"));
            Assert.assertTrue((boolean)path.hasLabel("b"));
            Assert.assertTrue((boolean)path.hasLabel("c"));
            Assert.assertTrue((boolean)path.hasLabel("d"));
            Assert.assertFalse((boolean)path.hasLabel("e"));
            Assert.assertTrue((boolean)path.isSimple());
            path = path.extend((Object)3, new String[]{"e"});
            Assert.assertFalse((boolean)path.isSimple());
            Assert.assertTrue((boolean)path.hasLabel("e"));
            Assert.assertEquals((long)4L, (long)path.size());
            Assert.assertEquals((Object)1, (Object)path.get(0));
            Assert.assertEquals((Object)2, (Object)path.get(1));
            Assert.assertEquals((Object)3, (Object)path.get(2));
            Assert.assertEquals((Object)3, (Object)path.get(3));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleMultiLabelPaths() {
        Arrays.asList(MutablePath.make(), ImmutablePath.make()).forEach(path -> {
            path = path.extend((Object)"marko", new String[]{"a"});
            path = path.extend((Object)"stephen", new String[]{"b"});
            path = path.extend((Object)"matthias", new String[]{"a"});
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((long)3L, (long)path.objects().size());
            Assert.assertEquals((long)3L, (long)path.labels().size());
            Assert.assertEquals((long)2L, (long)new HashSet(path.labels()).size());
            Assert.assertTrue((boolean)(path.get("a") instanceof List));
            Assert.assertTrue((boolean)(path.get("b") instanceof String));
            Assert.assertEquals((long)2L, (long)((List)path.get("a")).size());
            Assert.assertTrue((boolean)((List)path.get("a")).contains("marko"));
            Assert.assertTrue((boolean)((List)path.get("a")).contains("matthias"));
        });
        Path path2 = (Path)this.g.V(new Object[0]).as("x").repeat((Traversal)__.out((String[])new String[0]).as("y")).times(2).path().by("name").next();
        Assert.assertEquals((long)3L, (long)path2.size());
        Assert.assertEquals((long)3L, (long)path2.labels().size());
        Assert.assertEquals((long)2L, (long)new HashSet(path2.labels()).size());
        Assert.assertTrue((boolean)(path2.get("x") instanceof String));
        Assert.assertTrue((boolean)(path2.get("y") instanceof List));
        Assert.assertEquals((long)2L, (long)((List)path2.get("y")).size());
        Assert.assertTrue((boolean)((List)path2.get("y")).contains("josh"));
        Assert.assertTrue((((List)path2.get("y")).contains("ripple") || ((List)path2.get("y")).contains("lop") ? 1 : 0) != 0);
    }

    @Test
    public void shouldExcludeUnlabeledLabelsFromPath() {
        Arrays.asList(MutablePath.make(), ImmutablePath.make()).forEach(path -> {
            path = path.extend((Object)"marko", new String[]{"a"});
            path = path.extend((Object)"stephen", new String[]{"b"});
            path = path.extend((Object)"matthias", new String[]{"c", "d"});
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((long)3L, (long)path.objects().size());
            Assert.assertEquals((long)3L, (long)path.labels().size());
            Assert.assertEquals((long)1L, (long)((Set)path.labels().get(0)).size());
            Assert.assertEquals((long)1L, (long)((Set)path.labels().get(1)).size());
            Assert.assertEquals((Object)"b", ((Set)path.labels().get(1)).iterator().next());
            Assert.assertEquals((long)2L, (long)((Set)path.labels().get(2)).size());
            Assert.assertTrue((boolean)((Set)path.labels().get(2)).contains("c"));
            Assert.assertTrue((boolean)((Set)path.labels().get(2)).contains("d"));
        });
    }
}

