/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.UseEngines;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class FoldTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, List<Vertex>> get_g_V_fold();

    public abstract Traversal<Vertex, Vertex> get_g_V_fold_unfold();

    public abstract Traversal<Vertex, Integer> get_g_V_age_foldX0_plusX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_fold() {
        Traversal<Vertex, List<Vertex>> traversal = this.get_g_V_fold();
        this.printTraversalForm(traversal);
        List list = (List)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        HashSet vertices = new HashSet(list);
        Assert.assertEquals((long)6L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_fold_unfold() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_fold_unfold();
        this.printTraversalForm(traversal);
        int count = 0;
        HashSet<Object> vertices = new HashSet<Object>();
        while (traversal.hasNext()) {
            vertices.add(traversal.next());
            ++count;
        }
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertEquals((long)6L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_age_foldX0_plusX() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_age_foldX0_plusX();
        this.printTraversalForm(traversal);
        Integer ageSum = (Integer)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)123, (Object)ageSum);
    }

    @UseEngines(value={@UseEngine(value=TraversalEngine.Type.STANDARD), @UseEngine(value=TraversalEngine.Type.COMPUTER)})
    public static class Traversals
    extends FoldTest {
        @Override
        public Traversal<Vertex, List<Vertex>> get_g_V_fold() {
            return this.g.V(new Object[0]).fold();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_fold_unfold() {
            return this.g.V(new Object[0]).fold().unfold();
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_age_foldX0_plusX() {
            return this.g.V(new Object[0]).values(new String[]{"age"}).fold((Object)0, (BiFunction)Operator.sum);
        }
    }
}

