/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.UseEngines;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Compare;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class HasTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_V_outXknowsX_hasXoutXcreatedXX_name();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object var1, String var2);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_markoX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_blahX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXblahX();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X();

    public abstract Traversal<Edge, Edge> get_g_EX7X_hasLabelXknowsX(Object var1);

    public abstract Traversal<Edge, Edge> get_g_E_hasLabelXknowsX();

    public abstract Traversal<Edge, Edge> get_g_E_hasLabelXuses_traversesX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXperson_software_blahX();

    public abstract Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outE_hasXweight_inside_0_06X_inV(Object var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXknowsX_hasXoutXcreatedXX_valuesXnameX() {
        Traversal<Vertex, String> traversal = this.get_g_V_outXknowsX_hasXoutXcreatedXX_name();
        this.printTraversalForm(traversal);
        this.checkResults(Arrays.asList("josh"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXkeyX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "name");
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "circumference");
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_markoX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_blahX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXage_gt_30X();
        this.printTraversalForm(traversal);
        List list = traversal.toList();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Element v : list) {
            Assert.assertTrue(((Integer)v.value("age") > 30 ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasIdX2X(this.convertToVertexId("marko"), this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)((Vertex)traversal.next()).id());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXblahX() {
        Assume.assumeTrue((boolean)this.graphMeetsTestRequirements());
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXblahX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX7X_hasXlabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_EX7X_hasLabelXknowsX(this.convertToEdgeId("marko", "knows", "vadas"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_hasXlabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasLabelXknowsX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_E_hasXlabelXuses_traversesX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasLabelXuses_traversesX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Edge)traversal.next()).label();
            Assert.assertTrue((label.equals("uses") || label.equals("traverses") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)9L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_hasXlabelXperson_software_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXperson_software_blahX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Vertex)traversal.next()).label();
            Assert.assertTrue((label.equals("software") || label.equals("person") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXperson_name_markoX_age() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_hasXperson_name_markoX_age();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)29L, (long)((Integer)traversal.next()).intValue());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_hasXweight_inside_0_06X_inV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outE_hasXweight_inside_0_06X_inV(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            Assert.assertTrue((vertex.value("name").equals("vadas") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @UseEngines(value={@UseEngine(value=TraversalEngine.Type.STANDARD), @UseEngine(value=TraversalEngine.Type.COMPUTER)})
    public static class Traversals
    extends HasTest {
        @Override
        public Traversal<Vertex, String> get_g_V_outXknowsX_hasXoutXcreatedXX_name() {
            return this.g.V(new Object[0]).out(new String[]{"knows"}).has((Traversal)__.out((String[])new String[]{"created"})).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object v1Id, String key) {
            return this.g.V(new Object[]{v1Id}).has(key);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_markoX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_blahX() {
            return this.g.V(new Object[0]).has("name", (Object)"blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXblahX() {
            return this.g.V(new Object[0]).has("blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("age", (BiPredicate)Compare.gt, (Object)30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasIdX2X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).hasId(new Object[]{v2Id});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X() {
            return this.g.V(new Object[0]).has("age", (BiPredicate)Compare.gt, (Object)30);
        }

        @Override
        public Traversal<Edge, Edge> get_g_EX7X_hasLabelXknowsX(Object e7Id) {
            return this.g.E(new Object[]{e7Id}).hasLabel(new String[]{"knows"});
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasLabelXknowsX() {
            return this.g.E(new Object[0]).hasLabel(new String[]{"knows"});
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasLabelXuses_traversesX() {
            return this.g.E(new Object[0]).hasLabel(new String[]{"uses", "traverses"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXperson_software_blahX() {
            return this.g.V(new Object[0]).hasLabel(new String[]{"person", "software", "blah"});
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age() {
            return this.g.V(new Object[0]).has("person", "name", (Object)"marko").values(new String[]{"age"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outE_hasXweight_inside_0_06X_inV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[0]).has("weight", (BiPredicate)Compare.inside, Arrays.asList(0.0, 0.6)).inV();
        }
    }
}

