/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.process.UseEngine;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@UseEngine(value=TraversalEngine.Type.COMPUTER)
public class ComputerGraphTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void shouldFilterHiddenProperties() {
        ComputerGraph sg = new ComputerGraph(this.graph, new HashSet<String>(Arrays.asList("***hidden-guy")));
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Iterator props = v.properties(new String[0]);
        VertexProperty v1 = (VertexProperty)props.next();
        Assert.assertEquals((Object)"Y", (Object)v1.value());
        Assert.assertEquals((Object)"not-hidden-guy", (Object)v1.key());
        Assert.assertFalse((boolean)props.hasNext());
        Iterator values = v.values(new String[0]);
        Assert.assertEquals((Object)"Y", values.next());
        Assert.assertFalse((boolean)values.hasNext());
    }

    @Test
    @Ignore(value="We need to decide the semantics")
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void shouldAccessHiddenProperties() {
        ComputerGraph sg = new ComputerGraph(this.graph, new HashSet<String>(new HashSet<String>(Arrays.asList("***hidden-guy"))));
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Iterator props = v.properties(new String[]{"***hidden-guy"});
        VertexProperty v1 = (VertexProperty)props.next();
        Assert.assertEquals((Object)"X", (Object)v1.value());
        Assert.assertEquals((Object)"***hidden-guy", (Object)v1.key());
        Assert.assertFalse((boolean)props.hasNext());
        Iterator values = v.values(new String[]{"***hidden-guy"});
        Assert.assertEquals((Object)"X", values.next());
        Assert.assertFalse((boolean)values.hasNext());
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void shouldHideHiddenKeys() {
        ComputerGraph sg = new ComputerGraph(this.graph, new HashSet<String>(Arrays.asList("***hidden-guy")));
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Set keys = v.keys();
        Assert.assertTrue((boolean)keys.contains("not-hidden-guy"));
        Assert.assertFalse((boolean)keys.contains("***hidden-guy"));
    }
}

