/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.structure.Graph;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface FeatureRequirementSet {
    public Package value() default Package.SIMPLE;

    public static enum Package {
        SIMPLE,
        VERTICES_ONLY;

        private static final List<FeatureRequirement> featuresRequiredBySimple;
        private static final List<FeatureRequirement> featuresRequiredByVerticesOnly;

        public List<FeatureRequirement> featuresRequired() {
            switch (this) {
                case SIMPLE: {
                    return featuresRequiredBySimple;
                }
                case VERTICES_ONLY: {
                    return featuresRequiredByVerticesOnly;
                }
            }
            throw new RuntimeException("No features for this GraphData type");
        }

        static {
            featuresRequiredBySimple = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("AddVertices", Graph.Features.VertexFeatures.class));
                    this.add(FeatureRequirement.Factory.create("AddEdges", Graph.Features.EdgeFeatures.class));
                    this.add(FeatureRequirement.Factory.create("AddProperty", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.EdgePropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("AddProperty", Graph.Features.EdgeFeatures.class));
                }
            };
            featuresRequiredByVerticesOnly = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("AddVertices", Graph.Features.VertexFeatures.class));
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("AddProperty", Graph.Features.VertexPropertyFeatures.class));
                }
            };
        }
    }
}

