/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IoEdgeTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String ioType;
    @Parameterized.Parameter(value=1)
    public boolean assertIdDirectly;
    @Parameterized.Parameter(value=2)
    public boolean assertDouble;
    @Parameterized.Parameter(value=3)
    public Function<Graph, GraphReader> readerMaker;
    @Parameterized.Parameter(value=4)
    public Function<Graph, GraphWriter> writerMaker;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"graphson", false, false, g -> ((GraphSONIo)g.io(IoCore.graphson())).reader().create(), g -> ((GraphSONIo)g.io(IoCore.graphson())).writer().create()}, {"graphson-embedded", true, true, g -> ((GraphSONIo)g.io(IoCore.graphson())).reader().mapper(((GraphSONIo)g.io(IoCore.graphson())).mapper().embedTypes(true).create()).create(), g -> ((GraphSONIo)g.io(IoCore.graphson())).writer().mapper(((GraphSONIo)g.io(IoCore.graphson())).mapper().embedTypes(true).create()).create()}, {"gryo", true, true, g -> ((GryoIo)g.io(IoCore.gryo())).reader().create(), g -> ((GryoIo)g.io(IoCore.gryo())).writer().create()});
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteEdge() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"});
        this.assertEdge(v1, v2, e, true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdge() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"}), (boolean)true);
        this.assertEdge(v1, v2, (Edge)e, true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedEdgeAsReference() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        DetachedEdge e = DetachedFactory.detach((Edge)v1.addEdge("friend", v2, new Object[]{"weight", 0.5, "acl", "rw"}), (boolean)false);
        this.assertEdge(v1, v2, (Edge)e, false);
    }

    private void assertEdge(Vertex v1, Vertex v2, Edge e, boolean assertProperties) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeEdge((OutputStream)os, e);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readEdge((InputStream)bais, edge2 -> {
                    Edge detachedEdge = (Edge)edge2;
                    Assert.assertEquals((Object)e.id(), (Object)(this.assertIdDirectly ? detachedEdge.id() : ((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v1.id(), (Object)(this.assertIdDirectly ? detachedEdge.outVertex().id() : ((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v2.id(), (Object)(this.assertIdDirectly ? detachedEdge.inVertex().id() : ((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                    Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                    Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                    if (assertProperties) {
                        Assert.assertEquals((Object)(this.assertDouble ? 0.5 : 0.5), (Object)((Property)e.properties(new String[]{"weight"}).next()).value());
                        Assert.assertEquals((Object)"rw", (Object)((Property)e.properties(new String[]{"acl"}).next()).value());
                    } else {
                        Assert.assertEquals((long)e.keys().size(), (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                    }
                    called.set(true);
                    return null;
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }
}

