/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractGremlinTest {
    protected Graph graph;
    protected GraphTraversalSource g;
    protected Optional<Class<? extends GraphComputer>> graphComputerClass;
    protected Configuration config;
    protected GraphProvider graphProvider;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        FeatureRequirementSet[] featureRequirementSets;
        Method testMethod = this.getClass().getMethod(AbstractGremlinTest.cleanMethodName(this.name.getMethodName()), new Class[0]);
        LoadGraphWith[] loadGraphWiths = (LoadGraphWith[])testMethod.getAnnotationsByType(LoadGraphWith.class);
        LoadGraphWith loadGraphWith = loadGraphWiths.length == 0 ? null : loadGraphWiths[0];
        LoadGraphWith.GraphData loadGraphWithData = null == loadGraphWith ? null : loadGraphWith.value();
        this.graphProvider = GraphManager.getGraphProvider();
        this.config = this.graphProvider.standardGraphConfiguration(this.getClass(), this.name.getMethodName(), loadGraphWithData);
        this.graphProvider.clear(this.config);
        this.graph = this.graphProvider.openTestGraph(this.config);
        this.g = this.graphProvider.traversal(this.graph);
        this.graphComputerClass = this.g.getGraphComputer().isPresent() ? Optional.of(((GraphComputer)this.g.getGraphComputer().get()).getClass()) : Optional.empty();
        FeatureRequirement[] featureRequirement = (FeatureRequirement[])testMethod.getAnnotationsByType(FeatureRequirement.class);
        ArrayList<FeatureRequirement> frs = new ArrayList<FeatureRequirement>(Arrays.asList(featureRequirement));
        if (loadGraphWiths.length > 0) {
            frs.addAll(loadGraphWiths[0].value().featuresRequired());
        }
        if ((featureRequirementSets = (FeatureRequirementSet[])testMethod.getAnnotationsByType(FeatureRequirementSet.class)).length > 0) {
            frs.addAll(Arrays.stream(featureRequirementSets).flatMap(f -> f.value().featuresRequired().stream()).collect(Collectors.toList()));
        }
        HashSet<FeatureRequirement> featureRequirementSet = new HashSet<FeatureRequirement>(frs);
        for (FeatureRequirement fr : featureRequirementSet) {
            try {
                Assume.assumeThat((String)String.format("%s does not support all of the features required by this test so it will be ignored: %s.%s=%s", this.graph.getClass().getSimpleName(), fr.featureClass().getSimpleName(), fr.feature(), fr.supported()), (Object)this.graph.features().supports(fr.featureClass(), fr.feature()), (Matcher)CoreMatchers.is((Object)fr.supported()));
            }
            catch (NoSuchMethodException nsme) {
                throw new NoSuchMethodException(String.format("[supports%s] is not a valid feature on %s", fr.feature(), fr.featureClass()));
            }
        }
        this.beforeLoadGraphWith(this.graph);
        this.graphProvider.loadGraphData(this.graph, loadGraphWith, this.getClass(), this.name.getMethodName());
        this.afterLoadGraphWith(this.graph);
    }

    protected void beforeLoadGraphWith(Graph g) throws Exception {
    }

    protected void afterLoadGraphWith(Graph g) throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.graphProvider) {
            this.graphProvider.clear(this.graph, this.config);
            this.g = null;
            this.config = null;
            this.graphProvider = null;
        }
    }

    public Object convertToVertexId(String vertexName) {
        return this.convertToVertexId(this.graph, vertexName);
    }

    public Object convertToVertexId(Graph g, String vertexName) {
        return this.convertToVertex(g, vertexName).id();
    }

    public Vertex convertToVertex(Graph graph, String vertexName) {
        return (Vertex)graph.traversal().V(new Object[0]).has("name", (Object)vertexName).next();
    }

    public GraphTraversal<Vertex, Object> convertToVertexPropertyId(String vertexName, String vertexPropertyKey) {
        return this.convertToVertexPropertyId(this.graph, vertexName, vertexPropertyKey);
    }

    public GraphTraversal<Vertex, Object> convertToVertexPropertyId(Graph g, String vertexName, String vertexPropertyKey) {
        return this.convertToVertexProperty(g, vertexName, vertexPropertyKey).id();
    }

    public GraphTraversal<Vertex, VertexProperty<Object>> convertToVertexProperty(Graph graph, String vertexName, String vertexPropertyKey) {
        return graph.traversal().V(new Object[0]).has("name", (Object)vertexName).properties(new String[]{vertexPropertyKey});
    }

    public Object convertToEdgeId(String outVertexName, String edgeLabel, String inVertexName) {
        return this.convertToEdgeId(this.graph, outVertexName, edgeLabel, inVertexName);
    }

    public Object convertToEdgeId(Graph graph, String outVertexName, String edgeLabel, String inVertexName) {
        return ((Edge)graph.traversal().V(new Object[0]).has("name", (Object)outVertexName).outE(new String[]{edgeLabel}).as("e", new String[0]).inV().has("name", (Object)inVertexName).select("e").next()).id();
    }

    public void tryCommit(Graph g) {
        if (g.features().graph().supportsTransactions()) {
            g.tx().commit();
        }
    }

    public void tryRandomCommit(Graph g) {
        if (g.features().graph().supportsTransactions() && new Random().nextBoolean()) {
            g.tx().commit();
        }
    }

    public void tryCommit(Graph g, Consumer<Graph> assertFunction) {
        assertFunction.accept(g);
        if (g.features().graph().supportsTransactions()) {
            g.tx().commit();
            assertFunction.accept(g);
        }
    }

    public void tryRollback(Graph g) {
        if (g.features().graph().supportsTransactions()) {
            g.tx().rollback();
        }
    }

    private static String cleanMethodName(String methodName) {
        if (methodName.endsWith("]")) {
            return methodName.substring(0, methodName.indexOf("["));
        }
        return methodName;
    }

    public void printTraversalForm(Traversal traversal) {
        boolean muted = Boolean.parseBoolean(System.getProperty("muteTestLogs", "false"));
        if (!muted) {
            System.out.println(String.format("Testing: %s", this.name.getMethodName()));
        }
        if (!muted) {
            System.out.println("   pre-strategy:" + traversal);
        }
        traversal.hasNext();
        if (!muted) {
            System.out.println("  post-strategy:" + traversal);
        }
        AbstractGremlinTest.verifyUniqueStepIds(traversal.asAdmin());
    }

    public boolean isComputerTest() {
        return this.graphComputerClass.isPresent();
    }

    public static Consumer<Graph> assertVertexEdgeCounts(int expectedVertexCount, int expectedEdgeCount) {
        return g -> {
            Assert.assertEquals((long)expectedVertexCount, (long)IteratorUtils.count((Iterator)g.vertices(new Object[0])));
            Assert.assertEquals((long)expectedEdgeCount, (long)IteratorUtils.count((Iterator)g.edges(new Object[0])));
        };
    }

    public static void validateException(Throwable expected, Throwable actual) {
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.instanceOf(expected.getClass()));
    }

    public static void verifyUniqueStepIds(Traversal.Admin<?, ?> traversal) {
        AbstractGremlinTest.verifyUniqueStepIds(traversal, 0, new HashSet<String>());
    }

    private static void verifyUniqueStepIds(Traversal.Admin<?, ?> traversal, int depth, Set<String> ids) {
        for (Step step : traversal.asAdmin().getSteps()) {
            if (!ids.add(step.getId())) {
                Assert.fail((String)("The following step id already exists: " + step.getId() + "---" + step));
            }
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin globalTraversal : ((TraversalParent)step).getGlobalChildren()) {
                AbstractGremlinTest.verifyUniqueStepIds(globalTraversal, depth + 1, ids);
            }
            for (Traversal.Admin localTraversal : ((TraversalParent)step).getLocalChildren()) {
                AbstractGremlinTest.verifyUniqueStepIds(localTraversal, depth + 1, ids);
            }
        }
    }
}

