/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.socket.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.socket.server.SocketServerSettings;

public class SimpleSocketServer {
    private final SocketServerSettings settings;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public SimpleSocketServer(SocketServerSettings settings) {
        this.settings = settings;
    }

    public Channel start(ChannelInitializer<SocketChannel> channelInitializer) throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler(channelInitializer);
        return b.bind(this.settings.PORT).sync().channel();
    }

    public void stop() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public void stopSync() throws InterruptedException {
        this.bossGroup.shutdownGracefully().sync();
        this.workerGroup.shutdownGracefully().sync();
    }
}

