/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptChecker;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.AbstractTraverser;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;

public class Context {
    private final RequestMessage requestMessage;
    private final ChannelHandlerContext channelHandlerContext;
    private final Settings settings;
    private final GraphManager graphManager;
    private final GremlinExecutor gremlinExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long requestTimeout;
    private final String materializeProperties;
    private final Object gremlinArgument;
    private HttpGremlinEndpointHandler.RequestState requestState;
    private final AtomicBoolean startedResponse = new AtomicBoolean(false);
    private ScheduledFuture<?> timeoutExecutor = null;
    private boolean timeoutExecutorGrabbed = false;
    private final Object timeoutExecutorLock = new Object();

    public Context(RequestMessage requestMessage, ChannelHandlerContext ctx, Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService) {
        this(requestMessage, ctx, settings, graphManager, gremlinExecutor, scheduledExecutorService, HttpGremlinEndpointHandler.RequestState.NOT_STARTED);
    }

    public Context(RequestMessage requestMessage, ChannelHandlerContext ctx, Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService, HttpGremlinEndpointHandler.RequestState requestState) {
        this.requestMessage = requestMessage;
        this.channelHandlerContext = ctx;
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.gremlinArgument = requestMessage.getGremlin();
        this.requestState = requestState;
        this.requestTimeout = this.determineTimeout();
        this.materializeProperties = this.determineMaterializeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutExecutor(ScheduledFuture<?> timeoutExecutor) {
        Object object = this.timeoutExecutorLock;
        synchronized (object) {
            this.timeoutExecutor = timeoutExecutor;
            if (this.timeoutExecutorGrabbed) {
                this.timeoutExecutor.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> getTimeoutExecutor() {
        Object object = this.timeoutExecutorLock;
        synchronized (object) {
            this.timeoutExecutorGrabbed = true;
            return this.timeoutExecutor;
        }
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getMaterializeProperties() {
        return this.materializeProperties;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public RequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public boolean getStartedResponse() {
        return this.startedResponse.get();
    }

    public void setStartedResponse() {
        this.startedResponse.set(true);
    }

    private long determineTimeout() {
        Long timeoutMs = (Long)this.requestMessage.getField("timeoutMs");
        long seto = null != timeoutMs ? timeoutMs.longValue() : this.settings.getEvaluationTimeout();
        Optional timeoutDefinedInScript = GremlinScriptChecker.parse((String)this.gremlinArgument.toString()).getTimeout();
        return timeoutDefinedInScript.orElse(seto);
    }

    private String determineMaterializeProperties() {
        Optional mp = GremlinScriptChecker.parse((String)this.gremlinArgument.toString()).getMaterializeProperties();
        if (mp.isPresent()) {
            return ((String)mp.get()).equals("tokens") ? "tokens" : "all";
        }
        String materializeProperties = (String)this.requestMessage.getField("materializeProperties");
        return "tokens".equals(materializeProperties) ? "tokens" : "all";
    }

    public void handleDetachment(List<Object> aggregate) {
        block2: {
            Object firstElement;
            block3: {
                if (aggregate.isEmpty() || this.getMaterializeProperties().equals("all")) break block2;
                firstElement = aggregate.get(0);
                if (!(firstElement instanceof Element)) break block3;
                for (int i = 0; i < aggregate.size(); ++i) {
                    aggregate.set(i, ReferenceFactory.detach((Object)aggregate.get(i)));
                }
                break block2;
            }
            if (!(firstElement instanceof AbstractTraverser)) break block2;
            for (Object item : aggregate) {
                ((AbstractTraverser)item).detach();
            }
        }
    }

    public HttpGremlinEndpointHandler.RequestState getRequestState() {
        return this.requestState;
    }

    public void setRequestState(HttpGremlinEndpointHandler.RequestState requestState) {
        this.requestState = requestState;
    }
}

