/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptChecker;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.AbstractTraverser;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.WsUserAgentHandler;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    private final RequestMessage requestMessage;
    private final ChannelHandlerContext channelHandlerContext;
    private final Settings settings;
    private final GraphManager graphManager;
    private final GremlinExecutor gremlinExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean finalResponseWritten = new AtomicBoolean();
    private final long requestTimeout;
    private final String materializeProperties;
    private final RequestContentType requestContentType;
    private final Object gremlinArgument;
    private final AtomicBoolean startedResponse = new AtomicBoolean(false);
    private ScheduledFuture<?> timeoutExecutor = null;
    private boolean timeoutExecutorGrabbed = false;
    private final Object timeoutExecutorLock = new Object();

    public Context(RequestMessage requestMessage, ChannelHandlerContext ctx, Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService) {
        this.requestMessage = requestMessage;
        this.channelHandlerContext = ctx;
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.gremlinArgument = requestMessage.getArgs().get("gremlin");
        this.requestContentType = this.determineRequestContents();
        this.requestTimeout = this.determineTimeout();
        this.materializeProperties = this.determineMaterializeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutExecutor(ScheduledFuture<?> timeoutExecutor) {
        Object object = this.timeoutExecutorLock;
        synchronized (object) {
            this.timeoutExecutor = timeoutExecutor;
            if (this.timeoutExecutorGrabbed) {
                this.timeoutExecutor.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> getTimeoutExecutor() {
        Object object = this.timeoutExecutorLock;
        synchronized (object) {
            this.timeoutExecutorGrabbed = true;
            return this.timeoutExecutor;
        }
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getMaterializeProperties() {
        return this.materializeProperties;
    }

    public boolean isFinalResponseWritten() {
        return this.finalResponseWritten.get();
    }

    public RequestContentType getRequestContentType() {
        return this.requestContentType;
    }

    public Object getGremlinArgument() {
        return this.gremlinArgument;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public RequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public String getUserAgent() {
        return this.getChannelHandlerContext().channel().hasAttr(WsUserAgentHandler.USER_AGENT_ATTR_KEY) ? (String)this.getChannelHandlerContext().channel().attr(WsUserAgentHandler.USER_AGENT_ATTR_KEY).get() : "";
    }

    public boolean getStartedResponse() {
        return this.startedResponse.get();
    }

    public void setStartedResponse() {
        this.startedResponse.set(true);
    }

    public void sendTimeoutResponse() {
        this.sendTimeoutResponse(String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to evaluationTimeout", this.requestMessage));
    }

    public void sendTimeoutResponse(String message) {
        logger.warn(message);
        this.writeAndFlush(ResponseMessage.build((RequestMessage)this.requestMessage).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(message).statusAttributeException((Throwable)new InterruptedException()).create());
    }

    public void writeAndFlush(ResponseMessage message) {
        this.writeAndFlush(message.getStatus().getCode(), message);
    }

    public void writeAndFlush(ResponseStatusCode code, Object responseMessage) {
        this.writeAndMaybeFlush(code, responseMessage, true);
    }

    public void write(ResponseMessage message) {
        this.write(message.getStatus().getCode(), message);
    }

    public void write(ResponseStatusCode code, Object responseMessage) {
        this.writeAndMaybeFlush(code, responseMessage, false);
    }

    public void flush() {
        this.getChannelHandlerContext().flush();
    }

    private void writeAndMaybeFlush(ResponseStatusCode code, Object responseMessage, boolean flush) {
        boolean messageIsFinal = code.isFinalResponse();
        if (this.finalResponseWritten.compareAndSet(false, messageIsFinal)) {
            this.getChannelHandlerContext().write(responseMessage);
            if (flush) {
                this.getChannelHandlerContext().flush();
            }
        } else {
            if (responseMessage instanceof Frame) {
                ((Frame)responseMessage).tryRelease();
            }
            String logMessage = String.format("Another final response message was already written for request %s, ignoring response code: %s", this.getRequestMessage().getRequestId(), code);
            logger.warn(logMessage);
        }
    }

    private RequestContentType determineRequestContents() {
        if (this.gremlinArgument instanceof Bytecode) {
            return RequestContentType.BYTECODE;
        }
        if (this.gremlinArgument instanceof String) {
            return RequestContentType.SCRIPT;
        }
        return RequestContentType.UNKNOWN;
    }

    private long determineTimeout() {
        Map args = this.requestMessage.getArgs();
        long seto = args.containsKey("evaluationTimeout") ? ((Number)args.get("evaluationTimeout")).longValue() : this.settings.getEvaluationTimeout();
        Optional timeoutDefinedInScript = this.requestContentType == RequestContentType.SCRIPT ? GremlinScriptChecker.parse((String)this.gremlinArgument.toString()).getTimeout() : Optional.empty();
        return timeoutDefinedInScript.orElse(seto);
    }

    private String determineMaterializeProperties() {
        Optional mp;
        if (this.requestContentType == RequestContentType.SCRIPT && (mp = GremlinScriptChecker.parse((String)this.gremlinArgument.toString()).getMaterializeProperties()).isPresent()) {
            return ((String)mp.get()).equals("tokens") ? "tokens" : "all";
        }
        Map args = this.requestMessage.getArgs();
        return args.containsKey("materializeProperties") && args.get("materializeProperties").equals("tokens") ? "tokens" : "all";
    }

    public void handleDetachment(List<Object> aggregate) {
        block2: {
            Object firstElement;
            block3: {
                if (aggregate.isEmpty() || this.getMaterializeProperties().equals("all")) break block2;
                firstElement = aggregate.get(0);
                if (!(firstElement instanceof Element)) break block3;
                for (int i = 0; i < aggregate.size(); ++i) {
                    aggregate.set(i, ReferenceFactory.detach((Element)((Element)aggregate.get(i))));
                }
                break block2;
            }
            if (!(firstElement instanceof AbstractTraverser)) break block2;
            for (Object item : aggregate) {
                ((AbstractTraverser)item).detach();
            }
        }
    }

    public static enum RequestContentType {
        BYTECODE,
        SCRIPT,
        UNKNOWN;

    }
}

