/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.auth;

import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.auth.JaasKrbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5Authenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(Krb5Authenticator.class);
    private Subject subject;
    private String principalName;

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public void setup(Map<String, Object> config) {
        String KEYTAB_KEY = "keytab";
        String PRINCIPAL_KEY = "principal";
        logger.info("Config: {}", config);
        if (null == config || !config.containsKey("keytab") || !config.containsKey("principal")) {
            throw new IllegalArgumentException(String.format("Could not configure a %s - provide a 'config' in the 'authentication' settings", Krb5Authenticator.class.getName()));
        }
        try {
            File keytabFile = new File((String)config.get("keytab"));
            this.principalName = (String)config.get("principal");
            this.subject = JaasKrbUtil.loginUsingKeytab(this.principalName, keytabFile);
        }
        catch (Exception e) {
            logger.warn("Failed to login to kdc");
        }
        logger.debug("Done logging in to kdc");
    }

    @Override
    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        logger.debug("newSaslNegotiator() called");
        return Subject.doAs(this.subject, () -> new Krb5SaslAuthenticator());
    }

    @Override
    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        logger.error("Authenticate() should not be called. Use getAuthenticatedUser() when isComplete() is true.");
        return null;
    }

    private class Krb5SaslAuthenticator
    implements Authenticator.SaslNegotiator,
    CallbackHandler {
        private final String mechanism = "GSSAPI";
        private SaslServer saslServer;

        Krb5SaslAuthenticator() {
            try {
                HashMap props = new HashMap();
                if (Krb5Authenticator.this.principalName == null) {
                    throw new IllegalArgumentException("Principal name cannot be empty. Use principal name of format 'service/fqdn@kdcrealm'");
                }
                String[] principalParts = Krb5Authenticator.this.principalName.split("/|@");
                if (principalParts.length < 3) {
                    throw new IllegalArgumentException("Use principal name of format 'service/fqdn@kdcrealm'");
                }
                this.saslServer = Sasl.createSaslServer("GSSAPI", principalParts[0], principalParts[1], props, this);
            }
            catch (SaslException e) {
                logger.error("Creating sasl server failed: ", (Throwable)e);
                throw new IllegalStateException(e);
            }
            if (null == this.saslServer) {
                logger.error("Could not a find a SaslServerFactory for mechanism of {}", (Object)"GSSAPI");
                throw new IllegalStateException("Creating sasl server failed");
            }
            logger.debug("SaslServer created with: {}", (Object)this.saslServer.getMechanismName());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            logger.debug("Krb5 AuthorizeCallback number: " + callbacks.length);
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    String[] authidParts = authid.split("@");
                    ac.setAuthorizedID(authidParts[0]);
                }
            }
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            byte[] response;
            logger.debug("evaluateResponse() length: " + clientResponse.length);
            try {
                response = this.saslServer.evaluateResponse(clientResponse);
            }
            catch (Exception e) {
                logger.warn("Sasl krb5 evaluateResponse failed: " + e);
                throw new AuthenticationException(e);
            }
            return response;
        }

        @Override
        public boolean isComplete() {
            return this.saslServer.isComplete();
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            logger.debug("getAuthenticatedUser called: " + this.saslServer.getAuthorizationID());
            return new AuthenticatedUser(this.saslServer.getAuthorizationID());
        }
    }
}

