/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.OpLoader;
import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.Gremlin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinServer {
    private static final String SERVER_THREAD_PREFIX = "gremlin-server-";
    public static final String AUDIT_LOGGER_NAME = "audit.org.apache.tinkerpop.gremlin.server";
    private static final Logger logger;
    private final Settings settings;
    private Channel ch;
    private CompletableFuture<Void> serverStopped = null;
    private CompletableFuture<ServerGremlinExecutor> serverStarted = null;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ExecutorService gremlinExecutorService;
    private final ServerGremlinExecutor serverGremlinExecutor;
    private final boolean isEpollEnabled;

    public GremlinServer(Settings settings) {
        this(settings, null);
    }

    public GremlinServer(Settings settings, ExecutorService gremlinExecutorService) {
        settings.optionalMetrics().ifPresent(GremlinServer::configureMetrics);
        this.settings = settings;
        GremlinServer.provideDefaultForGremlinPoolSize(settings);
        boolean bl = this.isEpollEnabled = settings.useEpollEventLoop && SystemUtils.IS_OS_LINUX;
        if (settings.useEpollEventLoop && !SystemUtils.IS_OS_LINUX) {
            logger.warn("cannot use epoll in non-linux env, falling back to NIO");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop().join(), "gremlin-server-shutdown"));
        ThreadFactory threadFactoryBoss = ThreadFactoryUtil.create("boss-%d");
        this.bossGroup = this.isEpollEnabled ? new EpollEventLoopGroup(settings.threadPoolBoss, threadFactoryBoss) : new NioEventLoopGroup(settings.threadPoolBoss, threadFactoryBoss);
        ThreadFactory threadFactoryWorker = ThreadFactoryUtil.create("worker-%d");
        this.workerGroup = this.isEpollEnabled ? new EpollEventLoopGroup(settings.threadPoolWorker, threadFactoryWorker) : new NioEventLoopGroup(settings.threadPoolWorker, threadFactoryWorker);
        this.serverGremlinExecutor = new ServerGremlinExecutor(settings, gremlinExecutorService, (ScheduledExecutorService)this.workerGroup);
        this.gremlinExecutorService = this.serverGremlinExecutor.getGremlinExecutorService();
        OpLoader.init(settings);
    }

    public synchronized CompletableFuture<ServerGremlinExecutor> start() throws Exception {
        if (this.serverStarted != null) {
            return this.serverStarted;
        }
        final CompletableFuture<ServerGremlinExecutor> serverReadyFuture = this.serverStarted = new CompletableFuture();
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.settings.writeBufferLowWaterMark, this.settings.writeBufferHighWaterMark));
            b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            this.serverGremlinExecutor.getHooks().forEach(hook -> {
                logger.info("Executing start up {}", (Object)LifeCycleHook.class.getSimpleName());
                try {
                    hook.onStartUp(new LifeCycleHook.Context(logger));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            });
            Channelizer channelizer = GremlinServer.createChannelizer(this.settings);
            channelizer.init(this.serverGremlinExecutor);
            b.group(this.bossGroup, this.workerGroup).childHandler((ChannelHandler)channelizer);
            if (this.isEpollEnabled) {
                b.channel(EpollServerSocketChannel.class);
            } else {
                b.channel(NioServerSocketChannel.class);
            }
            b.bind(this.settings.host, this.settings.port).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        GremlinServer.this.ch = channelFuture.channel();
                        logger.info("Gremlin Server configured with worker thread pool of {}, gremlin pool of {} and boss thread pool of {}.", new Object[]{((GremlinServer)GremlinServer.this).settings.threadPoolWorker, ((GremlinServer)GremlinServer.this).settings.gremlinPool, ((GremlinServer)GremlinServer.this).settings.threadPoolBoss});
                        logger.info("Channel started at port {}.", (Object)((GremlinServer)GremlinServer.this).settings.port);
                        serverReadyFuture.complete(GremlinServer.this.serverGremlinExecutor);
                    } else {
                        serverReadyFuture.completeExceptionally(new IOException(String.format("Could not bind to %s and %s - perhaps something else is bound to that address.", ((GremlinServer)GremlinServer.this).settings.host, ((GremlinServer)GremlinServer.this).settings.port)));
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.error("Gremlin Server Error", (Throwable)ex);
            serverReadyFuture.completeExceptionally(ex);
        }
        return this.serverStarted;
    }

    private static Channelizer createChannelizer(Settings settings) throws Exception {
        try {
            Class<?> clazz = Class.forName(settings.channelizer);
            Object o = clazz.newInstance();
            Channelizer c = (Channelizer)o;
            if (c.supportsIdleMonitor()) {
                logger.info("idleConnectionTimeout was set to {} which resolves to {} seconds when configuring this value - this feature will be {}", new Object[]{settings.idleConnectionTimeout, settings.idleConnectionTimeout / 1000L, settings.idleConnectionTimeout < 1000L ? "disabled" : "enabled"});
                logger.info("keepAliveInterval was set to {} which resolves to {} seconds when configuring this value - this feature will be {}", new Object[]{settings.keepAliveInterval, settings.keepAliveInterval / 1000L, settings.keepAliveInterval < 1000L ? "disabled" : "enabled"});
            }
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Could not find {} implementation defined by the 'channelizer' setting as: {}", (Object)Channelizer.class.getName(), (Object)settings.channelizer);
            throw new RuntimeException(cnfe);
        }
        catch (Exception ex) {
            logger.error("Class defined by the 'channelizer' setting as: {} could not be properly instantiated as a {}", (Object)settings.channelizer, (Object)Channelizer.class.getName());
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Void> stop() {
        if (this.serverStopped != null) {
            return this.serverStopped;
        }
        this.serverStopped = new CompletableFuture();
        CountDownLatch servicesLeftToShutdown = new CountDownLatch(3);
        OpLoader.getProcessors().entrySet().forEach(kv -> {
            logger.info("Shutting down OpProcessor[{}]", kv.getKey());
            try {
                ((OpProcessor)kv.getValue()).close();
            }
            catch (Exception ex) {
                logger.warn("Shutdown will continue but, there was an error encountered while closing " + (String)kv.getKey(), (Throwable)ex);
            }
        });
        if (null == this.ch) {
            servicesLeftToShutdown.countDown();
        } else {
            this.ch.close().addListener(f -> servicesLeftToShutdown.countDown());
        }
        logger.info("Shutting down thread pools.");
        try {
            if (this.gremlinExecutorService != null) {
                this.gremlinExecutorService.shutdown();
            }
        }
        finally {
            logger.debug("Shutdown Gremlin thread pool.");
        }
        try {
            this.workerGroup.shutdownGracefully().addListener(f -> servicesLeftToShutdown.countDown());
        }
        finally {
            logger.debug("Shutdown Worker thread pool.");
        }
        try {
            this.bossGroup.shutdownGracefully().addListener(f -> servicesLeftToShutdown.countDown());
        }
        finally {
            logger.debug("Shutdown Boss thread pool.");
        }
        new Thread(() -> {
            if (this.serverGremlinExecutor != null) {
                this.serverGremlinExecutor.getHooks().forEach(hook -> {
                    logger.info("Executing shutdown {}", (Object)LifeCycleHook.class.getSimpleName());
                    try {
                        hook.onShutDown(new LifeCycleHook.Context(logger));
                    }
                    catch (UnsupportedOperationException | UndeclaredThrowableException runtimeException) {
                        // empty catch block
                    }
                });
            }
            try {
                if (this.gremlinExecutorService != null) {
                    this.gremlinExecutorService.awaitTermination(30000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ie) {
                logger.warn("Timeout waiting for Gremlin thread pool to shutdown - continuing with shutdown process.");
            }
            try {
                servicesLeftToShutdown.await(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                logger.warn("Timeout waiting for boss/worker thread pools to shutdown - continuing with shutdown process.");
            }
            if (this.serverGremlinExecutor != null) {
                Set<String> traversalSourceNames = this.serverGremlinExecutor.getGraphManager().getTraversalSourceNames();
                traversalSourceNames.forEach(traversalSourceName -> {
                    logger.debug("Closing GraphTraversalSource instance [{}]", traversalSourceName);
                    try {
                        this.serverGremlinExecutor.getGraphManager().getTraversalSource((String)traversalSourceName).close();
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Exception while closing GraphTraversalSource instance [%s]", traversalSourceName), (Throwable)ex);
                    }
                    finally {
                        logger.info("Closed GraphTraversalSource instance [{}]", traversalSourceName);
                    }
                    try {
                        this.serverGremlinExecutor.getGraphManager().removeTraversalSource((String)traversalSourceName);
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Exception while removing GraphTraversalSource instance [%s] from GraphManager", traversalSourceName), (Throwable)ex);
                    }
                });
                Set<String> graphNames = this.serverGremlinExecutor.getGraphManager().getGraphNames();
                graphNames.forEach(gName -> {
                    logger.debug("Closing Graph instance [{}]", gName);
                    try {
                        Graph graph = this.serverGremlinExecutor.getGraphManager().getGraph((String)gName);
                        graph.close();
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Exception while closing Graph instance [%s]", gName), (Throwable)ex);
                    }
                    finally {
                        logger.info("Closed Graph instance [{}]", gName);
                    }
                    try {
                        this.serverGremlinExecutor.getGraphManager().removeGraph((String)gName);
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Exception while removing Graph instance [%s] from GraphManager", gName), (Throwable)ex);
                    }
                });
            }
            MetricManager.INSTANCE.removeAllReporters();
            MetricManager.INSTANCE.removeAllMetrics();
            logger.info("Gremlin Server - shutdown complete");
            this.serverStopped.complete(null);
        }, "gremlin-server-stop").start();
        return this.serverStopped;
    }

    public ServerGremlinExecutor getServerGremlinExecutor() {
        return this.serverGremlinExecutor;
    }

    public static void main(String[] args) throws Exception {
        Settings settings;
        GremlinServer.printHeader();
        String file = args.length > 0 ? args[0] : "conf/gremlin-server.yaml";
        try {
            settings = Settings.read(file);
        }
        catch (Exception ex) {
            logger.error("Configuration file at {} could not be found or parsed properly. [{}]", (Object)file, (Object)ex.getMessage());
            return;
        }
        logger.info("Configuring Gremlin Server from {}", (Object)file);
        GremlinServer server = new GremlinServer(settings);
        ((CompletableFuture)server.start().exceptionally(t -> {
            logger.error("Gremlin Server was unable to start and will now begin shutdown: {}", (Object)t.getMessage());
            server.stop().join();
            return null;
        })).join();
    }

    public static String getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append(Gremlin.version() + "\r\n");
        builder.append("         \\,,,/\r\n");
        builder.append("         (o o)\r\n");
        builder.append("-----oOOo-(3)-oOOo-----\r\n");
        return builder.toString();
    }

    private static void configureMetrics(Settings.ServerMetrics settings) {
        MetricManager metrics = MetricManager.INSTANCE;
        settings.optionalConsoleReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addConsoleReporter(config.interval);
            }
        });
        settings.optionalCsvReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addCsvReporter(config.interval, config.fileName);
            }
        });
        settings.optionalJmxReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addJmxReporter(config.domain, config.agentId);
            }
        });
        settings.optionalSlf4jReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addSlf4jReporter(config.interval, config.loggerName);
            }
        });
        settings.optionalGangliaReporter().ifPresent(config -> {
            if (config.enabled) {
                try {
                    metrics.addGangliaReporter(config.host, config.port, config.addressingMode, config.ttl, config.protocol31, config.hostUUID, config.spoof, config.interval);
                }
                catch (IOException ioe) {
                    logger.warn("Error configuring the Ganglia Reporter.", (Throwable)ioe);
                }
            }
        });
        settings.optionalGraphiteReporter().ifPresent(config -> {
            if (config.enabled) {
                metrics.addGraphiteReporter(config.host, config.port, config.prefix, config.interval);
            }
        });
    }

    private static void printHeader() {
        logger.info(GremlinServer.getHeader());
    }

    private static void provideDefaultForGremlinPoolSize(Settings settings) {
        if (settings.gremlinPool == 0) {
            settings.gremlinPool = Runtime.getRuntime().availableProcessors();
        }
    }

    public String toString() {
        return "GremlinServer " + this.settings.host + ":" + this.settings.port;
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        logger = LoggerFactory.getLogger(GremlinServer.class);
    }
}

