/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SaslAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SaslAuthenticationHandler.class);
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    protected final Settings.AuthenticationSettings authenticationSettings;

    public SaslAuthenticationHandler(Authenticator authenticator, Settings.AuthenticationSettings authenticationSettings) {
        super(authenticator);
        this.authenticationSettings = authenticationSettings;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block14: {
            if (msg instanceof RequestMessage) {
                RequestMessage requestMessage = (RequestMessage)msg;
                Attribute negotiator = ctx.attr(StateKey.NEGOTIATOR);
                Attribute request = ctx.attr(StateKey.REQUEST_MESSAGE);
                if (negotiator.get() == null) {
                    try {
                        negotiator.set((Object)this.authenticator.newSaslNegotiator(this.getRemoteInetAddress(ctx)));
                        request.set((Object)requestMessage);
                        ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.AUTHENTICATE).create();
                        ctx.writeAndFlush((Object)authenticate);
                    }
                    catch (Exception ex) {
                        logger.error(String.format("%s is not ready to handle requests - check its configuration or related services", this.authenticator.getClass().getSimpleName()), (Throwable)ex);
                        ResponseMessage error = ResponseMessage.build((RequestMessage)requestMessage).statusMessage("Authenticator is not ready to handle requests").code(ResponseStatusCode.SERVER_ERROR).create();
                        ctx.writeAndFlush((Object)error);
                    }
                } else if (requestMessage.getOp().equals("authentication") && requestMessage.getArgs().containsKey("sasl")) {
                    Object saslObject = requestMessage.getArgs().get("sasl");
                    if (!(saslObject instanceof String)) {
                        ResponseMessage error = ResponseMessage.build((RequestMessage)((RequestMessage)request.get())).statusMessage("Incorrect type for : sasl - base64 encoded String is expected").code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).create();
                        ctx.writeAndFlush((Object)error);
                        return;
                    }
                    byte[] saslResponse = BASE64_DECODER.decode((String)saslObject);
                    try {
                        byte[] saslMessage = ((Authenticator.SaslNegotiator)negotiator.get()).evaluateResponse(saslResponse);
                        if (((Authenticator.SaslNegotiator)negotiator.get()).isComplete()) {
                            AuthenticatedUser user = ((Authenticator.SaslNegotiator)negotiator.get()).getAuthenticatedUser();
                            if (this.authenticationSettings.enableAuditLog) {
                                String address = ctx.channel().remoteAddress().toString();
                                if (address.startsWith("/") && address.length() > 1) {
                                    address = address.substring(1);
                                }
                                String[] authClassParts = this.authenticator.getClass().toString().split("[.]");
                                auditLogger.info("User {} with address {} authenticated by {}", new Object[]{user.getName(), address, authClassParts[authClassParts.length - 1]});
                            }
                            ctx.pipeline().remove((ChannelHandler)this);
                            RequestMessage original = (RequestMessage)request.get();
                            ctx.fireChannelRead((Object)original);
                            break block14;
                        }
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        metadata.put("sasl", BASE64_ENCODER.encodeToString(saslMessage));
                        ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).statusAttributes(metadata).code(ResponseStatusCode.AUTHENTICATE).create();
                        ctx.writeAndFlush((Object)authenticate);
                    }
                    catch (AuthenticationException ae) {
                        ResponseMessage error = ResponseMessage.build((RequestMessage)((RequestMessage)request.get())).statusMessage(ae.getMessage()).code(ResponseStatusCode.UNAUTHORIZED).create();
                        ctx.writeAndFlush((Object)error);
                    }
                } else {
                    ResponseMessage error = ResponseMessage.build((RequestMessage)requestMessage).statusMessage("Failed to authenticate").code(ResponseStatusCode.UNAUTHORIZED).create();
                    ctx.writeAndFlush((Object)error);
                }
            } else {
                logger.warn("{} only processes RequestMessage instances - received {} - channel closing", (Object)((Object)((Object)this)).getClass().getSimpleName(), msg.getClass());
                ctx.close();
            }
        }
    }

    private InetAddress getRemoteInetAddress(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (null == channel) {
            return null;
        }
        SocketAddress genericSocketAddr = channel.remoteAddress();
        if (null == genericSocketAddr || !(genericSocketAddr instanceof InetSocketAddress)) {
            return null;
        }
        return ((InetSocketAddress)genericSocketAddr).getAddress();
    }
}

