/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TimedInterruptTimeoutException;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.ResponseHandlerContext;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.AbstractOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvalOpProcessor
extends AbstractOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEvalOpProcessor.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    public static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    public static final String CONFIG_MAX_PARAMETERS = "maxParameters";
    public static final int DEFAULT_MAX_PARAMETERS = 16;
    protected int maxParameters = 16;
    protected static final Set<String> INVALID_BINDINGS_KEYS = new HashSet<String>();

    protected AbstractEvalOpProcessor(boolean manageTransactions) {
        super(manageTransactions);
    }

    public abstract ThrowingConsumer<Context> getEvalOp();

    public abstract Optional<ThrowingConsumer<Context>> selectOther(RequestMessage var1) throws OpProcessorException;

    @Override
    public ThrowingConsumer<Context> select(Context ctx) throws OpProcessorException {
        ThrowingConsumer<Context> op;
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "eval": {
                op = this.validateEvalMessage(message).orElse(this.getEvalOp());
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgInvalid).create());
            }
            default: {
                op = this.selectOther(message).orElseThrow(() -> {
                    String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                    return new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgDefault).create());
                });
            }
        }
        return op;
    }

    protected Optional<ThrowingConsumer<Context>> validateEvalMessage(RequestMessage message) throws OpProcessorException {
        if (!message.optionalArgs("gremlin").isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "eval", "gremlin");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (message.optionalArgs("bindings").isPresent()) {
            Map bindings = (Map)message.getArgs().get("bindings");
            if (IteratorUtils.anyMatch(bindings.keySet().iterator(), k -> null == k || !(k instanceof String))) {
                String msg = String.format("The [%s] message is using one or more invalid binding keys - they must be of type String and cannot be null", "eval");
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            Set badBindings = IteratorUtils.set((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), INVALID_BINDINGS_KEYS::contains));
            if (!badBindings.isEmpty()) {
                String msg = String.format("The [%s] message supplies one or more invalid parameters key of [%s] - these are reserved names.", "eval", badBindings);
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            if (IteratorUtils.count((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), k -> !k.toString().startsWith("#jsr223"))) > (long)this.maxParameters) {
                String msg = String.format("The [%s] message contains %s bindings which is more than is allowed by the server %s configuration", "eval", bindings.size(), this.maxParameters);
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
        }
        return Optional.empty();
    }

    @Deprecated
    protected void evalOpInternal(ResponseHandlerContext ctx, Supplier<GremlinExecutor> gremlinExecutorSupplier, BindingSupplier bindingsSupplier) throws OpProcessorException {
        this.evalOpInternal(ctx.getContext(), gremlinExecutorSupplier, bindingsSupplier);
    }

    protected void evalOpInternal(Context ctx, Supplier<GremlinExecutor> gremlinExecutorSupplier, BindingSupplier bindingsSupplier) throws OpProcessorException {
        boolean managedTransactionsForRequest;
        Timer.Context timerContext = evalOpTimer.time();
        RequestMessage msg = ctx.getRequestMessage();
        GremlinExecutor gremlinExecutor = gremlinExecutorSupplier.get();
        Settings settings = ctx.getSettings();
        Map args = msg.getArgs();
        String script = (String)args.get("gremlin");
        String language = args.containsKey("language") ? (String)args.get("language") : null;
        SimpleBindings bindings = new SimpleBindings();
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : args.getOrDefault("manageTransaction", false);
        long seto = args.containsKey("scriptEvaluationTimeout") || args.containsKey("evaluationTimeout") ? (args.containsKey("scriptEvaluationTimeout") ? ((Number)args.get("scriptEvaluationTimeout")).longValue() : ((Number)args.get("evaluationTimeout")).longValue()) : settings.getEvaluationTimeout();
        GremlinExecutor.LifeCycle lifeCycle = GremlinExecutor.LifeCycle.build().evaluationTimeoutOverride(Long.valueOf(seto)).afterFailure((b, t) -> {
            if (managedTransactionsForRequest) {
                AbstractEvalOpProcessor.attemptRollback(msg, ctx.getGraphManager(), settings.strictTransactionManagement);
            }
        }).beforeEval(b -> {
            try {
                b.putAll(bindingsSupplier.get());
            }
            catch (OpProcessorException ope) {
                throw new RuntimeException(ope);
            }
        }).withResult(o -> {
            Iterator itty = IteratorUtils.asIterator((Object)o);
            logger.debug("Preparing to iterate results from - {} - in thread [{}]", (Object)msg, (Object)Thread.currentThread().getName());
            if (settings.authentication.enableAuditLog) {
                String address = ctx.getChannelHandlerContext().channel().remoteAddress().toString();
                if (address.startsWith("/") && address.length() > 1) {
                    address = address.substring(1);
                }
                auditLogger.info("User with address {} requested: {}", (Object)address, (Object)script);
            }
            try {
                this.handleIterator(ctx, itty);
            }
            catch (Exception ex) {
                if (managedTransactionsForRequest) {
                    AbstractEvalOpProcessor.attemptRollback(msg, ctx.getGraphManager(), settings.strictTransactionManagement);
                }
                throw new RuntimeException(ex);
            }
        }).create();
        CompletableFuture evalFuture = gremlinExecutor.eval(script, language, (Bindings)bindings, lifeCycle);
        evalFuture.handle((v, t) -> {
            timerContext.stop();
            if (t != null) {
                if (t instanceof OpProcessorException) {
                    ctx.writeAndFlush(((OpProcessorException)t).getResponseMessage());
                } else if (t instanceof TimedInterruptTimeoutException) {
                    String errorMessage = String.format("A timeout occurred within the script during evaluation of [%s] - consider increasing the limit given to TimedInterruptCustomizerProvider", msg);
                    logger.warn(errorMessage);
                    ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage("Timeout during script evaluation triggered by TimedInterruptCustomizerProvider").statusAttributeException(t).create());
                } else if (t instanceof TimeoutException) {
                    String errorMessage = String.format("Script evaluation exceeded the configured threshold for request [%s]", msg);
                    logger.warn(errorMessage, t);
                    ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(t.getMessage()).statusAttributeException(t).create());
                } else if (t instanceof MultipleCompilationErrorsException && t.getMessage().contains("Method code too large!") && ((MultipleCompilationErrorsException)t).getErrorCollector().getErrorCount() == 1) {
                    String errorMessage = String.format("The Gremlin statement that was submitted exceed the maximum compilation size allowed by the JVM, please split it into multiple smaller statements - %s", this.trimMessage(msg));
                    logger.warn(errorMessage);
                    ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SCRIPT_EVALUATION).statusMessage(errorMessage).statusAttributeException(t).create());
                } else {
                    String errorMessage = t.getMessage() == null ? t.toString() : t.getMessage();
                    logger.warn(String.format("Exception processing a script on request [%s].", msg), t);
                    ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SCRIPT_EVALUATION).statusMessage(errorMessage).statusAttributeException(t).create());
                }
            }
            return null;
        });
    }

    private RequestMessage trimMessage(RequestMessage msg) {
        RequestMessage trimmedMsg = RequestMessage.from((RequestMessage)msg).create();
        if (trimmedMsg.getArgs().containsKey("gremlin")) {
            trimmedMsg.getArgs().put("gremlin", trimmedMsg.getArgs().get("gremlin").toString().substring(0, 1021) + "...");
        }
        return trimmedMsg;
    }

    static {
        INVALID_BINDINGS_KEYS.addAll(Arrays.asList(T.id.name(), T.key.name(), T.label.name(), T.value.name(), T.id.getAccessor(), T.key.getAccessor(), T.label.getAccessor(), T.value.getAccessor(), T.id.getAccessor().toUpperCase(), T.key.getAccessor().toUpperCase(), T.label.getAccessor().toUpperCase(), T.value.getAccessor().toUpperCase()));
        for (Column column : Column.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Order.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Operator.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Scope.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Pop.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
    }

    @FunctionalInterface
    public static interface BindingSupplier {
        public Bindings get() throws OpProcessorException;
    }
}

