/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WebSocketHandlerUtil;

@ChannelHandler.Sharable
public class SaslAndHttpBasicAuthenticationHandler
extends SaslAuthenticationHandler {
    private final String HTTP_AUTH = "http-authentication";

    public SaslAndHttpBasicAuthenticationHandler(Authenticator authenticator, Settings.AuthenticationSettings authenticationSettings) {
        super(authenticator, authenticationSettings);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof HttpMessage && !WebSocketHandlerUtil.isWebSocket((HttpMessage)obj)) {
            if (null == ctx.pipeline().get("http-authentication")) {
                ctx.pipeline().addAfter("authenticator", "http-authentication", (ChannelHandler)new HttpBasicAuthenticationHandler(this.authenticator, this.authenticationSettings));
            }
            ctx.fireChannelRead(obj);
        } else {
            super.channelRead(ctx, obj);
        }
    }
}

