/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpMessage;
import org.apache.tinkerpop.gremlin.server.channel.WebSocketChannelizer;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.handler.WebSocketHandlerUtil;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;

@ChannelHandler.Sharable
public class WsAndHttpChannelizerHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketChannelizer wsChannelizer = new WebSocketChannelizer();
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;

    public void init(ServerGremlinExecutor serverGremlinExecutor, HttpGremlinEndpointHandler httpGremlinEndpointHandler) {
        this.wsChannelizer.init(serverGremlinExecutor);
        this.httpGremlinEndpointHandler = httpGremlinEndpointHandler;
    }

    public void configure(ChannelPipeline pipeline) {
        this.wsChannelizer.configure(pipeline);
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (obj instanceof HttpMessage && !WebSocketHandlerUtil.isWebSocket((HttpMessage)obj)) {
            if (null != pipeline.get("authenticator")) {
                pipeline.remove("request-handler");
                ChannelHandler authenticator = pipeline.get("authenticator");
                pipeline.remove("authenticator");
                pipeline.addAfter("http-response-encoder", "authenticator", authenticator);
                pipeline.addAfter("authenticator", "request-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
            } else {
                pipeline.remove("request-handler");
                pipeline.addAfter("http-response-encoder", "request-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
            }
        }
        ctx.fireChannelRead(obj);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

