/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;

public class TraverserIterator
implements Iterator<Object> {
    private final Traversal.Admin traversal;
    private final HaltedTraverserStrategy haltedTraverserStrategy;
    private final TraverserSet bulker = new TraverserSet();
    private final int barrierSize;

    public TraverserIterator(Traversal.Admin traversal) {
        this.traversal = traversal;
        this.barrierSize = traversal.getTraverserRequirements().contains(TraverserRequirement.ONE_BULK) ? 1 : 1000;
        this.haltedTraverserStrategy = traversal.getStrategies().getStrategy(HaltedTraverserStrategy.class).orElse(Boolean.valueOf(System.getProperty("is.testing", "false")) != false ? HaltedTraverserStrategy.detached() : HaltedTraverserStrategy.reference());
    }

    public Traversal.Admin getTraversal() {
        return this.traversal;
    }

    @Override
    public boolean hasNext() {
        if (this.bulker.isEmpty()) {
            this.fillBulker();
        }
        return !this.bulker.isEmpty();
    }

    @Override
    public Object next() {
        if (this.bulker.isEmpty()) {
            this.fillBulker();
        }
        Traverser.Admin t = this.haltedTraverserStrategy.halt(this.bulker.remove());
        return new DefaultRemoteTraverser(t.get(), t.bulk());
    }

    private final void fillBulker() {
        while (this.traversal.hasNext() && this.bulker.size() < this.barrierSize) {
            this.bulker.add(this.traversal.nextTraverser());
        }
    }
}

