/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.standard;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "";
    protected final Function<Context, AbstractEvalOpProcessor.BindingSupplier> bindingMaker = this.getBindingMaker();

    public StandardOpProcessor() {
        super(true);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    public Optional<ThrowingConsumer<Context>> selectOther(RequestMessage requestMessage) throws OpProcessorException {
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
    }

    private void evalOp(Context context) throws OpProcessorException {
        if (logger.isDebugEnabled()) {
            RequestMessage msg = context.getRequestMessage();
            logger.debug("Sessionless request {} for eval in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        }
        this.evalOpInternal(context, context::getGremlinExecutor, this.bindingMaker.apply(context));
    }

    protected Function<Context, AbstractEvalOpProcessor.BindingSupplier> getBindingMaker() {
        return context -> () -> {
            String rebindingOrAliasParameter;
            RequestMessage msg = context.getRequestMessage();
            SimpleBindings bindings = new SimpleBindings();
            boolean hasRebindings = msg.getArgs().containsKey("rebindings");
            boolean hasAliases = msg.getArgs().containsKey("aliases");
            if (hasRebindings && hasAliases) {
                String error = "Prefer use of the 'aliases' parameter over 'rebindings' and do not use both";
                throw new OpProcessorException("Prefer use of the 'aliases' parameter over 'rebindings' and do not use both", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage("Prefer use of the 'aliases' parameter over 'rebindings' and do not use both").create());
            }
            String string = rebindingOrAliasParameter = hasRebindings ? "rebindings" : "aliases";
            if (msg.getArgs().containsKey(rebindingOrAliasParameter)) {
                Map aliases = (Map)msg.getArgs().get(rebindingOrAliasParameter);
                for (Map.Entry aliasKv : aliases.entrySet()) {
                    Map<String, TraversalSource> traversalSources;
                    boolean found = false;
                    Map<String, Graph> graphs = context.getGraphManager().getGraphs();
                    if (graphs.containsKey(aliasKv.getValue())) {
                        bindings.put((String)aliasKv.getKey(), (Object)graphs.get(aliasKv.getValue()));
                        found = true;
                    }
                    if (!found && (traversalSources = context.getGraphManager().getTraversalSources()).containsKey(aliasKv.getValue())) {
                        bindings.put((String)aliasKv.getKey(), (Object)traversalSources.get(aliasKv.getValue()));
                        found = true;
                    }
                    if (found) continue;
                    String error = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", aliasKv.getKey(), aliasKv.getValue(), aliasKv.getValue());
                    throw new OpProcessorException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(error).create());
                }
            } else if (context.getSettings().strictTransactionManagement) {
                String error = "Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided";
                throw new OpProcessorException("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided").create());
            }
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        };
    }
}

