/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.node.ArrayNode;
import org.apache.tinkerpop.shaded.jackson.databind.node.ObjectNode;
import org.javatuples.Pair;
import org.javatuples.Quartet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpGremlinEndpointHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpGremlinEndpointHandler.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    private static final String ARGS_BINDINGS_DOT = "bindings.";
    @Deprecated
    private static final String ARGS_REBINDINGS_DOT = "rebindings.";
    private static final String ARGS_ALIASES_DOT = "aliases.";
    private static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    private final Map<String, MessageSerializer> serializers;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final GremlinExecutor gremlinExecutor;
    private final GraphManager graphManager;
    private final Settings settings;
    private static final Pattern pattern = Pattern.compile("(.*);q=(.*)");

    public HttpGremlinEndpointHandler(Map<String, MessageSerializer> serializers, GremlinExecutor gremlinExecutor, GraphManager graphManager, Settings settings) {
        this.serializers = serializers;
        this.gremlinExecutor = gremlinExecutor;
        this.graphManager = graphManager;
        this.settings = settings;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            Quartet<String, Map<String, Object>, String, Map<String, String>> requestArguments;
            FullHttpRequest req = (FullHttpRequest)msg;
            if ("/favicon.ico".equals(req.getUri())) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND, "Gremlin Server doesn't have a favicon.ico");
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            if (req.getMethod() != HttpMethod.GET && req.getMethod() != HttpMethod.POST) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED.toString());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            try {
                requestArguments = HttpGremlinEndpointHandler.getRequestArguments(req);
            }
            catch (IllegalArgumentException iae) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST, iae.getMessage());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String acceptString = Optional.ofNullable(req.headers().get("Accept")).orElse("application/json");
            Pair<String, MessageTextSerializer> serializer = this.chooseSerializer(acceptString);
            if (null == serializer) {
                HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST, String.format("no serializer for requested Accept header: %s", acceptString));
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String origin = req.headers().get("Origin");
            boolean keepAlive = !HttpHeaders.isKeepAlive((HttpMessage)req);
            ReferenceCountUtil.release((Object)msg);
            try {
                Bindings bindings;
                logger.debug("Processing request containing script [{}] and bindings of [{}] on {}", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), Thread.currentThread().getName()});
                ChannelPromise promise = ctx.channel().newPromise();
                AtomicReference resultHolder = new AtomicReference();
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        logger.debug("Preparing HTTP response for request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), resultHolder.get(), Thread.currentThread().getName()});
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, (ByteBuf)resultHolder.get());
                        response.headers().set("Content-Type", serializer.getValue0());
                        response.headers().set("Content-Length", (Object)response.content().readableBytes());
                        if (origin != null) {
                            response.headers().set("Access-Control-Allow-Origin", (Object)origin);
                        }
                        if (!keepAlive) {
                            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        } else {
                            response.headers().set("Connection", (Object)"keep-alive");
                            ctx.writeAndFlush((Object)response);
                        }
                    }
                });
                Timer.Context timerContext = evalOpTimer.time();
                try {
                    bindings = this.createBindings((Map)requestArguments.getValue1(), (Map)requestArguments.getValue3());
                }
                catch (IllegalStateException iae) {
                    HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST, iae.getMessage());
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                CompletableFuture evalFuture = this.gremlinExecutor.eval((String)requestArguments.getValue0(), (String)requestArguments.getValue2(), (Map)bindings, FunctionUtils.wrapFunction(o -> {
                    timerContext.stop();
                    logger.debug("Transforming result of request with script [{}] and bindings of [{}] with result of [{}] on [{}]", new Object[]{requestArguments.getValue0(), requestArguments.getValue1(), o, Thread.currentThread().getName()});
                    ResponseMessage responseMessage = ResponseMessage.build((UUID)UUID.randomUUID()).code(ResponseStatusCode.SUCCESS).result((Object)IteratorUtils.asList((Object)o)).create();
                    HttpGremlinEndpointHandler.attemptCommit((Map)requestArguments.getValue3(), this.graphManager, this.settings.strictTransactionManagement);
                    try {
                        return Unpooled.wrappedBuffer((byte[])((MessageTextSerializer)serializer.getValue1()).serializeResponseAsString(responseMessage).getBytes(UTF8));
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("Error during serialization for %s", responseMessage), (Throwable)ex);
                        throw ex;
                    }
                }));
                evalFuture.exceptionally(t -> {
                    HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error encountered evaluating script: %s", requestArguments.getValue0()));
                    promise.setFailure(t);
                    return null;
                });
                evalFuture.thenAcceptAsync(r -> {
                    resultHolder.set(r);
                    promise.setSuccess();
                }, (Executor)this.gremlinExecutor.getExecutorService());
            }
            catch (Exception ex) {
                Throwable t2 = ExceptionUtils.getRootCause((Throwable)ex);
                throw new RuntimeException(null == t2 ? ex : t2);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error processing HTTP Request", cause);
        HttpGremlinEndpointHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, cause.getCause().getMessage());
        ctx.close();
    }

    private Bindings createBindings(Map<String, Object> bindingMap, Map<String, String> rebindingMap) {
        SimpleBindings bindings = new SimpleBindings();
        if (!rebindingMap.isEmpty()) {
            for (Map.Entry<String, String> kv : rebindingMap.entrySet()) {
                Map<String, TraversalSource> traversalSources;
                boolean found = false;
                Map<String, Graph> graphs = this.graphManager.getGraphs();
                if (graphs.containsKey(kv.getValue())) {
                    bindings.put(kv.getKey(), (Object)graphs.get(kv.getValue()));
                    found = true;
                }
                if (!found && (traversalSources = this.graphManager.getTraversalSources()).containsKey(kv.getValue())) {
                    bindings.put(kv.getKey(), (Object)traversalSources.get(kv.getValue()));
                    found = true;
                }
                if (found) continue;
                String error = String.format("Could not rebind [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", kv.getKey(), kv.getValue(), kv.getValue());
                throw new IllegalStateException(error);
            }
        }
        bindings.putAll((Map<? extends String, ? extends Object>)bindingMap);
        return bindings;
    }

    private Pair<String, MessageTextSerializer> chooseSerializer(String acceptString) {
        List ordered = Stream.of(acceptString.split(",")).map(mediaType -> {
            Matcher matcher = pattern.matcher((CharSequence)mediaType);
            return matcher.matches() ? Pair.with((Object)matcher.group(1), (Object)Double.parseDouble(matcher.group(2))) : Pair.with((Object)mediaType, (Object)1.0);
        }).sorted((o1, o2) -> ((String)o2.getValue0()).compareTo((String)o1.getValue0())).collect(Collectors.toList());
        for (Pair p : ordered) {
            String accept = ((String)p.getValue0()).equals("*/*") ? "application/json" : (String)p.getValue0();
            if (!this.serializers.containsKey(accept)) continue;
            return Pair.with((Object)accept, (Object)((MessageTextSerializer)this.serializers.get(accept)));
        }
        return null;
    }

    private static Quartet<String, Map<String, Object>, String, Map<String, String>> getRequestArguments(FullHttpRequest request) {
        JsonNode languageNode;
        JsonNode body;
        if (request.getMethod() == HttpMethod.GET) {
            QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
            List gremlinParms = (List)decoder.parameters().get("gremlin");
            if (null == gremlinParms || gremlinParms.size() == 0) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            String script = (String)gremlinParms.get(0);
            if (script.isEmpty()) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            HashMap bindings = new HashMap();
            decoder.parameters().entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith(ARGS_BINDINGS_DOT)).forEach(kv -> bindings.put(((String)kv.getKey()).substring(ARGS_BINDINGS_DOT.length()), ((List)kv.getValue()).get(0)));
            boolean hasRebindings = decoder.parameters().entrySet().stream().anyMatch(kv -> ((String)kv.getKey()).startsWith(ARGS_REBINDINGS_DOT));
            boolean hasAliases = decoder.parameters().entrySet().stream().anyMatch(kv -> ((String)kv.getKey()).startsWith(ARGS_ALIASES_DOT));
            if (hasRebindings && hasAliases) {
                throw new IllegalArgumentException("prefer use of the 'aliases' parameter over 'rebindings' and do not use both");
            }
            HashMap aliases = new HashMap();
            String rebindingOrAliasParameter = hasRebindings ? ARGS_REBINDINGS_DOT : ARGS_ALIASES_DOT;
            decoder.parameters().entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith(rebindingOrAliasParameter)).forEach(kv -> {
                String cfr_ignored_0 = (String)aliases.put(((String)kv.getKey()).substring(rebindingOrAliasParameter.length()), ((List)kv.getValue()).get(0));
            });
            List languageParms = (List)decoder.parameters().get("language");
            String language = null == languageParms || languageParms.size() == 0 ? null : (String)languageParms.get(0);
            return Quartet.with((Object)script, bindings, (Object)language, aliases);
        }
        try {
            body = mapper.readTree(request.content().toString(CharsetUtil.UTF_8));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("body could not be parsed", ioe);
        }
        JsonNode scriptNode = body.get("gremlin");
        if (null == scriptNode) {
            throw new IllegalArgumentException("no gremlin script supplied");
        }
        JsonNode bindingsNode = body.get("bindings");
        if (bindingsNode != null && !bindingsNode.isObject()) {
            throw new IllegalArgumentException("bindings must be a Map");
        }
        HashMap bindings = new HashMap();
        if (bindingsNode != null) {
            bindingsNode.fields().forEachRemaining(kv -> bindings.put(kv.getKey(), HttpGremlinEndpointHandler.fromJsonNode((JsonNode)kv.getValue())));
        }
        boolean hasRebindings = body.has("rebindings");
        boolean hasAliases = body.has("aliases");
        if (hasRebindings && hasAliases) {
            throw new IllegalArgumentException("prefer use of the 'aliases' parameter over 'rebindings' and do not use both");
        }
        String rebindingOrAliasParameter = hasRebindings ? "rebindings" : "aliases";
        JsonNode aliasesNode = body.get(rebindingOrAliasParameter);
        if (aliasesNode != null && !aliasesNode.isObject()) {
            throw new IllegalArgumentException("aliases must be a Map");
        }
        HashMap aliases = new HashMap();
        if (aliasesNode != null) {
            aliasesNode.fields().forEachRemaining(kv -> aliases.put(kv.getKey(), ((JsonNode)kv.getValue()).asText()));
        }
        String language = null == (languageNode = body.get("language")) ? null : languageNode.asText();
        return Quartet.with((Object)scriptNode.asText(), bindings, (Object)language, aliases);
    }

    public static Object fromJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, HttpGremlinEndpointHandler.fromJsonNode(objectNode.get(key)));
            }
            return map;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                array.add(HttpGremlinEndpointHandler.fromJsonNode(arrayNode.get(i)));
            }
            return array;
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asText();
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        logger.warn("Invalid request - responding with {} and {}", (Object)status, (Object)message);
        errorMeter.mark();
        ObjectNode node = mapper.createObjectNode();
        node.put("message", message);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)node.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"application/json");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void attemptCommit(Map<String, String> aliases, GraphManager graphManager, boolean strict) {
        if (strict) {
            graphManager.commit(new HashSet<String>(aliases.values()));
        } else {
            graphManager.commitAll();
        }
    }
}

