/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;

public class HttpBasicAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Authenticator authenticator;
    private final Base64.Decoder decoder = Base64.getUrlDecoder();

    public HttpBasicAuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage request = (FullHttpMessage)msg;
            if (!request.headers().contains("Authorization")) {
                this.sendError(ctx, msg);
                return;
            }
            String basic = "Basic ";
            String authorizationHeader = request.headers().get("Authorization");
            if (!authorizationHeader.startsWith("Basic ")) {
                this.sendError(ctx, msg);
                return;
            }
            byte[] decodedUserPass = null;
            try {
                String encodedUserPass = authorizationHeader.substring("Basic ".length());
                decodedUserPass = this.decoder.decode(encodedUserPass);
            }
            catch (IndexOutOfBoundsException iae) {
                this.sendError(ctx, msg);
                return;
            }
            catch (IllegalArgumentException iae) {
                this.sendError(ctx, msg);
                return;
            }
            String authorization = new String(decodedUserPass, Charset.forName("UTF-8"));
            String[] split = authorization.split(":");
            if (split.length != 2) {
                this.sendError(ctx, msg);
                return;
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", split[0]);
            credentials.put("password", split[1]);
            try {
                this.authenticator.authenticate(credentials);
                ctx.fireChannelRead((Object)request);
            }
            catch (AuthenticationException ae) {
                this.sendError(ctx, msg);
            }
        }
    }

    private void sendError(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ReferenceCountUtil.release((Object)msg);
    }
}

