/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NioGremlinResponseEncoder
extends MessageToByteEncoder<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(NioGremlinResponseEncoder.class);
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));

    protected void encode(ChannelHandlerContext ctx, ResponseMessage responseMessage, ByteBuf byteBuf) throws Exception {
        MessageSerializer serializer = (MessageSerializer)ctx.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)ctx.channel().attr(StateKey.USE_BINARY).get();
        try {
            if (!responseMessage.getStatus().getCode().isSuccess()) {
                errorMeter.mark();
            }
            if (useBinary) {
                ByteBuf bytes = serializer.serializeResponseAsBinary(responseMessage, ctx.alloc());
                byteBuf.writeInt(bytes.capacity());
                byteBuf.writeBytes(bytes);
                bytes.release();
            } else {
                MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
                byte[] bytes = textSerializer.serializeResponseAsString(responseMessage).getBytes(CharsetUtil.UTF_8);
                byteBuf.writeInt(bytes.length);
                byteBuf.writeBytes(bytes);
            }
        }
        catch (Exception ex) {
            errorMeter.mark();
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{responseMessage.getResult(), responseMessage.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            ResponseMessage error = ResponseMessage.build((UUID)responseMessage.getRequestId()).statusMessage(errorMessage).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            if (useBinary) {
                ByteBuf bytes = serializer.serializeResponseAsBinary(error, ctx.alloc());
                byteBuf.writeInt(bytes.capacity());
                byteBuf.writeBytes(bytes);
                bytes.release();
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            byte[] bytes = textSerializer.serializeResponseAsString(error).getBytes(CharsetUtil.UTF_8);
            byteBuf.writeInt(bytes.length);
            byteBuf.writeBytes(bytes);
        }
    }
}

