/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(HttpChannelizer.class);
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;
    private HttpBasicAuthenticationHandler authenticationHandler;

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.httpGremlinEndpointHandler = new HttpGremlinEndpointHandler(this.serializers, this.gremlinExecutor, this.graphManager);
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-server", (ChannelHandler)new HttpServerCodec());
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("http-io", LogLevel.DEBUG)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.settings.maxContentLength)});
        if (this.authenticator != null) {
            HttpBasicAuthenticationHandler httpBasicAuthenticationHandler = this.authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : new HttpBasicAuthenticationHandler(this.authenticator);
            if (this.authenticationHandler != null) {
                pipeline.addLast("authenticator", (ChannelHandler)this.authenticationHandler);
            }
        }
        pipeline.addLast("http-gremlin-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
    }

    @Override
    public void finalize(ChannelPipeline pipeline) {
        pipeline.remove("op-selector");
        pipeline.remove("result-iterator-handler");
        pipeline.remove("op-executor");
    }
}

